/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bag.covidcertificate.sdk.core.verifier.nationalrules.certlogic;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000f\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a.\u0010\u0004\u001a\u00020\u0005\"\u000e\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00072\u0006\u0010\b\u001a\u00020\u00012\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00060\nH\u0000\u001a\u0010\u0010\u000b\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001H\u0000\u001a\u001c\u0010\f\u001a\u0004\u0018\u00010\u00012\b\u0010\r\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a \u0010\u0010\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000fH\u0000\u001a\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u001a\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0017"}, d2={"optionalPrefix", "", "getOptionalPrefix", "()Ljava/lang/String;", "compare", "", "T", "", "operator", "args", "", "comparisonOperatorForDateTimeComparison", "extractFromUVCI", "uvci", "index", "", "intCompare", "l", "r", "isFalsy", "value", "Lcom/fasterxml/jackson/databind/JsonNode;", "isTruthy", "CovidCertificate-SDK-Kotlin"})
public final class InternalsKt {
    @NotNull
    private static final String optionalPrefix = "URN:UVCI:";

    public static final boolean isFalsy(@NotNull JsonNode value) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        JsonNode jsonNode = value;
        if (jsonNode instanceof BooleanNode) {
            bl = Intrinsics.areEqual((Object)value, (Object)BooleanNode.FALSE);
        } else if (jsonNode instanceof NullNode) {
            bl = true;
        } else if (jsonNode instanceof TextNode) {
            String string = value.textValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value.textValue()");
            bl = ((CharSequence)string).length() == 0;
        } else {
            bl = jsonNode instanceof IntNode ? value.intValue() == 0 : (jsonNode instanceof ArrayNode ? value.size() == 0 : (jsonNode instanceof ObjectNode ? value.size() == 0 : false));
        }
        return bl;
    }

    public static final boolean isTruthy(@NotNull JsonNode value) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        JsonNode jsonNode = value;
        if (jsonNode instanceof BooleanNode) {
            bl = Intrinsics.areEqual((Object)value, (Object)BooleanNode.TRUE);
        } else if (jsonNode instanceof TextNode) {
            String string = value.textValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value.textValue()");
            bl = ((CharSequence)string).length() > 0;
        } else {
            bl = jsonNode instanceof IntNode ? value.intValue() != 0 : (jsonNode instanceof ArrayNode ? value.size() > 0 : (jsonNode instanceof ObjectNode ? value.size() > 0 : false));
        }
        return bl;
    }

    public static final boolean intCompare(@NotNull String operator, int l, int r) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)operator, (String)"operator");
        switch (operator) {
            case "<": {
                if (l < r) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case ">": {
                if (l > r) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case "<=": {
                if (l <= r) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case ">=": {
                if (l >= r) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                throw new RuntimeException("unhandled comparison operator \"" + operator + '\"');
            }
        }
        return bl;
    }

    public static final <T extends Comparable<? super T>> boolean compare(@NotNull String operator, @NotNull List<? extends T> args) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)operator, (String)"operator");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        switch (args.size()) {
            case 2: {
                bl = InternalsKt.intCompare(operator, ((Comparable)args.get(0)).compareTo(args.get(1)), 0);
                break;
            }
            case 3: {
                if (InternalsKt.intCompare(operator, ((Comparable)args.get(0)).compareTo(args.get(1)), 0) && InternalsKt.intCompare(operator, ((Comparable)args.get(1)).compareTo(args.get(2)), 0)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                throw new RuntimeException("invalid number of operands to a \"" + operator + "\" operation");
            }
        }
        return bl;
    }

    @NotNull
    public static final String comparisonOperatorForDateTimeComparison(@NotNull String operator) {
        String string;
        Intrinsics.checkNotNullParameter((Object)operator, (String)"operator");
        switch (operator) {
            case "after": {
                string = ">";
                break;
            }
            case "before": {
                string = "<";
                break;
            }
            case "not-after": {
                string = "<=";
                break;
            }
            case "not-before": {
                string = ">=";
                break;
            }
            default: {
                throw new RuntimeException("unhandled date-time comparison operator \"" + operator + '\"');
            }
        }
        return string;
    }

    @NotNull
    public static final String getOptionalPrefix() {
        return optionalPrefix;
    }

    @Nullable
    public static final String extractFromUVCI(@Nullable String uvci, int index) {
        String string;
        String string2;
        if (uvci == null || index < 0) {
            return null;
        }
        if (StringsKt.startsWith$default((String)uvci, (String)optionalPrefix, (boolean)false, (int)2, null)) {
            string2 = uvci.substring(optionalPrefix.length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            string = string2;
        } else {
            string = uvci;
        }
        String prefixlessUvci = string;
        CharSequence charSequence = prefixlessUvci;
        string2 = new Regex("[/#:]");
        int n = 0;
        List fragments = string2.split(charSequence, n);
        return index < fragments.size() ? (String)fragments.get(index) : null;
    }
}

