/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bag.covidcertificate.sdk.core.verifier.nationalrules.certlogic;

import ch.admin.bag.covidcertificate.sdk.core.verifier.nationalrules.certlogic.TimeUnit;
import ch.admin.bag.covidcertificate.sdk.core.verifier.nationalrules.certlogic.ValidationError;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a&\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0000\u00a8\u0006\u0010"}, d2={"validate", "", "Lch/admin/bag/covidcertificate/sdk/core/verifier/nationalrules/certlogic/ValidationError;", "expr", "Lcom/fasterxml/jackson/databind/JsonNode;", "validateExtractFromUVCI", "values", "Lcom/fasterxml/jackson/databind/node/ArrayNode;", "validateIf", "validateInfix", "operator", "", "validateNot", "validatePlusTime", "validateReduce", "validateVar", "CovidCertificate-SDK-Kotlin"})
public final class ValidatorKt {
    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final List<ValidationError> validateVar(@NotNull JsonNode expr, @NotNull JsonNode values) {
        List list;
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        if (!(values instanceof TextNode)) {
            return CollectionsKt.listOf((Object)new ValidationError(expr, "not of the form { \"var\": \"<path>\" }"));
        }
        String path = values.asText();
        if (!Intrinsics.areEqual((Object)path, (Object)"")) {
            Regex regex = new Regex("^([^\\.]+?)(\\.[^\\.]+?)*$");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
            if (!regex.matches((CharSequence)path)) {
                list = CollectionsKt.listOf((Object)new ValidationError(expr, Intrinsics.stringPlus((String)"data access path doesn't have a valid format: ", (Object)path)));
                return list;
            }
        }
        list = CollectionsKt.emptyList();
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ValidationError> validateIf(@NotNull JsonNode expr, @NotNull ArrayNode values) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        Iterable iterable = CollectionsKt.toList((Iterable)((Iterable)values)).subList(0, 3);
        Collection collection = values.size() == 3 ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)new ValidationError(expr, Intrinsics.stringPlus((String)"an \"if\"-operation must have exactly 3 values/operands, but it has ", (Object)values.size())));
        boolean $i$f$flatMap = false;
        void var4_5 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            JsonNode it = (JsonNode)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            Iterable list$iv$iv = ValidatorKt.validate(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ValidationError> validateInfix(@NotNull JsonNode expr, @NotNull ArrayNode values, @NotNull String operator) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        List list;
        int n;
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        Intrinsics.checkNotNullParameter((Object)operator, (String)"operator");
        int nOperands = values.size();
        switch (operator) {
            case "and": {
                n = nOperands;
                break;
            }
            case "<=": 
            case "before": 
            case "after": 
            case "<": 
            case "not-after": 
            case "not-before": 
            case ">": 
            case ">=": {
                n = 3;
                break;
            }
            default: {
                n = 2;
            }
        }
        int maxOperands = n;
        switch (operator) {
            case "and": {
                if (nOperands < 2) {
                    list = CollectionsKt.listOf((Object)new ValidationError(expr, Intrinsics.stringPlus((String)"an \"and\" operation must have at least 2 operands, but it has ", (Object)values.size())));
                    break;
                }
                list = CollectionsKt.emptyList();
                break;
            }
            case "<=": 
            case "before": 
            case "after": 
            case "<": 
            case "not-after": 
            case "not-before": 
            case ">": 
            case ">=": {
                if (nOperands < 2 || nOperands > 3) {
                    list = CollectionsKt.listOf((Object)new ValidationError(expr, "an operation with operator \"" + operator + "\" must have 2 or 3 operands, but it has " + values.size()));
                    break;
                }
                list = CollectionsKt.emptyList();
                break;
            }
            default: {
                list = nOperands != 2 ? CollectionsKt.listOf((Object)new ValidationError(expr, "an operation with operator \"" + operator + "\" must have 2 operands, but it has " + values.size())) : CollectionsKt.emptyList();
            }
        }
        Object object = CollectionsKt.take((Iterable)((Iterable)values), (int)Math.min(maxOperands, nOperands));
        Collection collection = list;
        boolean $i$f$flatMap = false;
        void var7_8 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            JsonNode it = (JsonNode)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            Iterable list$iv$iv = ValidatorKt.validate(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public static final List<ValidationError> validateNot(@NotNull JsonNode expr, @NotNull ArrayNode values) {
        List list;
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        if (values.size() == 1) {
            JsonNode jsonNode = values.get(0);
            Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"values[0]");
            list = ValidatorKt.validate(jsonNode);
        } else {
            list = CollectionsKt.listOf((Object)new ValidationError(expr, Intrinsics.stringPlus((String)"a !-operation (logical not/negation) must have exactly 1 operand, but it has ", (Object)values.size())));
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ValidationError> validatePlusTime(@NotNull JsonNode expr, @NotNull ArrayNode values) {
        List list;
        List<ValidationError> list2;
        TimeUnit[] timeUnitArray;
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        Collection collection = values.size() == 3 ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)new ValidationError(expr, Intrinsics.stringPlus((String)"a \"plusTime\"-operation must have exactly 3 values/operands, but it has ", (Object)values.size())));
        if (values.has(0)) {
            timeUnitArray = values.get(0);
            Intrinsics.checkNotNullExpressionValue((Object)timeUnitArray, (String)"values[0]");
            list2 = ValidatorKt.validate((JsonNode)timeUnitArray);
        } else {
            list2 = CollectionsKt.emptyList();
        }
        Collection collection2 = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)collection, (Iterable)list2), (Iterable)(values.has(1) && !values.get(1).isInt() ? CollectionsKt.listOf((Object)new ValidationError(expr, Intrinsics.stringPlus((String)"\"amount\" argument (#2) of \"plusTime\" must be an integer, but it is: ", (Object)values.get(1)))) : CollectionsKt.emptyList()));
        if (values.has(2) && !TimeUnit.isTimeUnitName(values.get(2).asText())) {
            Collection<String> collection3;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            timeUnitArray = TimeUnit.values();
            StringBuilder stringBuilder = new StringBuilder().append("\"unit\" argument (#3) of \"plusTime\" must be a string equal to one of ");
            JsonNode jsonNode = expr;
            Collection collection4 = collection2;
            boolean $i$f$map = false;
            void var4_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                void var11_14 = item$iv$iv;
                collection3 = destination$iv$iv;
                boolean bl = false;
                collection3.add(it.name());
            }
            collection3 = (List)destination$iv$iv;
            collection2 = collection4;
            String string = stringBuilder.append(CollectionsKt.joinToString$default((Iterable)collection3, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)).append(", but it is: ").append(values.get(2)).toString();
            JsonNode jsonNode2 = jsonNode;
            list = CollectionsKt.listOf((Object)new ValidationError(jsonNode2, string));
        } else {
            list = CollectionsKt.emptyList();
        }
        return CollectionsKt.plus((Collection)collection2, (Iterable)list);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ValidationError> validateReduce(@NotNull JsonNode expr, @NotNull ArrayNode values) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        Iterable iterable = CollectionsKt.toList((Iterable)((Iterable)values)).subList(0, 3);
        Collection collection = values.size() == 3 ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)new ValidationError(expr, Intrinsics.stringPlus((String)"an \"reduce\"-operation must have exactly 3 values/operands, but it has ", (Object)values.size())));
        boolean $i$f$flatMap = false;
        void var4_5 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            JsonNode it = (JsonNode)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            Iterable list$iv$iv = ValidatorKt.validate(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public static final List<ValidationError> validateExtractFromUVCI(@NotNull JsonNode expr, @NotNull ArrayNode values) {
        List<ValidationError> list;
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        Collection collection = values.size() == 2 ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)new ValidationError(expr, Intrinsics.stringPlus((String)"an \"extractFromUVCI\"-operation must have exactly 2 values/operands, but it has ", (Object)values.size())));
        if (values.has(0)) {
            JsonNode jsonNode = values.get(0);
            Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"values[0]");
            list = ValidatorKt.validate(jsonNode);
        } else {
            list = CollectionsKt.emptyList();
        }
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)collection, (Iterable)list), (Iterable)(values.has(1) && !(values.get(1) instanceof IntNode) ? CollectionsKt.listOf((Object)new ValidationError(expr, Intrinsics.stringPlus((String)"\"index\" argument (#2) of \"extractFromUVCI\" must be an integer, but it is: ", (Object)values.get(1)))) : CollectionsKt.emptyList()));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final List<ValidationError> validate(@NotNull JsonNode expr) {
        List<ValidationError> list;
        List list2;
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        JsonNode jsonNode = expr;
        if ((jsonNode instanceof TextNode ? true : jsonNode instanceof IntNode) ? true : jsonNode instanceof BooleanNode) {
            list2 = CollectionsKt.emptyList();
            return list2;
        }
        if (jsonNode instanceof NumericNode) {
            list2 = ValidatorKt.validate$withError(expr, expr + " is a non-integer number");
            return list2;
        }
        if (jsonNode instanceof NullNode) {
            list2 = ValidatorKt.validate$withError(expr, "invalid CertLogic expression");
            return list2;
        }
        if (jsonNode instanceof ArrayNode) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = (Iterable)expr;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator = $this$flatMapTo$iv$iv.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    list2 = (List)destination$iv$iv;
                    return list2;
                }
                Object element$iv$iv = iterator.next();
                JsonNode it = (JsonNode)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                Iterable list$iv$iv = ValidatorKt.validate(it);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
        }
        if (!(jsonNode instanceof ObjectNode)) {
            list2 = ValidatorKt.validate$withError(expr, "invalid CertLogic expression");
            return list2;
        }
        if (expr.size() != 1) {
            return ValidatorKt.validate$withError(expr, Intrinsics.stringPlus((String)"expression object must have exactly one key, but it has ", (Object)expr.size()));
        }
        Map.Entry entry = (Map.Entry)expr.fields().next();
        Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"next()");
        String operator = (String)entry.getKey();
        JsonNode args = (JsonNode)entry.getValue();
        if (Intrinsics.areEqual((Object)operator, (Object)"var")) {
            Intrinsics.checkNotNullExpressionValue((Object)args, (String)"args");
            return ValidatorKt.validateVar(expr, args);
        }
        if (!(args instanceof ArrayNode)) return ValidatorKt.validate$withError(expr, "operation not of the form { \"<operator>\": [ <values...> ] }");
        if (args.size() <= 0) {
            return ValidatorKt.validate$withError(expr, "operation not of the form { \"<operator>\": [ <values...> ] }");
        }
        String string = operator;
        if (string != null) {
            int n = -1;
            switch (string.hashCode()) {
                case -1849165945: {
                    if (!string.equals("plusTime")) break;
                    n = 1;
                    break;
                }
                case -934873754: {
                    if (!string.equals("reduce")) break;
                    n = 2;
                    break;
                }
                case 1921: {
                    if (!string.equals("<=")) break;
                    n = 3;
                    break;
                }
                case 33: {
                    if (!string.equals("!")) break;
                    n = 4;
                    break;
                }
                case 3365: {
                    if (!string.equals("in")) break;
                    n = 3;
                    break;
                }
                case -1392885889: {
                    if (!string.equals("before")) break;
                    n = 3;
                    break;
                }
                case 43: {
                    if (!string.equals("+")) break;
                    n = 3;
                    break;
                }
                case 179182178: {
                    if (!string.equals("not-after")) break;
                    n = 3;
                    break;
                }
                case 1286978489: {
                    if (!string.equals("not-before")) break;
                    n = 3;
                    break;
                }
                case -1614982894: {
                    if (!string.equals("extractFromUVCI")) break;
                    n = 5;
                    break;
                }
                case 96727: {
                    if (!string.equals("and")) break;
                    n = 3;
                    break;
                }
                case 92734940: {
                    if (!string.equals("after")) break;
                    n = 3;
                    break;
                }
                case 60: {
                    if (!string.equals("<")) break;
                    n = 3;
                    break;
                }
                case 3357: {
                    if (!string.equals("if")) break;
                    n = 6;
                    break;
                }
                case 60573: {
                    if (!string.equals("===")) break;
                    n = 3;
                    break;
                }
                case 62: {
                    if (!string.equals(">")) break;
                    n = 3;
                    break;
                }
                case 1983: {
                    if (!string.equals(">=")) break;
                    n = 3;
                    break;
                }
            }
            switch (n) {
                case 6: {
                    list = ValidatorKt.validateIf(expr, (ArrayNode)args);
                    return list;
                }
                case 3: {
                    ArrayNode arrayNode = (ArrayNode)args;
                    Intrinsics.checkNotNullExpressionValue((Object)operator, (String)"operator");
                    list = ValidatorKt.validateInfix(expr, arrayNode, operator);
                    return list;
                }
                case 4: {
                    list = ValidatorKt.validateNot(expr, (ArrayNode)args);
                    return list;
                }
                case 1: {
                    list = ValidatorKt.validatePlusTime(expr, (ArrayNode)args);
                    return list;
                }
                case 2: {
                    list = ValidatorKt.validateReduce(expr, (ArrayNode)args);
                    return list;
                }
                case 5: {
                    list = ValidatorKt.validateExtractFromUVCI(expr, (ArrayNode)args);
                    return list;
                }
            }
        }
        list = ValidatorKt.validate$withError(expr, "unrecognised operator: \"" + operator + '\"');
        return list;
    }

    private static final List<ValidationError> validate$withError(JsonNode $expr, String message) {
        return CollectionsKt.listOf((Object)new ValidationError($expr, message));
    }
}

