/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bag.covidcertificate.sdk.core.decoder.chain;

import ch.admin.bag.covidcertificate.sdk.core.models.healthcert.CertType;
import ch.admin.bag.covidcertificate.sdk.core.models.healthcert.CertificateHolder;
import ch.admin.bag.covidcertificate.sdk.core.models.healthcert.eu.DccCert;
import ch.admin.bag.covidcertificate.sdk.core.models.healthcert.eu.RecoveryEntry;
import ch.admin.bag.covidcertificate.sdk.core.models.healthcert.eu.TestEntry;
import ch.admin.bag.covidcertificate.sdk.core.models.healthcert.eu.VaccinationEntry;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lch/admin/bag/covidcertificate/sdk/core/decoder/chain/CertTypeService;", "", "()V", "decode", "Lch/admin/bag/covidcertificate/sdk/core/models/healthcert/CertType;", "certificateHolder", "Lch/admin/bag/covidcertificate/sdk/core/models/healthcert/CertificateHolder;", "CovidCertificate-SDK-Kotlin"})
public final class CertTypeService {
    @NotNull
    public static final CertTypeService INSTANCE = new CertTypeService();

    private CertTypeService() {
    }

    @Nullable
    public final CertType decode(@NotNull CertificateHolder certificateHolder) {
        Intrinsics.checkNotNullParameter((Object)certificateHolder, (String)"certificateHolder");
        CertType type = null;
        int numContainedContent = 0;
        if (certificateHolder.containsChLightCert()) {
            numContainedContent = 1;
            type = CertType.LIGHT;
        } else if (certificateHolder.containsDccCert()) {
            Integer n;
            Integer n2;
            DccCert dccCert = (DccCert)certificateHolder.getCertificate();
            List<TestEntry> list = dccCert.getTests();
            if (list != null) {
                n = n2 = Integer.valueOf(list.size());
                int numTests = ((Number)n).intValue();
                boolean bl = false;
                if (numTests > 0) {
                    numContainedContent += numTests;
                    type = CertType.TEST;
                }
            }
            List<RecoveryEntry> list2 = dccCert.getPastInfections();
            if (list2 != null) {
                n = n2 = Integer.valueOf(list2.size());
                int numRecoveries = ((Number)n).intValue();
                boolean bl = false;
                if (numRecoveries > 0) {
                    numContainedContent += numRecoveries;
                    type = CertType.RECOVERY;
                }
            }
            List<VaccinationEntry> list3 = dccCert.getVaccinations();
            if (list3 != null) {
                n = n2 = Integer.valueOf(list3.size());
                int numVaccinations = ((Number)n).intValue();
                boolean bl = false;
                if (numVaccinations > 0) {
                    numContainedContent += numVaccinations;
                    type = CertType.VACCINATION;
                }
            }
        }
        return numContainedContent >= 1 ? type : null;
    }
}

