/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bag.covidcertificate.sdk.core.decoder.chain;

import COSE.HeaderKeys;
import COSE.Message;
import COSE.MessageTag;
import COSE.OneKey;
import COSE.Sign1Message;
import ch.admin.bag.covidcertificate.sdk.core.models.healthcert.CertType;
import ch.admin.bag.covidcertificate.sdk.core.models.trustlist.Jwk;
import com.upokecenter.cbor.CBORObject;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lch/admin/bag/covidcertificate/sdk/core/decoder/chain/VerificationCoseService;", "", "()V", "decode", "", "keys", "", "Lch/admin/bag/covidcertificate/sdk/core/models/trustlist/Jwk;", "input", "", "certType", "Lch/admin/bag/covidcertificate/sdk/core/models/healthcert/CertType;", "CovidCertificate-SDK-Kotlin"})
public final class VerificationCoseService {
    @NotNull
    public static final VerificationCoseService INSTANCE = new VerificationCoseService();

    private VerificationCoseService() {
    }

    /*
     * WARNING - void declaration
     */
    public final boolean decode(@NotNull List<Jwk> keys, @NotNull byte[] input, @NotNull CertType certType) {
        boolean bl;
        block14: {
            void $this$any$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            Object it;
            Iterable $this$filterTo$iv$iv;
            Sign1Message sign1Message;
            Intrinsics.checkNotNullParameter(keys, (String)"keys");
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter((Object)((Object)certType), (String)"certType");
            try {
                Message message = Sign1Message.DecodeFromBytes((byte[])input, (MessageTag)MessageTag.Sign1);
                if (message == null) {
                    throw new NullPointerException("null cannot be cast to non-null type COSE.Sign1Message");
                }
                sign1Message = (Sign1Message)message;
            }
            catch (Throwable e) {
                sign1Message = null;
            }
            Sign1Message sign1Message2 = sign1Message;
            if (sign1Message2 == null) {
                return false;
            }
            Sign1Message signature = sign1Message2;
            CBORObject cBORObject = signature.getProtectedAttributes().get(HeaderKeys.KID.AsCBOR());
            byte[] byArray = (byte[])(cBORObject == null ? null : cBORObject.GetByteString());
            if (byArray == null) {
                CBORObject cBORObject2 = signature.getUnprotectedAttributes().get(HeaderKeys.KID.AsCBOR());
                Object object = e = (Object)(cBORObject2 == null ? null : cBORObject2.GetByteString());
                if (e == null) {
                    return false;
                }
                byArray = e;
            }
            byte[] kid = byArray;
            Iterable $this$filter$iv = keys;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Jwk)element$iv$iv;
                boolean bl2 = false;
                if (!Arrays.equals(((Jwk)it).getKid(), kid)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Jwk)element$iv$iv;
                boolean bl3 = false;
                if (!((Jwk)it).isAllowedToSign(certType)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$filterTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            it = $this$forEach$iv$iv$iv.iterator();
            while (it.hasNext()) {
                PublicKey it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = it.next();
                boolean bl4 = false;
                Jwk it2 = (Jwk)element$iv$iv;
                boolean bl5 = false;
                if (it2.getPublicKey() == null) continue;
                boolean bl6 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl7;
                    PublicKey pk = (PublicKey)element$iv;
                    boolean bl8 = false;
                    try {
                        OneKey pubKey = new OneKey(pk, null);
                        bl7 = signature.validate(pubKey);
                    }
                    catch (Throwable t) {
                        bl7 = false;
                    }
                    if (!bl7) continue;
                    bl = true;
                    break block14;
                }
                bl = false;
            }
        }
        return bl;
    }

    static {
        Security.removeProvider("BC");
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

