/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bag.covidcertificate.sdk.core.verifier.nationalrules.certlogic;

import ch.admin.bag.covidcertificate.sdk.core.verifier.nationalrules.certlogic.TimeUnit;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ValueNode;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class JsonDateTime
extends ValueNode
implements Comparable<JsonDateTime> {
    private static final long serialVersionUID = 1L;
    private final OffsetDateTime _value;
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZZZZZ");

    public static JsonDateTime fromString(String str) {
        if (str.matches("^\\d{4}-\\d{2}-\\d{2}$")) {
            return JsonDateTime.fromStringInternal(str + "T00:00:00Z");
        }
        Pattern pattern = Pattern.compile("^(\\d{4})-(\\d{2})-(\\d{2})T(\\d{2}):(\\d{2}):(\\d{2})(\\.\\d+?)?(Z|(([+-])(\\d{1,2}):?(\\d{2})?))?$");
        Matcher matcher = pattern.matcher(str);
        if (matcher.matches()) {
            String reformatted = String.format("%s-%s-%sT%s:%s:%s", matcher.group(1), matcher.group(2), matcher.group(3), matcher.group(4), matcher.group(5), matcher.group(6));
            if (matcher.group(7) != null) {
                reformatted = reformatted + String.format("%-4s", matcher.group(7)).replace(' ', '0').substring(0, 4);
            }
            reformatted = matcher.group(8) == null || matcher.group(8).equals("Z") ? reformatted + "Z" : reformatted + matcher.group(10) + String.format("%2s", matcher.group(11)).replaceAll(" ", "0") + ":" + (matcher.group(12) != null ? matcher.group(12) : "00");
            return JsonDateTime.fromStringInternal(reformatted);
        }
        throw new DateTimeParseException("not an allowed date or date-time format", str, 0);
    }

    private static JsonDateTime fromStringInternal(String dateTimeString) {
        return new JsonDateTime(OffsetDateTime.parse(dateTimeString));
    }

    public OffsetDateTime temporalValue() {
        return this._value;
    }

    protected JsonDateTime(OffsetDateTime dateTime) {
        this._value = dateTime;
    }

    public JsonDateTime plusTime(int amount, TimeUnit unit) {
        if (amount == 0) {
            return this;
        }
        switch (unit) {
            case day: {
                return new JsonDateTime(this._value.plusDays(amount));
            }
            case hour: {
                return new JsonDateTime(this._value.plusHours(amount));
            }
            case month: {
                return new JsonDateTime(this._value.plusMonths(amount));
            }
            case year: {
                return new JsonDateTime(this._value.plusYears(amount));
            }
        }
        throw new RuntimeException(String.format("time unit \"%s\" not handled", new Object[]{unit}));
    }

    @Override
    public int compareTo(@NotNull JsonDateTime o) {
        return this._value.compareTo(o._value);
    }

    public int hashCode() {
        return this._value.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof JsonDateTime && this.compareTo((JsonDateTime)o) == 0;
    }

    public JsonToken asToken() {
        return null;
    }

    public void serialize(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
    }

    public JsonNodeType getNodeType() {
        return JsonNodeType.OBJECT;
    }

    public String asText() {
        return formatter.format(this._value);
    }
}

