/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bag.covidcertificate.sdk.core.verifier.nationalrules;

import ch.admin.bag.covidcertificate.sdk.core.extensions.TestEntryExtensionsKt;
import ch.admin.bag.covidcertificate.sdk.core.models.certlogic.CertLogicData;
import ch.admin.bag.covidcertificate.sdk.core.models.certlogic.CertLogicExternalInfo;
import ch.admin.bag.covidcertificate.sdk.core.models.certlogic.CertLogicHeaders;
import ch.admin.bag.covidcertificate.sdk.core.models.certlogic.CertLogicPayload;
import ch.admin.bag.covidcertificate.sdk.core.models.healthcert.CertType;
import ch.admin.bag.covidcertificate.sdk.core.models.healthcert.eu.DccCert;
import ch.admin.bag.covidcertificate.sdk.core.models.healthcert.eu.TestEntry;
import ch.admin.bag.covidcertificate.sdk.core.models.state.CheckNationalRulesState;
import ch.admin.bag.covidcertificate.sdk.core.models.trustlist.DisplayRule;
import ch.admin.bag.covidcertificate.sdk.core.models.trustlist.Rule;
import ch.admin.bag.covidcertificate.sdk.core.models.trustlist.RuleSet;
import ch.admin.bag.covidcertificate.sdk.core.utils.DateUtil;
import ch.admin.bag.covidcertificate.sdk.core.verifier.nationalrules.DisplayValidityCalculator;
import ch.admin.bag.covidcertificate.sdk.core.verifier.nationalrules.NationalRulesError;
import ch.admin.bag.covidcertificate.sdk.core.verifier.nationalrules.ValidityRange;
import ch.admin.bag.covidcertificate.sdk.core.verifier.nationalrules.certlogic.CertlogicKt;
import ch.admin.bag.covidcertificate.sdk.core.verifier.nationalrules.certlogic.InternalsKt;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Clock;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\f0\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010J^\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00162\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\f0\n2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00140\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J*\u0010\u001f\u001a\u0004\u0018\u00010 2\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00162\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002JH\u0010#\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\u001e2\b\b\u0002\u0010%\u001a\u00020&2\b\b\u0002\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lch/admin/bag/covidcertificate/sdk/core/verifier/nationalrules/NationalRulesVerifier;", "", "()V", "displayValidityCalculator", "Lch/admin/bag/covidcertificate/sdk/core/verifier/nationalrules/DisplayValidityCalculator;", "getCertlogicData", "Lch/admin/bag/covidcertificate/sdk/core/models/certlogic/CertLogicData;", "dccCert", "Lch/admin/bag/covidcertificate/sdk/core/models/healthcert/eu/DccCert;", "valueSets", "", "", "", "headers", "Lch/admin/bag/covidcertificate/sdk/core/models/certlogic/CertLogicHeaders;", "clock", "Ljava/time/Clock;", "getErrorStateForRule", "Lch/admin/bag/covidcertificate/sdk/core/models/state/CheckNationalRulesState;", "rule", "Lch/admin/bag/covidcertificate/sdk/core/models/trustlist/Rule;", "displayRules", "", "Lch/admin/bag/covidcertificate/sdk/core/models/trustlist/DisplayRule;", "certType", "Lch/admin/bag/covidcertificate/sdk/core/models/healthcert/CertType;", "getValidRulesForDate", "ruleSet", "Lch/admin/bag/covidcertificate/sdk/core/models/trustlist/RuleSet;", "checkDate", "Ljava/time/LocalDateTime;", "getValidityRange", "Lch/admin/bag/covidcertificate/sdk/core/verifier/nationalrules/ValidityRange;", "data", "Lcom/fasterxml/jackson/databind/JsonNode;", "verify", "nationalRulesCheckDate", "isForeignRulesCheck", "", "CovidCertificate-SDK-Kotlin"})
public final class NationalRulesVerifier {
    @NotNull
    private final DisplayValidityCalculator displayValidityCalculator = new DisplayValidityCalculator();

    @NotNull
    public final CheckNationalRulesState verify(@NotNull DccCert dccCert, @NotNull RuleSet ruleSet, @NotNull CertType certType, @Nullable CertLogicHeaders headers, @Nullable LocalDateTime nationalRulesCheckDate, boolean isForeignRulesCheck, @NotNull Clock clock) {
        CheckNationalRulesState checkNationalRulesState;
        Intrinsics.checkNotNullParameter((Object)dccCert, (String)"dccCert");
        Intrinsics.checkNotNullParameter((Object)ruleSet, (String)"ruleSet");
        Intrinsics.checkNotNullParameter((Object)((Object)certType), (String)"certType");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        List<Rule> rules = this.getValidRulesForDate(ruleSet, nationalRulesCheckDate);
        if (rules.isEmpty()) {
            return new CheckNationalRulesState.INVALID(NationalRulesError.NO_VALID_RULES_FOR_SPECIFIC_DATE, null, 2, null);
        }
        CertLogicData ruleSetData = this.getCertlogicData(dccCert, ruleSet.getValueSets(), headers, clock);
        ObjectMapper jacksonMapper = new ObjectMapper();
        jacksonMapper.setTimeZone(TimeZone.getTimeZone(ZoneOffset.UTC));
        JsonNode data = jacksonMapper.valueToTree((Object)ruleSetData);
        Iterable $this$forEach$iv = rules;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Rule rule = (Rule)element$iv;
            boolean bl = false;
            JsonNode ruleLogic = jacksonMapper.readTree(rule.getLogic());
            Intrinsics.checkNotNullExpressionValue((Object)ruleLogic, (String)"ruleLogic");
            Intrinsics.checkNotNullExpressionValue((Object)data, (String)"data");
            boolean isSuccessful = InternalsKt.isTruthy(CertlogicKt.evaluate(ruleLogic, data));
            if (isSuccessful) continue;
            return NationalRulesVerifier.getErrorStateForRule$default(this, rule, dccCert, ruleSet.getDisplayRules(), ruleSetData.getExternal().getValueSets(), certType, headers, null, 64, null);
        }
        if (ruleSet.getDisplayRules() != null) {
            List<DisplayRule> list = ruleSet.getDisplayRules();
            Intrinsics.checkNotNullExpressionValue((Object)data, (String)"data");
            ValidityRange validityRange = this.getValidityRange(list, data, certType);
            boolean isOnlyValidInSwitzerland = this.displayValidityCalculator.isOnlyValidInSwitzerland(ruleSet.getDisplayRules(), data);
            String eolBannerIdentifier = this.displayValidityCalculator.getEolBannerIdentifier(ruleSet.getDisplayRules(), data);
            checkNationalRulesState = new CheckNationalRulesState.SUCCESS(validityRange, isOnlyValidInSwitzerland, eolBannerIdentifier);
        } else {
            checkNationalRulesState = isForeignRulesCheck ? (CheckNationalRulesState)new CheckNationalRulesState.SUCCESS(null, false, null, 4, null) : (CheckNationalRulesState)new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, null, 2, null);
        }
        return checkNationalRulesState;
    }

    public static /* synthetic */ CheckNationalRulesState verify$default(NationalRulesVerifier nationalRulesVerifier, DccCert dccCert, RuleSet ruleSet, CertType certType, CertLogicHeaders certLogicHeaders, LocalDateTime localDateTime, boolean bl, Clock clock, int n, Object object) {
        if ((n & 0x10) != 0) {
            localDateTime = null;
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        if ((n & 0x40) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemUTC()");
            clock = clock2;
        }
        return nationalRulesVerifier.verify(dccCert, ruleSet, certType, certLogicHeaders, localDateTime, bl, clock);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CertLogicData getCertlogicData(@NotNull DccCert dccCert, @NotNull Map<String, String[]> valueSets, @Nullable CertLogicHeaders headers, @NotNull Clock clock) {
        List list;
        Intrinsics.checkNotNullParameter((Object)dccCert, (String)"dccCert");
        Intrinsics.checkNotNullParameter(valueSets, (String)"valueSets");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        List<TestEntry> list2 = dccCert.getTests();
        if (list2 == null) {
            list = null;
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                TestEntry testEntry;
                void it;
                TestEntry testEntry2 = (TestEntry)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                if (TestEntryExtensionsKt.isPositiveRatTest((TestEntry)it)) {
                    ZonedDateTime zonedDateTime;
                    LocalDateTime localDateTime;
                    LocalDateTime localDateTime2;
                    OffsetTime offsetTime = OffsetDateTime.parse(it.getTimestampSample()).toOffsetTime();
                    String string = it.getTimestampSample();
                    TemporalAccessor temporalAccessor = offsetTime.getOffset();
                    Intrinsics.checkNotNullExpressionValue((Object)temporalAccessor, (String)"offsetTime.offset");
                    LocalDateTime localDateTime3 = DateUtil.INSTANCE.parseDateTime(string, (ZoneId)((Object)temporalAccessor));
                    String string2 = localDateTime3 == null ? null : ((temporalAccessor = localDateTime3.withHour(0)) == null ? null : ((localDateTime2 = ((LocalDateTime)temporalAccessor).withMinute(0)) == null ? null : ((localDateTime = localDateTime2.withSecond(0)) == null ? null : ((zonedDateTime = localDateTime.atZone(ZoneId.systemDefault())) == null ? null : zonedDateTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME)))));
                    String timestampSample = string2 == null ? it.getTimestampSample() : string2;
                    testEntry = TestEntry.copy$default((TestEntry)it, null, null, null, null, timestampSample, null, null, null, null, null, null, 2031, null);
                } else {
                    testEntry = it;
                }
                collection.add(testEntry);
            }
            list = (List)destination$iv$iv;
        }
        List tests = list;
        CertLogicPayload payload = new CertLogicPayload(dccCert.getPerson(), dccCert.getDateOfBirth(), dccCert.getVersion(), dccCert.getPastInfections(), tests, dccCert.getVaccinations(), headers);
        String validationClock = ZonedDateTime.now(clock).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        String validationClockAtStartOfDay = LocalDate.now(clock).atStartOfDay(ZoneOffset.UTC).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        Intrinsics.checkNotNullExpressionValue((Object)validationClock, (String)"validationClock");
        Intrinsics.checkNotNullExpressionValue((Object)validationClockAtStartOfDay, (String)"validationClockAtStartOfDay");
        CertLogicExternalInfo externalInfo = new CertLogicExternalInfo(valueSets, validationClock, validationClockAtStartOfDay);
        return new CertLogicData(payload, externalInfo);
    }

    public static /* synthetic */ CertLogicData getCertlogicData$default(NationalRulesVerifier nationalRulesVerifier, DccCert dccCert, Map map, CertLogicHeaders certLogicHeaders, Clock clock, int n, Object object) {
        if ((n & 8) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemUTC()");
            clock = clock2;
        }
        return nationalRulesVerifier.getCertlogicData(dccCert, map, certLogicHeaders, clock);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Rule> getValidRulesForDate(RuleSet ruleSet, LocalDateTime checkDate) {
        void $this$mapNotNullTo$iv$iv;
        Map $this$groupByTo$iv$iv;
        if (checkDate == null) {
            return ruleSet.getRules();
        }
        Iterable $this$groupBy$iv = ruleSet.getRules();
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object element$iv$iv = iterator.next();
            Rule it = (Rule)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getIdentifier();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$mapNotNull$iv = destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$groupByTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Rule it$iv$iv;
            Object v2;
            void $this$maxByOrNull$iv;
            void $this$filterTo$iv$iv;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Map.Entry $dstr$_u24__u24$rules = element$iv$iv;
            boolean bl3 = false;
            List rules = (List)$dstr$_u24__u24$rules.getValue();
            Iterable $this$filter$iv = rules;
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                Rule it = (Rule)element$iv$iv2;
                boolean bl4 = false;
                LocalDateTime validFromDate = DateUtil.parseDateTime$default(DateUtil.INSTANCE, it.getValidFrom(), null, 2, null);
                LocalDateTime validToDate = DateUtil.parseDateTime$default(DateUtil.INSTANCE, it.getValidTo(), null, 2, null);
                boolean bl5 = validFromDate != null && validToDate != null ? RangesKt.rangeTo((Comparable)validFromDate, (Comparable)validToDate).contains((Comparable)checkDate) : false;
                if (!bl5) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v2 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v2 = maxElem$iv;
                } else {
                    Rule it = (Rule)maxElem$iv;
                    boolean bl6 = false;
                    Comparable maxValue$iv = (Comparable)((Object)it.getValidFrom());
                    do {
                        Object e$iv = iterator$iv.next();
                        Rule it2 = (Rule)e$iv;
                        $i$a$-maxByOrNull-NationalRulesVerifier$getValidRulesForDate$2$2 = false;
                        Comparable v$iv = (Comparable)((Object)it2.getValidFrom());
                        if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v2 = maxElem$iv;
                }
            }
            if ((Rule)v2 == null) continue;
            boolean bl7 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final CheckNationalRulesState getErrorStateForRule(Rule rule, DccCert dccCert, List<DisplayRule> displayRules, Map<String, String[]> valueSets, CertType certType, CertLogicHeaders headers, Clock clock) {
        CheckNationalRulesState checkNationalRulesState;
        CertLogicData ruleSetData = this.getCertlogicData(dccCert, valueSets, headers, clock);
        ObjectMapper jacksonMapper = new ObjectMapper();
        jacksonMapper.setTimeZone(TimeZone.getTimeZone(ZoneOffset.UTC));
        JsonNode data = jacksonMapper.valueToTree((Object)ruleSetData);
        switch (rule.getIdentifier()) {
            case "GR-CH-0001": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.WRONG_DISEASE_TARGET, rule.getIdentifier());
                break;
            }
            case "VR-CH-0000": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.TOO_MANY_VACCINE_ENTRIES, rule.getIdentifier());
                break;
            }
            case "VR-CH-0001": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.NOT_FULLY_PROTECTED, rule.getIdentifier());
                break;
            }
            case "VR-CH-0002": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.NO_VALID_PRODUCT, rule.getIdentifier());
                break;
            }
            case "VR-CH-0003": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.NO_VALID_DATE, rule.getIdentifier());
                break;
            }
            case "VR-CH-0004": {
                CheckNationalRulesState.NOT_YET_VALID nOT_YET_VALID;
                Intrinsics.checkNotNullExpressionValue((Object)data, (String)"data");
                ValidityRange validityRange = this.getValidityRange(displayRules, data, certType);
                if (validityRange == null) {
                    nOT_YET_VALID = null;
                } else {
                    ValidityRange it = validityRange;
                    boolean bl = false;
                    nOT_YET_VALID = new CheckNationalRulesState.NOT_YET_VALID(it, rule.getIdentifier());
                }
                CheckNationalRulesState.NOT_YET_VALID nOT_YET_VALID2 = nOT_YET_VALID;
                if (nOT_YET_VALID2 == null) {
                    checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, rule.getIdentifier());
                    break;
                }
                checkNationalRulesState = nOT_YET_VALID2;
                break;
            }
            case "VR-CH-0005": {
                CheckNationalRulesState.NOT_YET_VALID nOT_YET_VALID;
                Intrinsics.checkNotNullExpressionValue((Object)data, (String)"data");
                ValidityRange validityRange = this.getValidityRange(displayRules, data, certType);
                if (validityRange == null) {
                    nOT_YET_VALID = null;
                } else {
                    ValidityRange it = validityRange;
                    boolean bl = false;
                    nOT_YET_VALID = new CheckNationalRulesState.NOT_YET_VALID(it, rule.getIdentifier());
                }
                CheckNationalRulesState.NOT_YET_VALID nOT_YET_VALID3 = nOT_YET_VALID;
                if (nOT_YET_VALID3 == null) {
                    checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, rule.getIdentifier());
                    break;
                }
                checkNationalRulesState = nOT_YET_VALID3;
                break;
            }
            case "VR-CH-0006": {
                CheckNationalRulesState.NOT_VALID_ANYMORE nOT_VALID_ANYMORE;
                Intrinsics.checkNotNullExpressionValue((Object)data, (String)"data");
                ValidityRange validityRange = this.getValidityRange(displayRules, data, certType);
                if (validityRange == null) {
                    nOT_VALID_ANYMORE = null;
                } else {
                    ValidityRange it = validityRange;
                    boolean bl = false;
                    nOT_VALID_ANYMORE = new CheckNationalRulesState.NOT_VALID_ANYMORE(it, rule.getIdentifier());
                }
                CheckNationalRulesState.NOT_VALID_ANYMORE nOT_VALID_ANYMORE2 = nOT_VALID_ANYMORE;
                if (nOT_VALID_ANYMORE2 == null) {
                    checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, rule.getIdentifier());
                    break;
                }
                checkNationalRulesState = nOT_VALID_ANYMORE2;
                break;
            }
            case "VR-CH-0007": {
                CheckNationalRulesState.NOT_VALID_ANYMORE nOT_VALID_ANYMORE;
                Intrinsics.checkNotNullExpressionValue((Object)data, (String)"data");
                ValidityRange validityRange = this.getValidityRange(displayRules, data, certType);
                if (validityRange == null) {
                    nOT_VALID_ANYMORE = null;
                } else {
                    ValidityRange it = validityRange;
                    boolean bl = false;
                    nOT_VALID_ANYMORE = new CheckNationalRulesState.NOT_VALID_ANYMORE(it, rule.getIdentifier());
                }
                CheckNationalRulesState.NOT_VALID_ANYMORE nOT_VALID_ANYMORE3 = nOT_VALID_ANYMORE;
                if (nOT_VALID_ANYMORE3 == null) {
                    checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, rule.getIdentifier());
                    break;
                }
                checkNationalRulesState = nOT_VALID_ANYMORE3;
                break;
            }
            case "VR-CH-0008": {
                CheckNationalRulesState.NOT_VALID_ANYMORE nOT_VALID_ANYMORE;
                Intrinsics.checkNotNullExpressionValue((Object)data, (String)"data");
                ValidityRange validityRange = this.getValidityRange(displayRules, data, certType);
                if (validityRange == null) {
                    nOT_VALID_ANYMORE = null;
                } else {
                    ValidityRange it = validityRange;
                    boolean bl = false;
                    nOT_VALID_ANYMORE = new CheckNationalRulesState.NOT_VALID_ANYMORE(it, rule.getIdentifier());
                }
                CheckNationalRulesState.NOT_VALID_ANYMORE nOT_VALID_ANYMORE4 = nOT_VALID_ANYMORE;
                if (nOT_VALID_ANYMORE4 == null) {
                    checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, rule.getIdentifier());
                    break;
                }
                checkNationalRulesState = nOT_VALID_ANYMORE4;
                break;
            }
            case "TR-CH-0000": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.TOO_MANY_TEST_ENTRIES, rule.getIdentifier());
                break;
            }
            case "TR-CH-0001": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.POSITIVE_RESULT, rule.getIdentifier());
                break;
            }
            case "TR-CH-0002": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.WRONG_TEST_TYPE, rule.getIdentifier());
                break;
            }
            case "TR-CH-0003": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.NO_VALID_PRODUCT, rule.getIdentifier());
                break;
            }
            case "TR-CH-0004": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.NO_VALID_DATE, rule.getIdentifier());
                break;
            }
            case "TR-CH-0005": {
                CheckNationalRulesState.NOT_YET_VALID nOT_YET_VALID;
                Intrinsics.checkNotNullExpressionValue((Object)data, (String)"data");
                ValidityRange validityRange = this.getValidityRange(displayRules, data, certType);
                if (validityRange == null) {
                    nOT_YET_VALID = null;
                } else {
                    ValidityRange it = validityRange;
                    boolean bl = false;
                    nOT_YET_VALID = new CheckNationalRulesState.NOT_YET_VALID(it, rule.getIdentifier());
                }
                CheckNationalRulesState.NOT_YET_VALID nOT_YET_VALID4 = nOT_YET_VALID;
                if (nOT_YET_VALID4 == null) {
                    checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, rule.getIdentifier());
                    break;
                }
                checkNationalRulesState = nOT_YET_VALID4;
                break;
            }
            case "TR-CH-0006": {
                CheckNationalRulesState.NOT_VALID_ANYMORE nOT_VALID_ANYMORE;
                Intrinsics.checkNotNullExpressionValue((Object)data, (String)"data");
                ValidityRange validityRange = this.getValidityRange(displayRules, data, certType);
                if (validityRange == null) {
                    nOT_VALID_ANYMORE = null;
                } else {
                    ValidityRange it = validityRange;
                    boolean bl = false;
                    nOT_VALID_ANYMORE = new CheckNationalRulesState.NOT_VALID_ANYMORE(it, rule.getIdentifier());
                }
                CheckNationalRulesState.NOT_VALID_ANYMORE nOT_VALID_ANYMORE5 = nOT_VALID_ANYMORE;
                if (nOT_VALID_ANYMORE5 == null) {
                    checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, rule.getIdentifier());
                    break;
                }
                checkNationalRulesState = nOT_VALID_ANYMORE5;
                break;
            }
            case "TR-CH-0007": {
                CheckNationalRulesState.NOT_VALID_ANYMORE nOT_VALID_ANYMORE;
                Intrinsics.checkNotNullExpressionValue((Object)data, (String)"data");
                ValidityRange validityRange = this.getValidityRange(displayRules, data, certType);
                if (validityRange == null) {
                    nOT_VALID_ANYMORE = null;
                } else {
                    ValidityRange it = validityRange;
                    boolean bl = false;
                    nOT_VALID_ANYMORE = new CheckNationalRulesState.NOT_VALID_ANYMORE(it, rule.getIdentifier());
                }
                CheckNationalRulesState.NOT_VALID_ANYMORE nOT_VALID_ANYMORE6 = nOT_VALID_ANYMORE;
                if (nOT_VALID_ANYMORE6 == null) {
                    checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, rule.getIdentifier());
                    break;
                }
                checkNationalRulesState = nOT_VALID_ANYMORE6;
                break;
            }
            case "TR-CH-0008": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.NEGATIVE_RESULT, rule.getIdentifier());
                break;
            }
            case "TR-CH-0009": {
                CheckNationalRulesState.NOT_VALID_ANYMORE nOT_VALID_ANYMORE;
                Intrinsics.checkNotNullExpressionValue((Object)data, (String)"data");
                ValidityRange validityRange = this.getValidityRange(displayRules, data, certType);
                if (validityRange == null) {
                    nOT_VALID_ANYMORE = null;
                } else {
                    ValidityRange it = validityRange;
                    boolean bl = false;
                    nOT_VALID_ANYMORE = new CheckNationalRulesState.NOT_VALID_ANYMORE(it, rule.getIdentifier());
                }
                CheckNationalRulesState.NOT_VALID_ANYMORE nOT_VALID_ANYMORE7 = nOT_VALID_ANYMORE;
                if (nOT_VALID_ANYMORE7 == null) {
                    checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, rule.getIdentifier());
                    break;
                }
                checkNationalRulesState = nOT_VALID_ANYMORE7;
                break;
            }
            case "TR-CH-0010": {
                CheckNationalRulesState.NOT_VALID_ANYMORE nOT_VALID_ANYMORE;
                Intrinsics.checkNotNullExpressionValue((Object)data, (String)"data");
                ValidityRange validityRange = this.getValidityRange(displayRules, data, certType);
                if (validityRange == null) {
                    nOT_VALID_ANYMORE = null;
                } else {
                    ValidityRange it = validityRange;
                    boolean bl = false;
                    nOT_VALID_ANYMORE = new CheckNationalRulesState.NOT_VALID_ANYMORE(it, rule.getIdentifier());
                }
                CheckNationalRulesState.NOT_VALID_ANYMORE nOT_VALID_ANYMORE8 = nOT_VALID_ANYMORE;
                if (nOT_VALID_ANYMORE8 == null) {
                    checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, rule.getIdentifier());
                    break;
                }
                checkNationalRulesState = nOT_VALID_ANYMORE8;
                break;
            }
            case "TR-CH-0011": {
                CheckNationalRulesState.NOT_YET_VALID nOT_YET_VALID;
                Intrinsics.checkNotNullExpressionValue((Object)data, (String)"data");
                ValidityRange validityRange = this.getValidityRange(displayRules, data, certType);
                if (validityRange == null) {
                    nOT_YET_VALID = null;
                } else {
                    ValidityRange it = validityRange;
                    boolean bl = false;
                    nOT_YET_VALID = new CheckNationalRulesState.NOT_YET_VALID(it, rule.getIdentifier());
                }
                CheckNationalRulesState.NOT_YET_VALID nOT_YET_VALID5 = nOT_YET_VALID;
                if (nOT_YET_VALID5 == null) {
                    checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, rule.getIdentifier());
                    break;
                }
                checkNationalRulesState = nOT_YET_VALID5;
                break;
            }
            case "TR-CH-0012": {
                CheckNationalRulesState.NOT_VALID_ANYMORE nOT_VALID_ANYMORE;
                Intrinsics.checkNotNullExpressionValue((Object)data, (String)"data");
                ValidityRange validityRange = this.getValidityRange(displayRules, data, certType);
                if (validityRange == null) {
                    nOT_VALID_ANYMORE = null;
                } else {
                    ValidityRange it = validityRange;
                    boolean bl = false;
                    nOT_VALID_ANYMORE = new CheckNationalRulesState.NOT_VALID_ANYMORE(it, rule.getIdentifier());
                }
                CheckNationalRulesState.NOT_VALID_ANYMORE nOT_VALID_ANYMORE9 = nOT_VALID_ANYMORE;
                if (nOT_VALID_ANYMORE9 == null) {
                    checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, rule.getIdentifier());
                    break;
                }
                checkNationalRulesState = nOT_VALID_ANYMORE9;
                break;
            }
            case "RR-CH-0000": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.TOO_MANY_RECOVERY_ENTRIES, rule.getIdentifier());
                break;
            }
            case "RR-CH-0001": {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.NO_VALID_DATE, rule.getIdentifier());
                break;
            }
            case "RR-CH-0002": {
                CheckNationalRulesState.NOT_YET_VALID nOT_YET_VALID;
                Intrinsics.checkNotNullExpressionValue((Object)data, (String)"data");
                ValidityRange validityRange = this.getValidityRange(displayRules, data, certType);
                if (validityRange == null) {
                    nOT_YET_VALID = null;
                } else {
                    ValidityRange it = validityRange;
                    boolean bl = false;
                    nOT_YET_VALID = new CheckNationalRulesState.NOT_YET_VALID(it, rule.getIdentifier());
                }
                CheckNationalRulesState.NOT_YET_VALID nOT_YET_VALID6 = nOT_YET_VALID;
                if (nOT_YET_VALID6 == null) {
                    checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, rule.getIdentifier());
                    break;
                }
                checkNationalRulesState = nOT_YET_VALID6;
                break;
            }
            case "RR-CH-0003": {
                CheckNationalRulesState.NOT_VALID_ANYMORE nOT_VALID_ANYMORE;
                Intrinsics.checkNotNullExpressionValue((Object)data, (String)"data");
                ValidityRange validityRange = this.getValidityRange(displayRules, data, certType);
                if (validityRange == null) {
                    nOT_VALID_ANYMORE = null;
                } else {
                    ValidityRange it = validityRange;
                    boolean bl = false;
                    nOT_VALID_ANYMORE = new CheckNationalRulesState.NOT_VALID_ANYMORE(it, rule.getIdentifier());
                }
                CheckNationalRulesState.NOT_VALID_ANYMORE nOT_VALID_ANYMORE10 = nOT_VALID_ANYMORE;
                if (nOT_VALID_ANYMORE10 == null) {
                    checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.VALIDITY_RANGE_NOT_FOUND, rule.getIdentifier());
                    break;
                }
                checkNationalRulesState = nOT_VALID_ANYMORE10;
                break;
            }
            default: {
                checkNationalRulesState = new CheckNationalRulesState.INVALID(NationalRulesError.UNKNOWN_RULE_FAILED, rule.getIdentifier());
            }
        }
        return checkNationalRulesState;
    }

    static /* synthetic */ CheckNationalRulesState getErrorStateForRule$default(NationalRulesVerifier nationalRulesVerifier, Rule rule, DccCert dccCert, List list, Map map, CertType certType, CertLogicHeaders certLogicHeaders, Clock clock, int n, Object object) {
        if ((n & 0x40) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemUTC()");
            clock = clock2;
        }
        return nationalRulesVerifier.getErrorStateForRule(rule, dccCert, list, map, certType, certLogicHeaders, clock);
    }

    private final ValidityRange getValidityRange(List<DisplayRule> displayRules, JsonNode data, CertType certType) {
        ValidityRange validityRange;
        List<DisplayRule> list = displayRules;
        if (list == null) {
            validityRange = null;
        } else {
            List<DisplayRule> it = list;
            boolean bl = false;
            validityRange = this.displayValidityCalculator.getDisplayValidityRangeForSystemTimeZone(it, data, certType);
        }
        return validityRange;
    }
}

