/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bag.covidcertificate.sdk.core.decoder;

import ch.admin.bag.covidcertificate.sdk.core.decoder.chain.Base45Service;
import ch.admin.bag.covidcertificate.sdk.core.decoder.chain.CborService;
import ch.admin.bag.covidcertificate.sdk.core.decoder.chain.CertTypeService;
import ch.admin.bag.covidcertificate.sdk.core.decoder.chain.DecompressionService;
import ch.admin.bag.covidcertificate.sdk.core.decoder.chain.NoopVerificationCoseService;
import ch.admin.bag.covidcertificate.sdk.core.decoder.chain.PrefixIdentifierService;
import ch.admin.bag.covidcertificate.sdk.core.models.healthcert.CertificateHolder;
import ch.admin.bag.covidcertificate.sdk.core.models.state.DecodeState;
import ch.admin.bag.covidcertificate.sdk.core.models.state.StateError;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lch/admin/bag/covidcertificate/sdk/core/decoder/CertificateDecoder;", "", "()V", "decode", "Lch/admin/bag/covidcertificate/sdk/core/models/state/DecodeState;", "qrCodeData", "", "CovidCertificate-SDK-Kotlin"})
public final class CertificateDecoder {
    @NotNull
    public static final CertificateDecoder INSTANCE = new CertificateDecoder();

    private CertificateDecoder() {
    }

    @JvmStatic
    @NotNull
    public static final DecodeState decode(@NotNull String qrCodeData) {
        Intrinsics.checkNotNullParameter((Object)qrCodeData, (String)"qrCodeData");
        String string = PrefixIdentifierService.INSTANCE.decode(qrCodeData);
        if (string == null) {
            return new DecodeState.ERROR(new StateError("D|PRX", null, null, 6, null));
        }
        String encoded = string;
        byte[] byArray = Base45Service.INSTANCE.decode(encoded);
        if (byArray == null) {
            return new DecodeState.ERROR(new StateError("D|B45", null, null, 6, null));
        }
        byte[] compressed = byArray;
        byte[] byArray2 = DecompressionService.INSTANCE.decode(compressed);
        if (byArray2 == null) {
            return new DecodeState.ERROR(new StateError("D|ZLB", null, null, 6, null));
        }
        byte[] cose = byArray2;
        byte[] byArray3 = NoopVerificationCoseService.INSTANCE.decode(cose);
        if (byArray3 == null) {
            return new DecodeState.ERROR(new StateError("D|CSE", null, null, 6, null));
        }
        byte[] cbor = byArray3;
        CertificateHolder certificateHolder = CborService.INSTANCE.decode(cbor, qrCodeData);
        if (certificateHolder == null) {
            return new DecodeState.ERROR(new StateError("D|CBR", null, null, 6, null));
        }
        CertificateHolder certificateHolder2 = certificateHolder;
        certificateHolder2.setCertType$CovidCertificate_SDK_Kotlin(CertTypeService.INSTANCE.decode(certificateHolder2));
        return new DecodeState.SUCCESS(certificateHolder2);
    }
}

