/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bag.covidcertificate.sdk.core.verifier.nationalrules;

import ch.admin.bag.covidcertificate.sdk.core.models.healthcert.CertType;
import ch.admin.bag.covidcertificate.sdk.core.models.trustlist.DisplayRule;
import ch.admin.bag.covidcertificate.sdk.core.verifier.nationalrules.ValidityRange;
import ch.admin.bag.covidcertificate.sdk.core.verifier.nationalrules.certlogic.CertlogicKt;
import ch.admin.bag.covidcertificate.sdk.core.verifier.nationalrules.certlogic.InternalsKt;
import ch.admin.bag.covidcertificate.sdk.core.verifier.nationalrules.certlogic.JsonDateTime;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.List;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0005\u001a\u0004\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0002J\"\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J(\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011J \u0010\u0016\u001a\u0004\u0018\u00010\u000b2\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\u0006J \u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001e\u0010\u0019\u001a\u00020\u00132\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lch/admin/bag/covidcertificate/sdk/core/verifier/nationalrules/DisplayValidityCalculator;", "", "()V", "jacksonMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "evalRule", "Lcom/fasterxml/jackson/databind/JsonNode;", "displayRules", "", "Lch/admin/bag/covidcertificate/sdk/core/models/trustlist/DisplayRule;", "ruleName", "", "data", "getDateTime", "Ljava/time/LocalDateTime;", "resultFromDisplayRule", "certType", "Lch/admin/bag/covidcertificate/sdk/core/models/healthcert/CertType;", "atStartOfDay", "", "getDisplayValidityRangeForSystemTimeZone", "Lch/admin/bag/covidcertificate/sdk/core/verifier/nationalrules/ValidityRange;", "getEolBannerIdentifier", "getLocalDateTime", "Lch/admin/bag/covidcertificate/sdk/core/verifier/nationalrules/certlogic/JsonDateTime;", "isOnlyValidInSwitzerland", "Companion", "CovidCertificate-SDK-Kotlin"})
public final class DisplayValidityCalculator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ObjectMapper jacksonMapper;
    @NotNull
    private static final String RULE_DISPLAY_DATE_FROM = "display-from-date";
    @NotNull
    private static final String RULE_DISPLAY_DATE_UNTIL = "display-until-date";
    @NotNull
    private static final String RULE_CH_ONLY = "is-only-valid-in-ch";
    @NotNull
    private static final String RULE_EOL_BANNER = "eol-banner";

    /*
     * WARNING - void declaration
     */
    public DisplayValidityCalculator() {
        void $this$jacksonMapper_u24lambda_u2d0;
        ObjectMapper objectMapper;
        ObjectMapper objectMapper2 = objectMapper = new ObjectMapper();
        DisplayValidityCalculator displayValidityCalculator = this;
        boolean bl = false;
        $this$jacksonMapper_u24lambda_u2d0.setTimeZone(TimeZone.getTimeZone(ZoneOffset.UTC));
        displayValidityCalculator.jacksonMapper = objectMapper;
    }

    @Nullable
    public final ValidityRange getDisplayValidityRangeForSystemTimeZone(@Nullable List<DisplayRule> displayRules, @NotNull JsonNode data, @NotNull CertType certType) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)((Object)certType), (String)"certType");
        if (displayRules == null) {
            return null;
        }
        JsonNode jsonNode = this.evalRule(displayRules, RULE_DISPLAY_DATE_FROM, data);
        if (jsonNode == null) {
            return null;
        }
        JsonNode resultFromDate = jsonNode;
        JsonNode jsonNode2 = this.evalRule(displayRules, RULE_DISPLAY_DATE_UNTIL, data);
        if (jsonNode2 == null) {
            return null;
        }
        JsonNode resultUntilDate = jsonNode2;
        LocalDateTime dateFromString = this.getDateTime(resultFromDate, certType, true);
        LocalDateTime dateUntilString = this.getDateTime(resultUntilDate, certType, false);
        return new ValidityRange(dateFromString, dateUntilString);
    }

    public final boolean isOnlyValidInSwitzerland(@Nullable List<DisplayRule> displayRules, @NotNull JsonNode data) {
        JsonNode jsonNode;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        List<DisplayRule> list = displayRules;
        if (list == null) {
            jsonNode = null;
        } else {
            List<DisplayRule> it = list;
            boolean bl = false;
            jsonNode = this.evalRule(it, RULE_CH_ONLY, data);
        }
        if (jsonNode == null) {
            return false;
        }
        JsonNode result = jsonNode;
        return InternalsKt.isTruthy(result);
    }

    @Nullable
    public final String getEolBannerIdentifier(@Nullable List<DisplayRule> displayRules, @NotNull JsonNode data) {
        String string;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        List<DisplayRule> list = displayRules;
        if (list == null) {
            string = null;
        } else {
            List<DisplayRule> it = list;
            boolean bl = false;
            JsonNode jsonNode = this.evalRule(it, RULE_EOL_BANNER, data);
            string = jsonNode == null ? null : jsonNode.asText(null);
        }
        return string;
    }

    private final LocalDateTime getDateTime(JsonNode resultFromDisplayRule, CertType certType, boolean atStartOfDay) {
        if (resultFromDisplayRule instanceof JsonDateTime) {
            return this.getLocalDateTime(certType, (JsonDateTime)resultFromDisplayRule, atStartOfDay);
        }
        return null;
    }

    private final LocalDateTime getLocalDateTime(CertType certType, JsonDateTime data, boolean atStartOfDay) {
        if (certType == CertType.TEST) {
            LocalDateTime localDateTime = data.temporalValue().atZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"data.temporalValue().atZ\u2026ault()).toLocalDateTime()");
            return localDateTime;
        }
        if (atStartOfDay) {
            LocalDateTime localDateTime = data.temporalValue().toLocalDate().atStartOfDay();
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"data.temporalValue().toLocalDate().atStartOfDay()");
            return localDateTime;
        }
        LocalDateTime localDateTime = data.temporalValue().toLocalDate().atTime(LocalTime.MAX);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"data.temporalValue().toL\u2026e().atTime(LocalTime.MAX)");
        return localDateTime;
    }

    private final JsonNode evalRule(List<DisplayRule> displayRules, String ruleName, JsonNode data) {
        Object v0;
        block2: {
            for (Object t : (Iterable)displayRules) {
                DisplayRule it = (DisplayRule)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)ruleName)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        DisplayRule displayRule = v0;
        String string = displayRule == null ? null : displayRule.getLogic();
        if (string == null) {
            return null;
        }
        String displayRule2 = string;
        JsonNode displayLogic = this.jacksonMapper.readTree(displayRule2);
        Intrinsics.checkNotNullExpressionValue((Object)displayLogic, (String)"displayLogic");
        return CertlogicKt.evaluate(displayLogic, data);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lch/admin/bag/covidcertificate/sdk/core/verifier/nationalrules/DisplayValidityCalculator$Companion;", "", "()V", "RULE_CH_ONLY", "", "RULE_DISPLAY_DATE_FROM", "RULE_DISPLAY_DATE_UNTIL", "RULE_EOL_BANNER", "CovidCertificate-SDK-Kotlin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

