/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bag.covidcertificate.sdk.core.decoder.chain;

import ch.admin.bag.covidcertificate.sdk.core.models.healthcert.eu.DccCert;
import ch.admin.bag.covidcertificate.sdk.core.models.healthcert.eu.RecoveryEntry;
import ch.admin.bag.covidcertificate.sdk.core.models.healthcert.eu.TestEntry;
import ch.admin.bag.covidcertificate.sdk.core.models.healthcert.eu.VaccinationEntry;
import ch.admin.bag.covidcertificate.sdk.core.models.trustlist.RevokedCertificatesStore;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lch/admin/bag/covidcertificate/sdk/core/decoder/chain/RevokedHealthCertService;", "", "revokedList", "Lch/admin/bag/covidcertificate/sdk/core/models/trustlist/RevokedCertificatesStore;", "(Lch/admin/bag/covidcertificate/sdk/core/models/trustlist/RevokedCertificatesStore;)V", "isRevoked", "", "dccCert", "Lch/admin/bag/covidcertificate/sdk/core/models/healthcert/eu/DccCert;", "CovidCertificate-SDK-Kotlin"})
public final class RevokedHealthCertService {
    @NotNull
    private final RevokedCertificatesStore revokedList;

    public RevokedHealthCertService(@NotNull RevokedCertificatesStore revokedList) {
        Intrinsics.checkNotNullParameter((Object)revokedList, (String)"revokedList");
        this.revokedList = revokedList;
    }

    public final boolean isRevoked(@NotNull DccCert dccCert) {
        Intrinsics.checkNotNullParameter((Object)dccCert, (String)"dccCert");
        Object object = dccCert.getTests();
        if (!(object == null || object.isEmpty()) && (object = dccCert.getTests().iterator()).hasNext()) {
            TestEntry test = (TestEntry)object.next();
            return this.revokedList.containsCertificate(test.getCertificateIdentifier());
        }
        object = dccCert.getVaccinations();
        if (!(object == null || object.isEmpty()) && (object = dccCert.getVaccinations().iterator()).hasNext()) {
            VaccinationEntry vaccination = (VaccinationEntry)object.next();
            return this.revokedList.containsCertificate(vaccination.getCertificateIdentifier());
        }
        object = dccCert.getPastInfections();
        if (!(object == null || object.isEmpty()) && (object = dccCert.getPastInfections().iterator()).hasNext()) {
            RecoveryEntry recovery = object.next();
            return this.revokedList.containsCertificate(recovery.getCertificateIdentifier());
        }
        return false;
    }
}

