/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bag.covidcertificate.sdk.core.decoder.chain;

import ch.admin.bag.covidcertificate.sdk.core.data.moshi.TrimmedStringAdapter;
import ch.admin.bag.covidcertificate.sdk.core.decoder.chain.CwtHeaderKeys;
import ch.admin.bag.covidcertificate.sdk.core.extensions.StringExtensionsKt;
import ch.admin.bag.covidcertificate.sdk.core.models.healthcert.CertificateHolder;
import ch.admin.bag.covidcertificate.sdk.core.models.healthcert.eu.DccCert;
import ch.admin.bag.covidcertificate.sdk.core.models.healthcert.light.ChLightCert;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.adapters.Rfc3339DateJsonAdapter;
import com.upokecenter.cbor.CBORObject;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\nR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lch/admin/bag/covidcertificate/sdk/core/decoder/chain/CborService;", "", "()V", "keyChLightCertV1", "Lcom/upokecenter/cbor/CBORObject;", "kotlin.jvm.PlatformType", "keyDccCertV1", "decode", "Lch/admin/bag/covidcertificate/sdk/core/models/healthcert/CertificateHolder;", "input", "", "qrCodeData", "", "kid", "CovidCertificate-SDK-Kotlin"})
public final class CborService {
    @NotNull
    public static final CborService INSTANCE = new CborService();
    private static final CBORObject keyDccCertV1 = CBORObject.FromObject((int)1);
    private static final CBORObject keyChLightCertV1 = CBORObject.FromObject((int)1);

    private CborService() {
    }

    @Nullable
    public final CertificateHolder decode(@NotNull byte[] input, @NotNull String qrCodeData, @Nullable byte[] kid) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)qrCodeData, (String)"qrCodeData");
        Moshi moshi = new Moshi.Builder().add((Type)((Object)Date.class), (JsonAdapter)new Rfc3339DateJsonAdapter()).add((Type)((Object)String.class), (JsonAdapter)new TrimmedStringAdapter()).build();
        JsonAdapter dccCertAdapter = moshi.adapter(DccCert.class);
        JsonAdapter chLightCertAdapter = moshi.adapter(ChLightCert.class);
        try {
            Instant instant;
            Instant instant2;
            CBORObject map = CBORObject.DecodeFromBytes((byte[])input);
            CBORObject cBORObject = map.get(CwtHeaderKeys.EXPIRATION.INSTANCE.asCBOR());
            if (cBORObject == null) {
                instant2 = null;
            } else {
                CBORObject it = cBORObject;
                boolean bl = false;
                instant2 = Instant.ofEpochSecond(it.AsInt64());
            }
            Instant expirationTime = instant2;
            CBORObject cBORObject2 = map.get(CwtHeaderKeys.ISSUED_AT.INSTANCE.asCBOR());
            if (cBORObject2 == null) {
                instant = null;
            } else {
                CBORObject it = cBORObject2;
                boolean bl = false;
                instant = Instant.ofEpochSecond(it.AsInt64());
            }
            Instant issuedAt = instant;
            CBORObject cBORObject3 = map.get(CwtHeaderKeys.ISSUER.INSTANCE.asCBOR());
            String issuer = cBORObject3 == null ? null : cBORObject3.AsString();
            String kidBase64 = kid == null ? null : StringExtensionsKt.toBase64(kid);
            CBORObject hcert = map.get(CwtHeaderKeys.HCERT.INSTANCE.asCBOR());
            CBORObject light = map.get(CwtHeaderKeys.LIGHT.INSTANCE.asCBOR());
            if (hcert != null) {
                CBORObject cBORObject4 = hcert.get(keyDccCertV1);
                if (cBORObject4 != null) {
                    CBORObject it = cBORObject4;
                    boolean bl = false;
                    DccCert dccCert = (DccCert)dccCertAdapter.fromJson(it.ToJSONString());
                    if (dccCert == null) {
                        return null;
                    }
                    DccCert dccCert2 = dccCert;
                    return new CertificateHolder(dccCert2, qrCodeData, expirationTime, issuedAt, issuer, kidBase64);
                }
                return null;
            }
            if (light != null) {
                CBORObject cBORObject5 = light.get(keyChLightCertV1);
                if (cBORObject5 != null) {
                    CBORObject it = cBORObject5;
                    boolean bl = false;
                    ChLightCert chLightCert = (ChLightCert)chLightCertAdapter.fromJson(it.ToJSONString());
                    if (chLightCert == null) {
                        return null;
                    }
                    ChLightCert chLightCert2 = chLightCert;
                    return new CertificateHolder(chLightCert2, qrCodeData, expirationTime, issuedAt, issuer, kidBase64);
                }
                return null;
            }
            return null;
        }
        catch (Throwable e) {
            return null;
        }
    }
}

