/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.docgen;

import ch.admin.bit.jeap.archrepo.metamodel.Relation;
import ch.admin.bit.jeap.archrepo.metamodel.relation.RelationType;
import ch.admin.bit.jeap.archrepo.metamodel.relation.RestApiRelation;
import java.util.Map;
import lombok.Generated;
import org.springframework.util.StringUtils;

public final class RelationView {
    private final String counterpart;
    private final String label;
    private final RelationType type;
    private final boolean labelLinkable;
    private final Map<String, String> links;

    static RelationView ofConsumedRelation(Relation relation) {
        return RelationView.of(relation, relation.getProviderName());
    }

    static RelationView ofProvidedRelation(Relation relation) {
        return RelationView.of(relation, relation.getConsumerName());
    }

    static RelationView of(Relation relation, String providerName) {
        return RelationView.builder().counterpart(RelationView.emptyStringAsNull(providerName)).label(relation.getLabel()).labelLinkable(relation.isLabelLinkable()).links(RelationView.links(relation)).type(relation.getType()).build();
    }

    private static Map<String, String> links(Relation relation) {
        RestApiRelation restApiRelation;
        if (relation instanceof RestApiRelation && StringUtils.hasText((String)(restApiRelation = (RestApiRelation)relation).getPactUrl())) {
            return Map.of("Pact", restApiRelation.getPactUrl());
        }
        return Map.of();
    }

    private static String emptyStringAsNull(String str) {
        return !StringUtils.hasText((String)str) ? null : str;
    }

    @Generated
    private static Map<String, String> $default$links() {
        return Map.of();
    }

    @Generated
    RelationView(String counterpart, String label, RelationType type, boolean labelLinkable, Map<String, String> links) {
        this.counterpart = counterpart;
        this.label = label;
        this.type = type;
        this.labelLinkable = labelLinkable;
        this.links = links;
    }

    @Generated
    private static RelationViewBuilder builder() {
        return new RelationViewBuilder();
    }

    @Generated
    public String getCounterpart() {
        return this.counterpart;
    }

    @Generated
    public String getLabel() {
        return this.label;
    }

    @Generated
    public RelationType getType() {
        return this.type;
    }

    @Generated
    public boolean isLabelLinkable() {
        return this.labelLinkable;
    }

    @Generated
    public Map<String, String> getLinks() {
        return this.links;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RelationView)) {
            return false;
        }
        RelationView other = (RelationView)o;
        if (this.isLabelLinkable() != other.isLabelLinkable()) {
            return false;
        }
        String this$counterpart = this.getCounterpart();
        String other$counterpart = other.getCounterpart();
        if (this$counterpart == null ? other$counterpart != null : !this$counterpart.equals(other$counterpart)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        RelationType this$type = this.getType();
        RelationType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Map<String, String> this$links = this.getLinks();
        Map<String, String> other$links = other.getLinks();
        return !(this$links == null ? other$links != null : !((Object)this$links).equals(other$links));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isLabelLinkable() ? 79 : 97);
        String $counterpart = this.getCounterpart();
        result = result * 59 + ($counterpart == null ? 43 : $counterpart.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        RelationType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Map<String, String> $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : ((Object)$links).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RelationView(counterpart=" + this.getCounterpart() + ", label=" + this.getLabel() + ", type=" + String.valueOf(this.getType()) + ", labelLinkable=" + this.isLabelLinkable() + ", links=" + String.valueOf(this.getLinks()) + ")";
    }

    @Generated
    private static class RelationViewBuilder {
        @Generated
        private String counterpart;
        @Generated
        private String label;
        @Generated
        private RelationType type;
        @Generated
        private boolean labelLinkable;
        @Generated
        private boolean links$set;
        @Generated
        private Map<String, String> links$value;

        @Generated
        RelationViewBuilder() {
        }

        @Generated
        private RelationViewBuilder counterpart(String counterpart) {
            this.counterpart = counterpart;
            return this;
        }

        @Generated
        private RelationViewBuilder label(String label) {
            this.label = label;
            return this;
        }

        @Generated
        private RelationViewBuilder type(RelationType type) {
            this.type = type;
            return this;
        }

        @Generated
        private RelationViewBuilder labelLinkable(boolean labelLinkable) {
            this.labelLinkable = labelLinkable;
            return this;
        }

        @Generated
        private RelationViewBuilder links(Map<String, String> links) {
            this.links$value = links;
            this.links$set = true;
            return this;
        }

        @Generated
        private RelationView build() {
            Map<String, String> links$value = this.links$value;
            if (!this.links$set) {
                links$value = RelationView.$default$links();
            }
            return new RelationView(this.counterpart, this.label, this.type, this.labelLinkable, links$value);
        }

        @Generated
        public String toString() {
            return "RelationView.RelationViewBuilder(counterpart=" + this.counterpart + ", label=" + this.label + ", type=" + String.valueOf(this.type) + ", labelLinkable=" + this.labelLinkable + ", links$value=" + String.valueOf(this.links$value) + ")";
        }
    }
}

