/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.docgen;

import ch.admin.bit.jeap.archrepo.docgen.ComponentContext;
import ch.admin.bit.jeap.archrepo.docgen.SystemCommand;
import ch.admin.bit.jeap.archrepo.docgen.SystemContext;
import ch.admin.bit.jeap.archrepo.docgen.SystemEvent;
import ch.admin.bit.jeap.archrepo.docgen.plantuml.PlantUmlRenderer;
import ch.admin.bit.jeap.archrepo.metamodel.ArchitectureModel;
import ch.admin.bit.jeap.archrepo.metamodel.System;
import ch.admin.bit.jeap.archrepo.metamodel.message.Command;
import ch.admin.bit.jeap.archrepo.metamodel.message.Event;
import ch.admin.bit.jeap.archrepo.metamodel.relation.AbstractRelation;
import ch.admin.bit.jeap.archrepo.metamodel.relation.CommandRelation;
import ch.admin.bit.jeap.archrepo.metamodel.relation.EventRelation;
import ch.admin.bit.jeap.archrepo.metamodel.system.SystemComponent;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.springframework.stereotype.Component;
import org.thymeleaf.ITemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;

@Component
class TemplateRenderer {
    private final ITemplateEngine templateEngine;
    private final PlantUmlRenderer plantUmlRenderer;

    String renderIndexPage() {
        Context context = new Context(Locale.GERMAN);
        return this.templateEngine.process("index", (IContext)context).trim();
    }

    String renderSystemPage(ArchitectureModel model, System system) {
        List<SystemEvent> systemEvents = system.getEvents().stream().map(e -> this.createSystemEvent(model, (Event)e)).sorted(Comparator.comparing(SystemEvent::getName)).toList();
        List<SystemCommand> systemCommands = system.getCommands().stream().map(e -> this.createSystemCommand(model, (Command)e)).sorted(Comparator.comparing(SystemCommand::getName)).toList();
        SystemContext systemContext = SystemContext.of(model, system);
        system.sortSystemComponents();
        Context context = new Context(Locale.GERMAN);
        context.setVariable("system", (Object)system);
        context.setVariable("systemEvents", systemEvents);
        context.setVariable("systemCommands", systemCommands);
        String plantUmLSource = this.plantUmlRenderer.renderSystemContextView(systemContext);
        context.setVariable("contextViewPlantUml", (Object)plantUmLSource);
        context.setVariable("plantUmlMacroId", (Object)this.stableMacroUuid(system.getName()));
        return this.templateEngine.process("system", (IContext)context).trim();
    }

    private SystemEvent createSystemEvent(ArchitectureModel model, Event e) {
        Set<String> providerNames = this.getRelationsForEvent(model, e).map(AbstractRelation::getProviderName).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> consumerNames = this.getRelationsForEvent(model, e).map(AbstractRelation::getConsumerName).filter(Objects::nonNull).collect(Collectors.toSet());
        return new SystemEvent(e.getMessageTypeName(), providerNames, consumerNames);
    }

    private SystemCommand createSystemCommand(ArchitectureModel model, Command e) {
        Set<String> senderNames = this.getRelationsForCommand(model, e).map(AbstractRelation::getProviderName).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> receiverNames = this.getRelationsForCommand(model, e).map(AbstractRelation::getConsumerName).filter(Objects::nonNull).collect(Collectors.toSet());
        return new SystemCommand(e.getMessageTypeName(), senderNames, receiverNames);
    }

    private Stream<EventRelation> getRelationsForEvent(ArchitectureModel model, Event event) {
        return model.getAllRelationsByType(EventRelation.class).stream().filter(r -> r.getEventName().equals(event.getMessageTypeName()));
    }

    private Stream<CommandRelation> getRelationsForCommand(ArchitectureModel model, Command command) {
        return model.getAllRelationsByType(CommandRelation.class).stream().filter(r -> r.getCommandName().equals(command.getMessageTypeName()));
    }

    String renderComponentPage(ArchitectureModel model, SystemComponent systemComponent) {
        ComponentContext componentContext = ComponentContext.of(model, systemComponent);
        Context context = new Context(Locale.GERMAN);
        context.setVariable("systemComponent", (Object)systemComponent);
        String plantUmLSource = this.plantUmlRenderer.renderComponentContextView(componentContext);
        context.setVariable("contextViewPlantUml", (Object)plantUmLSource);
        context.setVariable("plantUmlMacroId", (Object)this.stableMacroUuid(systemComponent.getName()));
        context.setVariable("consumedRestApiRelations", componentContext.getConsumedRestApiRelations());
        context.setVariable("producedEventRelations", componentContext.getProducedEventsGroupedByEvent());
        context.setVariable("sentCommandRelations", componentContext.getSentCommandsGroupedByCommand());
        context.setVariable("providedRestApiRelations", componentContext.getProvidedRestApiRelationsGroupedByPath());
        context.setVariable("consumedEventRelations", componentContext.getConsumedEventsGroupedByEvent());
        context.setVariable("receivedCommandRelations", componentContext.getReceivedCommandsGroupedByCommand());
        context.setVariable("openApiSpecUrl", (Object)componentContext.getOpenApiSpecUrl());
        context.setVariable("reactions", componentContext.getReactionStatisticsViews());
        return this.templateEngine.process("system-component", (IContext)context).trim();
    }

    private String stableMacroUuid(String plantUmLSource) {
        return UUID.nameUUIDFromBytes(plantUmLSource.getBytes(StandardCharsets.UTF_8)).toString();
    }

    String renderEventPage(Event event) {
        Context context = new Context(Locale.GERMAN);
        context.setVariable("messageType", (Object)event);
        return this.templateEngine.process("event", (IContext)context).trim();
    }

    String renderCommandPage(Command command) {
        Context context = new Context(Locale.GERMAN);
        context.setVariable("messageType", (Object)command);
        return this.templateEngine.process("command", (IContext)context).trim();
    }

    @Generated
    public TemplateRenderer(ITemplateEngine templateEngine, PlantUmlRenderer plantUmlRenderer) {
        this.templateEngine = templateEngine;
        this.plantUmlRenderer = plantUmlRenderer;
    }
}

