/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.docgen.plantuml;

import ch.admin.bit.jeap.archrepo.model.database.DatabaseSchema;
import ch.admin.bit.jeap.archrepo.model.database.Table;
import ch.admin.bit.jeap.archrepo.model.database.TableColumn;
import ch.admin.bit.jeap.archrepo.model.database.TableForeignKey;
import ch.admin.bit.jeap.archrepo.model.database.TablePrimaryKey;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class PlantUmlDbSchemaRenderer {
    private static final Set<String> NON_RENDERED_TABLE_NAMES = Set.of("flyway_schema_history", "shedlock");

    PlantUmlDbSchemaRenderer() {
    }

    public String renderDbSchema(DatabaseSchema dbSchema) {
        StringBuilder plantUml = new StringBuilder();
        plantUml.append("@startuml\n");
        plantUml.append("title ").append(dbSchema.name()).append(" in Komponentenversion ").append(dbSchema.version()).append("\n");
        plantUml.append("!theme mars\n");
        plantUml.append("skinparam linetype curved\n\n");
        this.streamTables(dbSchema).forEach(table -> this.renderTable(plantUml, (Table)table));
        plantUml.append("\n");
        this.streamTables(dbSchema).forEach(table -> this.renderRelationships(plantUml, (Table)table));
        plantUml.append("@enduml\n");
        return plantUml.toString();
    }

    private Stream<Table> streamTables(DatabaseSchema dbSchema) {
        return dbSchema.tables().stream().filter(this::shouldRender);
    }

    private void renderTable(StringBuilder plantUml, Table table) {
        plantUml.append("entity \"").append(table.name()).append("\" {\n");
        List pkColumns = Optional.ofNullable(table.primaryKey()).map(TablePrimaryKey::columnNames).filter(Objects::nonNull).orElse(List.of());
        Set fkColumns = Optional.ofNullable(table.foreignKeys()).orElse(List.of()).stream().map(TableForeignKey::columnNames).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toSet());
        table.columns().stream().filter(column -> pkColumns.contains(column.name())).forEach(column -> this.renderColumn(plantUml, (TableColumn)column, true, fkColumns.contains(column.name())));
        if (!pkColumns.isEmpty() && table.columns().size() != pkColumns.size()) {
            plantUml.append("    --\n");
        }
        table.columns().stream().filter(column -> !pkColumns.contains(column.name())).forEach(column -> this.renderColumn(plantUml, (TableColumn)column, false, fkColumns.contains(column.name())));
        plantUml.append("}\n\n");
    }

    private void renderColumn(StringBuilder plantUml, TableColumn column, boolean isPrimaryKey, boolean isForeignKey) {
        plantUml.append("  ");
        if (!column.nullable()) {
            plantUml.append("* ");
        } else {
            plantUml.append("  ");
        }
        plantUml.append(column.name()).append(" : ").append(column.type());
        if (isPrimaryKey) {
            plantUml.append(" <<PK>>");
        }
        if (isForeignKey) {
            plantUml.append(" <<FK>>");
        }
        plantUml.append("\n");
    }

    private void renderRelationships(StringBuilder plantUml, Table table) {
        if (table.foreignKeys() != null) {
            for (TableForeignKey foreignKey : table.foreignKeys()) {
                plantUml.append("\"").append(table.name()).append("\" }o--|| \"").append(foreignKey.referencedTableName()).append("\" : ").append(String.join((CharSequence)", ", foreignKey.columnNames())).append("\n");
            }
        }
    }

    boolean shouldRender(Table table) {
        return table.name() != null && !NON_RENDERED_TABLE_NAMES.contains(table.name().toLowerCase());
    }
}

