/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.docgen.plantuml;

import java.util.regex.Pattern;
import lombok.Generated;

class PlantUmlComponent {
    private static final Pattern INVALID_NAME_CHARACTER_PATTERN = Pattern.compile("[^A-Za-z0-9]");
    private final String label;
    private final boolean focus;
    private boolean linkable = true;

    public static PlantUmlComponent of(String label) {
        return new PlantUmlComponent(label, false);
    }

    public static PlantUmlComponent focused(String label) {
        return new PlantUmlComponent(label, true);
    }

    String getName() {
        return PlantUmlComponent.componentName(this.label);
    }

    void removeLink() {
        this.linkable = false;
    }

    void render(StringBuilder uml) {
        uml.append("component \"").append(this.label).append("\" as ").append(PlantUmlComponent.componentName(this.label)).append(' ');
        if (this.linkable) {
            uml.append("[[./").append(this.label).append("]] ");
        }
        uml.append(this.focus()).append('\n');
    }

    private String focus() {
        return this.focus ? " #Gold" : "";
    }

    static String componentName(String label) {
        return INVALID_NAME_CHARACTER_PATTERN.matcher(label).replaceAll("_");
    }

    @Generated
    private PlantUmlComponent(String label, boolean focus) {
        this.label = label;
        this.focus = focus;
    }
}

