/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.docgen;

import ch.admin.bit.jeap.archrepo.docgen.ConfluenceAdapter;
import ch.admin.bit.jeap.archrepo.docgen.DocumentationGeneratorConfluenceProperties;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.sahli.asciidoc.confluence.publisher.client.http.ConfluenceAttachment;
import org.sahli.asciidoc.confluence.publisher.client.http.ConfluenceClient;
import org.sahli.asciidoc.confluence.publisher.client.http.ConfluencePage;
import org.sahli.asciidoc.confluence.publisher.client.http.NotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfluenceAdapterImpl
implements ConfluenceAdapter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfluenceAdapterImpl.class);
    static final String CONTENT_HASH_PROPERTY_KEY = "content-hash";
    private static final String VERSION_MESSAGE = "Documentation generated";
    private final ConfluenceClient confluenceClient;
    private final DocumentationGeneratorConfluenceProperties props;

    private static boolean notSameHash(String actualHash, String newHash) {
        return actualHash == null || !actualHash.equals(newHash);
    }

    private static String hash(String content) {
        return DigestUtils.sha256Hex((String)content);
    }

    @Override
    public String getPageByName(String pageName) {
        return this.confluenceClient.getPageByTitle(this.props.getSpaceKey(), pageName);
    }

    @Override
    public void deleteUnusedAttachments(String pageId, List<String> attachmentNamesToKeep) {
        try {
            List attachments = this.confluenceClient.getAttachments(pageId);
            HashSet<String> toBeKept = new HashSet<String>(attachmentNamesToKeep);
            List<ConfluenceAttachment> toBeDeleted = attachments.stream().filter(att -> !toBeKept.contains(att.getTitle())).toList();
            for (ConfluenceAttachment confluenceAttachment : toBeDeleted) {
                this.confluenceClient.deleteAttachment(confluenceAttachment.getId());
                log.info("Attachment '{}' deleted.", (Object)confluenceAttachment.getTitle());
            }
        }
        catch (Exception e) {
            log.error("Error while deleting unused attachments: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException("Deletion of unused attachments failed.", e);
        }
    }

    @Override
    public void addOrUpdateAttachment(String pageId, String attachmentFileName, InputStream contentStream) {
        try {
            List attachments = this.confluenceClient.getAttachments(pageId);
            Optional<ConfluenceAttachment> match = attachments.stream().filter(att -> att.getTitle().equals(attachmentFileName)).findFirst();
            if (match.isPresent()) {
                String attachmentId = match.get().getId();
                this.confluenceClient.updateAttachmentContent(pageId, attachmentId, contentStream);
                log.debug("Attachment '{}' updated.", (Object)attachmentFileName);
            } else {
                this.confluenceClient.addAttachment(pageId, attachmentFileName, contentStream);
                log.debug("Attachment '{}' added.", (Object)attachmentFileName);
            }
        }
        catch (Exception e) {
            log.error("Error while adding or updating the attachment '{}': {}", new Object[]{attachmentFileName, e.getMessage(), e});
            throw new RuntimeException("Upload of attachment failed.", e);
        }
    }

    @Override
    public String addOrUpdatePageUnderAncestor(String ancestorId, String pageName, String content) {
        String contentId;
        try {
            contentId = this.confluenceClient.getPageByTitle(this.props.getSpaceKey(), pageName);
            this.updatePage(contentId, ancestorId, pageName, content);
        }
        catch (NotFoundException e) {
            log.info("Creating page {}", (Object)pageName);
            contentId = this.confluenceClient.addPageUnderAncestor(this.props.getSpaceKey(), ancestorId, pageName, content, VERSION_MESSAGE);
            this.confluenceClient.setPropertyByKey(contentId, CONTENT_HASH_PROPERTY_KEY, ConfluenceAdapterImpl.hash(content));
        }
        return contentId;
    }

    private void updatePage(String contentId, String ancestorId, String pageName, String content) {
        String newContentHash;
        ConfluencePage existingPage = this.confluenceClient.getPageWithContentAndVersionById(contentId);
        String existingContentHash = this.confluenceClient.getPropertyByKey(contentId, CONTENT_HASH_PROPERTY_KEY);
        if (ConfluenceAdapterImpl.notSameHash(existingContentHash, newContentHash = ConfluenceAdapterImpl.hash(content)) || !existingPage.getTitle().equals(pageName)) {
            log.info("Updating page {}", (Object)pageName);
            this.confluenceClient.deletePropertyByKey(contentId, CONTENT_HASH_PROPERTY_KEY);
            int newPageVersion = existingPage.getVersion() + 1;
            this.confluenceClient.updatePage(contentId, ancestorId, pageName, content, newPageVersion, VERSION_MESSAGE);
            this.confluenceClient.setPropertyByKey(contentId, CONTENT_HASH_PROPERTY_KEY, newContentHash);
        } else {
            log.info("Page {} is up-to-date", (Object)pageName);
        }
    }

    @Override
    public int deleteOrphanPages(String rootPageId, Set<String> generatedPageIds) {
        List<ConfluencePage> allChildPages = this.getAllChildPages(rootPageId);
        List<ConfluencePage> orphans = allChildPages.stream().filter(page -> !generatedPageIds.contains(page.getContentId())).toList();
        log.info("Deleting orphan pages: {}", (Object)ConfluenceAdapterImpl.orphanListAsString(orphans));
        orphans.forEach(page -> this.confluenceClient.deletePage(page.getContentId()));
        return orphans.size();
    }

    private List<ConfluencePage> getAllChildPages(String pageId) {
        ArrayList<ConfluencePage> childPages = new ArrayList<ConfluencePage>(this.confluenceClient.getChildPages(pageId));
        childPages.addAll(childPages.stream().flatMap(page -> this.getAllChildPages(page.getContentId()).stream()).collect(Collectors.toSet()));
        return childPages;
    }

    private static String orphanListAsString(List<ConfluencePage> orphans) {
        return orphans.stream().map(page -> page.getTitle() + " (" + page.getContentId() + ")").collect(Collectors.joining(", "));
    }

    @Generated
    public ConfluenceAdapterImpl(ConfluenceClient confluenceClient, DocumentationGeneratorConfluenceProperties props) {
        this.confluenceClient = confluenceClient;
        this.props = props;
    }
}

