/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.docgen;

import ch.admin.bit.jeap.archrepo.docgen.ConfluenceAdapter;
import ch.admin.bit.jeap.archrepo.docgen.DocumentationGeneratorConfluenceProperties;
import ch.admin.bit.jeap.archrepo.docgen.GeneratorContext;
import ch.admin.bit.jeap.archrepo.docgen.TemplateRenderer;
import ch.admin.bit.jeap.archrepo.docgen.graph.MessageGraphAttachmentService;
import ch.admin.bit.jeap.archrepo.metamodel.ArchitectureModel;
import ch.admin.bit.jeap.archrepo.metamodel.System;
import ch.admin.bit.jeap.archrepo.metamodel.message.Command;
import ch.admin.bit.jeap.archrepo.metamodel.message.Event;
import ch.admin.bit.jeap.archrepo.metamodel.message.MessageType;
import ch.admin.bit.jeap.archrepo.metamodel.system.SystemComponent;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DocumentationGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DocumentationGenerator.class);
    private static final String SYSTEM_PAGE_NAME_POSTFIX = " (System)";
    private final ConfluenceAdapter confluenceAdapter;
    private final TemplateRenderer templateRenderer;
    private final DocumentationGeneratorConfluenceProperties props;
    private final MessageGraphAttachmentService messageGraphAttachmentService;

    public void generate(ArchitectureModel model) {
        String rootPageId = this.confluenceAdapter.getPageByName(this.props.getRootPageName());
        GeneratorContext context = new GeneratorContext(model, rootPageId);
        model.getSystems().forEach(system -> this.generateSystem(context, rootPageId, (System)system));
        log.info("Documentation generated, containing {} pages", (Object)context.getGeneratedPageIds().size());
        int deletedPageCount = this.confluenceAdapter.deleteOrphanPages(context.getRootPageId(), context.getGeneratedPageIds());
        log.info("Orphan cleanup done, deleted {} pages", (Object)deletedPageCount);
    }

    private void generateSystem(GeneratorContext context, String rootPageId, System system) {
        String content = this.templateRenderer.renderSystemPage(context.getModel(), system);
        String systemPageName = system.getName() + SYSTEM_PAGE_NAME_POSTFIX;
        String systemPageId = this.confluenceAdapter.addOrUpdatePageUnderAncestor(rootPageId, systemPageName, content);
        String indexPageContent = this.templateRenderer.renderIndexPage();
        String componentsPageId = this.confluenceAdapter.addOrUpdatePageUnderAncestor(systemPageId, "Komponenten (" + system.getName() + ")", indexPageContent);
        system.getSystemComponents().forEach(systemComponent -> this.generateSystemComponent(context, componentsPageId, (SystemComponent)systemComponent));
        String eventsPageId = this.confluenceAdapter.addOrUpdatePageUnderAncestor(systemPageId, "Events (" + system.getName() + ")", indexPageContent);
        String commandsPageId = this.confluenceAdapter.addOrUpdatePageUnderAncestor(systemPageId, "Commands (" + system.getName() + ")", indexPageContent);
        system.getEvents().forEach(event -> this.generateEvent(context, eventsPageId, (Event)event));
        system.getCommands().forEach(command -> this.generateCommand(context, commandsPageId, (Command)command));
        context.addGeneratedPageIds(systemPageId, componentsPageId, eventsPageId, commandsPageId);
    }

    private void generateSystemComponent(GeneratorContext context, String ancestorId, SystemComponent systemComponent) {
        String content = this.templateRenderer.renderComponentPage(context.getModel(), systemComponent);
        String pageId = this.confluenceAdapter.addOrUpdatePageUnderAncestor(ancestorId, systemComponent.getName(), content);
        context.addGeneratedPageIds(pageId);
    }

    private void generateEvent(GeneratorContext context, String ancestorId, Event event) {
        List<String> graphAttachmentNames = this.messageGraphAttachmentService.getAttachmentNames((MessageType)event);
        String content = this.templateRenderer.renderEventPage(event, graphAttachmentNames);
        String pageId = this.confluenceAdapter.addOrUpdatePageUnderAncestor(ancestorId, event.getMessageTypeName(), content);
        this.messageGraphAttachmentService.generateAttachments((MessageType)event, pageId);
        context.addGeneratedPageIds(pageId);
    }

    private void generateCommand(GeneratorContext context, String ancestorId, Command command) {
        List<String> graphAttachmentNames = this.messageGraphAttachmentService.getAttachmentNames((MessageType)command);
        String content = this.templateRenderer.renderCommandPage(command, graphAttachmentNames);
        String pageId = this.confluenceAdapter.addOrUpdatePageUnderAncestor(ancestorId, command.getMessageTypeName(), content);
        this.messageGraphAttachmentService.generateAttachments((MessageType)command, pageId);
        context.addGeneratedPageIds(pageId);
    }

    @Generated
    public DocumentationGenerator(ConfluenceAdapter confluenceAdapter, TemplateRenderer templateRenderer, DocumentationGeneratorConfluenceProperties props, MessageGraphAttachmentService messageGraphAttachmentService) {
        this.confluenceAdapter = confluenceAdapter;
        this.templateRenderer = templateRenderer;
        this.props = props;
        this.messageGraphAttachmentService = messageGraphAttachmentService;
    }
}

