/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.docgen.graph;

import ch.admin.bit.jeap.archrepo.docgen.graph.models.GraphDto;
import jakarta.annotation.PreDestroy;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GraphvizRenderer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GraphvizRenderer.class);
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private final long timeoutSeconds;

    public GraphvizRenderer() {
        this.timeoutSeconds = 60L;
    }

    public GraphvizRenderer(long timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    @PreDestroy
    public void shutdownExecutor() {
        this.executor.shutdownNow();
    }

    public InputStream renderPng(GraphDto graph) {
        String dot = graph.toDot();
        log.debug("DOT content generated:\n{}", (Object)dot);
        Process process = null;
        try {
            process = this.startGraphvizProcess();
            this.writeDotToProcess(dot, process);
            byte[] imageBytes = this.readProcessOutput(process);
            log.debug("Graph image rendering completed successfully");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(imageBytes);
            return byteArrayInputStream;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("Graph rendering was interrupted.", (Throwable)e);
            throw new RuntimeException("Graph rendering was interrupted.", e);
        }
        catch (Exception e) {
            log.error("Error while rendering the graph.", (Throwable)e);
            throw new RuntimeException("Error while rendering the graph.", e);
        }
        finally {
            if (process != null) {
                this.validateProcessExit(process);
            }
        }
    }

    Process startGraphvizProcess() throws IOException {
        ProcessBuilder pb = new ProcessBuilder("dot", "-Tpng");
        log.debug("Starting Graphviz process");
        return pb.start();
    }

    private void writeDotToProcess(String dot, Process process) throws Exception {
        Future<?> writeFuture = this.executor.submit(() -> {
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));){
                writer.write(dot);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        try {
            writeFuture.get(this.timeoutSeconds, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            writeFuture.cancel(true);
            throw new RuntimeException("Timeout while writing DOT to Graphviz process", e);
        }
    }

    private byte[] readProcessOutput(Process process) throws Exception {
        Future<byte[]> readFuture = this.executor.submit(() -> {
            try (InputStream processOut = process.getInputStream();){
                byte[] byArray;
                try (ByteArrayOutputStream pngOutput = new ByteArrayOutputStream();){
                    processOut.transferTo(pngOutput);
                    byArray = pngOutput.toByteArray();
                }
                return byArray;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        try {
            return readFuture.get(this.timeoutSeconds, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            readFuture.cancel(true);
            throw new RuntimeException("Timeout while reading output from Graphviz process", e);
        }
    }

    void validateProcessExit(Process process) {
        try {
            boolean finished = process.waitFor(this.timeoutSeconds, TimeUnit.SECONDS);
            if (!finished) {
                process.destroyForcibly();
                log.error("Graphviz process timed out and was forcibly terminated.");
                return;
            }
            int exitCode = process.exitValue();
            if (exitCode != 0) {
                String errorOutput = new String(process.getErrorStream().readAllBytes(), StandardCharsets.UTF_8);
                log.error("Graphviz failed with exit code {}. Error output:\n{}", (Object)exitCode, (Object)errorOutput);
            }
        }
        catch (Exception e) {
            log.error("Unexpected error during Graphviz process validation.", (Throwable)e);
        }
    }
}

