/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.docgen.graph.models;

import ch.admin.bit.jeap.archrepo.docgen.graph.models.NodeDto;
import ch.admin.bit.jeap.archrepo.docgen.graph.models.NodeDtoType;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MessageNodeDto
implements NodeDto {
    private long id;
    private String messageType;
    private String variant;
    private boolean isHighlighted = false;

    @Override
    public String getDotId() {
        return NodeDtoType.MESSAGE.name() + "-" + this.id;
    }

    @Override
    public String toDot() {
        String style = this.isHighlighted ? ", style=filled, fillcolor=lightblue" : "";
        String messageNodeName = this.messageType.replaceAll("(Event|Command)$", "");
        String label = this.variant != null && !this.variant.isBlank() ? String.format("%s\\n[%s]", messageNodeName, this.variant) : messageNodeName;
        return String.format("  \"%s\" [label=\"%s\", shape=ellipse%s];", this.getDotId(), label, style);
    }

    @Override
    @Generated
    public long getId() {
        return this.id;
    }

    @Generated
    public String getMessageType() {
        return this.messageType;
    }

    @Generated
    public String getVariant() {
        return this.variant;
    }

    @Generated
    public boolean isHighlighted() {
        return this.isHighlighted;
    }

    @Generated
    public void setId(long id) {
        this.id = id;
    }

    @Generated
    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    @Generated
    public void setVariant(String variant) {
        this.variant = variant;
    }

    @Generated
    public void setHighlighted(boolean isHighlighted) {
        this.isHighlighted = isHighlighted;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageNodeDto)) {
            return false;
        }
        MessageNodeDto other = (MessageNodeDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.isHighlighted() != other.isHighlighted()) {
            return false;
        }
        String this$messageType = this.getMessageType();
        String other$messageType = other.getMessageType();
        if (this$messageType == null ? other$messageType != null : !this$messageType.equals(other$messageType)) {
            return false;
        }
        String this$variant = this.getVariant();
        String other$variant = other.getVariant();
        return !(this$variant == null ? other$variant != null : !this$variant.equals(other$variant));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MessageNodeDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        result = result * 59 + (this.isHighlighted() ? 79 : 97);
        String $messageType = this.getMessageType();
        result = result * 59 + ($messageType == null ? 43 : $messageType.hashCode());
        String $variant = this.getVariant();
        result = result * 59 + ($variant == null ? 43 : $variant.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MessageNodeDto(id=" + this.getId() + ", messageType=" + this.getMessageType() + ", variant=" + this.getVariant() + ", isHighlighted=" + this.isHighlighted() + ")";
    }

    @Generated
    public MessageNodeDto() {
    }

    @Generated
    public MessageNodeDto(long id, String messageType, String variant, boolean isHighlighted) {
        this.id = id;
        this.messageType = messageType;
        this.variant = variant;
        this.isHighlighted = isHighlighted;
    }
}

