/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.docgen.graph;

import ch.admin.bit.jeap.archrepo.docgen.ConfluenceAdapter;
import ch.admin.bit.jeap.archrepo.docgen.graph.GraphvizRenderer;
import ch.admin.bit.jeap.archrepo.docgen.graph.models.GraphDto;
import ch.admin.bit.jeap.archrepo.docgen.graph.models.MessageNodeDto;
import ch.admin.bit.jeap.archrepo.docgen.graph.models.NodeDto;
import ch.admin.bit.jeap.archrepo.metamodel.system.ComponentGraph;
import ch.admin.bit.jeap.archrepo.metamodel.system.SystemComponent;
import ch.admin.bit.jeap.archrepo.persistence.ComponentGraphRepository;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ComponentGraphAttachmentService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComponentGraphAttachmentService.class);
    private final ComponentGraphRepository componentGraphRepository;
    private final GraphvizRenderer imageRenderer;
    private final ConfluenceAdapter confluenceAdapter;
    private final ObjectMapper objectMapper;

    public void generateAttachment(SystemComponent component, String pageId) {
        try {
            ComponentGraph graph = this.componentGraphRepository.findByComponentNameIgnoreCase(component.getName());
            if (graph == null) {
                log.info("No graph found for component {}", (Object)component.getName());
                return;
            }
            if (this.isOutdated(graph)) {
                log.info("Graph fingerprint changed since last generation. Updating graph image for component {}.", (Object)component.getName());
                InputStream imageStream = this.createNewGraphPng(graph);
                this.confluenceAdapter.addOrUpdateAttachment(pageId, this.getComponentAttachmentName(component.getName()), imageStream);
                this.componentGraphRepository.updateLastPublishedFingerprint(graph.getId(), graph.getFingerprint());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error generating graph attachment", e);
        }
    }

    private InputStream createNewGraphPng(ComponentGraph graph) throws IOException {
        GraphDto graphDto = (GraphDto)this.objectMapper.readValue(graph.getGraphData(), GraphDto.class);
        this.highlightOtherSystemsMessageNodes(graphDto, graph.getSystemName());
        return this.imageRenderer.renderPng(graphDto);
    }

    void highlightOtherSystemsMessageNodes(GraphDto graph, String systemName) {
        for (NodeDto node : graph.getNodes()) {
            MessageNodeDto msgNode;
            if (!(node instanceof MessageNodeDto) || (msgNode = (MessageNodeDto)node).getMessageType().toLowerCase().startsWith(systemName.toLowerCase())) continue;
            msgNode.setHighlighted(true);
        }
    }

    boolean isOutdated(ComponentGraph graph) {
        return !graph.getFingerprint().equals(graph.getLastPublishedFingerprint());
    }

    public String getComponentAttachmentNameIfExists(String componentName) {
        ComponentGraph graph = this.componentGraphRepository.findByComponentNameIgnoreCase(componentName);
        if (graph == null) {
            return null;
        }
        return this.getComponentAttachmentName(componentName);
    }

    public String getComponentAttachmentName(String componentName) {
        return "graph-" + componentName + ".png";
    }

    @Generated
    public ComponentGraphAttachmentService(ComponentGraphRepository componentGraphRepository, GraphvizRenderer imageRenderer, ConfluenceAdapter confluenceAdapter, ObjectMapper objectMapper) {
        this.componentGraphRepository = componentGraphRepository;
        this.imageRenderer = imageRenderer;
        this.confluenceAdapter = confluenceAdapter;
        this.objectMapper = objectMapper;
    }
}

