/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.docgen.plantuml;

import ch.admin.bit.jeap.archrepo.docgen.ComponentContext;
import ch.admin.bit.jeap.archrepo.docgen.RelationView;
import ch.admin.bit.jeap.archrepo.docgen.SystemContext;
import ch.admin.bit.jeap.archrepo.docgen.plantuml.PlantUmlComponentView;
import ch.admin.bit.jeap.archrepo.docgen.plantuml.PlantUmlDbSchemaRenderer;
import ch.admin.bit.jeap.archrepo.metamodel.database.SystemComponentDatabaseSchema;
import ch.admin.bit.jeap.archrepo.model.database.DatabaseSchema;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class PlantUmlRenderer {
    public String renderSystemContextView(SystemContext systemContext) {
        PlantUmlComponentView componentView = new PlantUmlComponentView();
        String systemName = systemContext.getSystem().getName();
        componentView.addFocusedComponent(systemName).removeLink();
        systemContext.getSystemsInContext().forEach(name -> componentView.addComponent((String)name).removeLink());
        systemContext.getConsumedEventRelations().forEach(rel -> this.addIncomingRelation(componentView, (RelationView)rel, systemName));
        systemContext.getProducedEventRelations().forEach(rel -> this.addOutgoingRelation(componentView, (RelationView)rel, systemName));
        systemContext.getReceivedCommandRelations().forEach(rel -> this.addIncomingRelation(componentView, (RelationView)rel, systemName));
        systemContext.getSentCommandRelations().forEach(rel -> this.addOutgoingRelation(componentView, (RelationView)rel, systemName));
        systemContext.getProvidedRestApiRelations().forEach(rel -> this.addIncomingRelation(componentView, (RelationView)rel, systemName));
        systemContext.getConsumedRestApiRelations().forEach(rel -> this.addOutgoingRelation(componentView, (RelationView)rel, systemName));
        return componentView.render();
    }

    public String renderComponentContextView(ComponentContext componentContext) {
        PlantUmlComponentView componentView = new PlantUmlComponentView();
        String componentName = componentContext.getSystemComponent().getName();
        componentView.addFocusedComponent(componentName);
        componentContext.getComponentsInContext().forEach(componentView::addComponent);
        componentContext.getConsumedEventRelations().forEach(rel -> this.addIncomingRelation(componentView, (RelationView)rel, componentName));
        componentContext.getProducedEventRelations().forEach(rel -> this.addOutgoingRelation(componentView, (RelationView)rel, componentName));
        componentContext.getReceivedCommandRelations().forEach(rel -> this.addIncomingRelation(componentView, (RelationView)rel, componentName));
        componentContext.getSentCommandRelations().forEach(rel -> this.addOutgoingRelation(componentView, (RelationView)rel, componentName));
        componentContext.getProvidedRestApiRelations().forEach(rel -> this.addIncomingRelation(componentView, (RelationView)rel, componentName));
        componentContext.getConsumedRestApiRelations().forEach(rel -> this.addOutgoingRelation(componentView, (RelationView)rel, componentName));
        return componentView.render();
    }

    public String renderDatabaseSchema(ComponentContext componentContext) {
        return componentContext.getSystemComponent().getParent().getDatabaseSchema(componentContext.getSystemComponent().getName()).map(this::renderDatabaseSchema).orElse(null);
    }

    private String renderDatabaseSchema(SystemComponentDatabaseSchema systemComponentDatabaseSchema) {
        DatabaseSchema dbSchema = this.getDatabaseSchema(systemComponentDatabaseSchema);
        PlantUmlDbSchemaRenderer renderer = new PlantUmlDbSchemaRenderer();
        return renderer.renderDbSchema(dbSchema);
    }

    private DatabaseSchema getDatabaseSchema(SystemComponentDatabaseSchema systemComponentDatabaseSchema) {
        try {
            return DatabaseSchema.fromJson((byte[])systemComponentDatabaseSchema.getSchema());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot read the database schema for the system component '" + systemComponentDatabaseSchema.getSystemComponent().getName() + "'.", e);
        }
    }

    void addIncomingRelation(PlantUmlComponentView view, RelationView relation, String target) {
        if (StringUtils.isEmpty((String)relation.getCounterpart())) {
            return;
        }
        view.addRelation(relation.getCounterpart(), target, relation.getType(), relation.getLabel());
    }

    void addOutgoingRelation(PlantUmlComponentView view, RelationView relation, String source) {
        if (StringUtils.isEmpty((String)relation.getCounterpart()) || source.equals(relation.getCounterpart())) {
            return;
        }
        view.addRelation(source, relation.getCounterpart(), relation.getType(), relation.getLabel());
    }
}

