/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.docgen;

import ch.admin.bit.jeap.archrepo.docgen.RelationView;
import ch.admin.bit.jeap.archrepo.metamodel.ArchitectureModel;
import ch.admin.bit.jeap.archrepo.metamodel.Relation;
import ch.admin.bit.jeap.archrepo.metamodel.System;
import ch.admin.bit.jeap.archrepo.metamodel.relation.RelationType;
import com.google.common.collect.Streams;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;

public final class SystemContext {
    private static final Comparator<Relation> RELATION_COMPARATOR = Comparator.comparing(Relation::getConsumerName, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(Relation::getProviderName, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(Relation::getLabel);
    private final System system;
    private final List<RelationView> consumedRestApiRelations;
    private final List<RelationView> producedEventRelations;
    private final List<RelationView> sentCommandRelations;
    private final List<RelationView> providedRestApiRelations;
    private final List<RelationView> consumedEventRelations;
    private final List<RelationView> receivedCommandRelations;

    public static SystemContext of(ArchitectureModel model, System system) {
        List<RelationView> consumedRestApiRelations = SystemContext.getConsumedRelationsByType(model, system, RelationType.REST_API_RELATION);
        List<RelationView> producedEventRelations = SystemContext.getProvidedRelationsByType(model, system, RelationType.EVENT_RELATION);
        List<RelationView> sentCommandRelations = SystemContext.getProvidedRelationsByType(model, system, RelationType.COMMAND_RELATION);
        List<RelationView> providedRestApiRelations = SystemContext.getProvidedRelationsByType(model, system, RelationType.REST_API_RELATION);
        List<RelationView> consumedEventRelations = SystemContext.getConsumedRelationsByType(model, system, RelationType.EVENT_RELATION);
        List<RelationView> receivedCommandRelations = SystemContext.getConsumedRelationsByType(model, system, RelationType.COMMAND_RELATION);
        return SystemContext.builder().system(system).consumedRestApiRelations(consumedRestApiRelations).producedEventRelations(producedEventRelations).sentCommandRelations(sentCommandRelations).providedRestApiRelations(providedRestApiRelations).consumedEventRelations(consumedEventRelations).receivedCommandRelations(receivedCommandRelations).build();
    }

    public Set<String> getSystemsInContext() {
        return Streams.concat((Stream[])new Stream[]{this.consumedEventRelations.stream(), this.producedEventRelations.stream(), this.sentCommandRelations.stream(), this.providedRestApiRelations.stream(), this.consumedRestApiRelations.stream(), this.receivedCommandRelations.stream()}).map(RelationView::getCounterpart).filter(StringUtils::isNotEmpty).filter(name -> !this.system.getName().equals(name)).collect(Collectors.toSet());
    }

    private static List<RelationView> getConsumedRelationsByType(ArchitectureModel model, System system, RelationType relationType) {
        return model.getAllActiveRelationsByType(relationType).stream().filter(relation -> SystemContext.relationToOrFromComponentInSystem(model, system, relation)).sorted(RELATION_COMPARATOR).map(relation -> RelationView.of(relation, SystemContext.systemName(model, relation.getProviderName()))).filter(relation -> !system.getName().equals(relation.getCounterpart())).toList();
    }

    private static List<RelationView> getProvidedRelationsByType(ArchitectureModel model, System system, RelationType relationType) {
        return model.getAllActiveRelationsByType(relationType).stream().filter(relation -> SystemContext.relationToOrFromComponentInSystem(model, system, relation)).sorted(RELATION_COMPARATOR).map(relation -> RelationView.of(relation, SystemContext.systemName(model, relation.getConsumerName()))).filter(relation -> !system.getName().equals(relation.getCounterpart())).toList();
    }

    private static String systemName(ArchitectureModel model, String componentName) {
        if (StringUtils.isEmpty((String)componentName)) {
            return null;
        }
        return model.findSystemComponent(componentName).map(systemComponent -> systemComponent.getParent().getName()).orElse(null);
    }

    private static boolean relationToOrFromComponentInSystem(ArchitectureModel model, System system, Relation relation) {
        String consumerName = relation.getConsumerName();
        String providerName = relation.getProviderName();
        return SystemContext.partOfSystem(model, system, consumerName) || SystemContext.partOfSystem(model, system, providerName);
    }

    private static boolean partOfSystem(ArchitectureModel model, System system, String componentName) {
        if (StringUtils.isEmpty((String)componentName)) {
            return false;
        }
        return model.findSystemComponent(componentName).map(component -> system.equals((Object)component.getParent())).orElse(false);
    }

    @Generated
    SystemContext(System system, List<RelationView> consumedRestApiRelations, List<RelationView> producedEventRelations, List<RelationView> sentCommandRelations, List<RelationView> providedRestApiRelations, List<RelationView> consumedEventRelations, List<RelationView> receivedCommandRelations) {
        this.system = system;
        this.consumedRestApiRelations = consumedRestApiRelations;
        this.producedEventRelations = producedEventRelations;
        this.sentCommandRelations = sentCommandRelations;
        this.providedRestApiRelations = providedRestApiRelations;
        this.consumedEventRelations = consumedEventRelations;
        this.receivedCommandRelations = receivedCommandRelations;
    }

    @Generated
    private static SystemContextBuilder builder() {
        return new SystemContextBuilder();
    }

    @Generated
    public System getSystem() {
        return this.system;
    }

    @Generated
    public List<RelationView> getConsumedRestApiRelations() {
        return this.consumedRestApiRelations;
    }

    @Generated
    public List<RelationView> getProducedEventRelations() {
        return this.producedEventRelations;
    }

    @Generated
    public List<RelationView> getSentCommandRelations() {
        return this.sentCommandRelations;
    }

    @Generated
    public List<RelationView> getProvidedRestApiRelations() {
        return this.providedRestApiRelations;
    }

    @Generated
    public List<RelationView> getConsumedEventRelations() {
        return this.consumedEventRelations;
    }

    @Generated
    public List<RelationView> getReceivedCommandRelations() {
        return this.receivedCommandRelations;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SystemContext)) {
            return false;
        }
        SystemContext other = (SystemContext)o;
        System this$system = this.getSystem();
        System other$system = other.getSystem();
        if (this$system == null ? other$system != null : !this$system.equals(other$system)) {
            return false;
        }
        List<RelationView> this$consumedRestApiRelations = this.getConsumedRestApiRelations();
        List<RelationView> other$consumedRestApiRelations = other.getConsumedRestApiRelations();
        if (this$consumedRestApiRelations == null ? other$consumedRestApiRelations != null : !((Object)this$consumedRestApiRelations).equals(other$consumedRestApiRelations)) {
            return false;
        }
        List<RelationView> this$producedEventRelations = this.getProducedEventRelations();
        List<RelationView> other$producedEventRelations = other.getProducedEventRelations();
        if (this$producedEventRelations == null ? other$producedEventRelations != null : !((Object)this$producedEventRelations).equals(other$producedEventRelations)) {
            return false;
        }
        List<RelationView> this$sentCommandRelations = this.getSentCommandRelations();
        List<RelationView> other$sentCommandRelations = other.getSentCommandRelations();
        if (this$sentCommandRelations == null ? other$sentCommandRelations != null : !((Object)this$sentCommandRelations).equals(other$sentCommandRelations)) {
            return false;
        }
        List<RelationView> this$providedRestApiRelations = this.getProvidedRestApiRelations();
        List<RelationView> other$providedRestApiRelations = other.getProvidedRestApiRelations();
        if (this$providedRestApiRelations == null ? other$providedRestApiRelations != null : !((Object)this$providedRestApiRelations).equals(other$providedRestApiRelations)) {
            return false;
        }
        List<RelationView> this$consumedEventRelations = this.getConsumedEventRelations();
        List<RelationView> other$consumedEventRelations = other.getConsumedEventRelations();
        if (this$consumedEventRelations == null ? other$consumedEventRelations != null : !((Object)this$consumedEventRelations).equals(other$consumedEventRelations)) {
            return false;
        }
        List<RelationView> this$receivedCommandRelations = this.getReceivedCommandRelations();
        List<RelationView> other$receivedCommandRelations = other.getReceivedCommandRelations();
        return !(this$receivedCommandRelations == null ? other$receivedCommandRelations != null : !((Object)this$receivedCommandRelations).equals(other$receivedCommandRelations));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        System $system = this.getSystem();
        result = result * 59 + ($system == null ? 43 : $system.hashCode());
        List<RelationView> $consumedRestApiRelations = this.getConsumedRestApiRelations();
        result = result * 59 + ($consumedRestApiRelations == null ? 43 : ((Object)$consumedRestApiRelations).hashCode());
        List<RelationView> $producedEventRelations = this.getProducedEventRelations();
        result = result * 59 + ($producedEventRelations == null ? 43 : ((Object)$producedEventRelations).hashCode());
        List<RelationView> $sentCommandRelations = this.getSentCommandRelations();
        result = result * 59 + ($sentCommandRelations == null ? 43 : ((Object)$sentCommandRelations).hashCode());
        List<RelationView> $providedRestApiRelations = this.getProvidedRestApiRelations();
        result = result * 59 + ($providedRestApiRelations == null ? 43 : ((Object)$providedRestApiRelations).hashCode());
        List<RelationView> $consumedEventRelations = this.getConsumedEventRelations();
        result = result * 59 + ($consumedEventRelations == null ? 43 : ((Object)$consumedEventRelations).hashCode());
        List<RelationView> $receivedCommandRelations = this.getReceivedCommandRelations();
        result = result * 59 + ($receivedCommandRelations == null ? 43 : ((Object)$receivedCommandRelations).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SystemContext(system=" + String.valueOf(this.getSystem()) + ", consumedRestApiRelations=" + String.valueOf(this.getConsumedRestApiRelations()) + ", producedEventRelations=" + String.valueOf(this.getProducedEventRelations()) + ", sentCommandRelations=" + String.valueOf(this.getSentCommandRelations()) + ", providedRestApiRelations=" + String.valueOf(this.getProvidedRestApiRelations()) + ", consumedEventRelations=" + String.valueOf(this.getConsumedEventRelations()) + ", receivedCommandRelations=" + String.valueOf(this.getReceivedCommandRelations()) + ")";
    }

    @Generated
    private static class SystemContextBuilder {
        @Generated
        private System system;
        @Generated
        private List<RelationView> consumedRestApiRelations;
        @Generated
        private List<RelationView> producedEventRelations;
        @Generated
        private List<RelationView> sentCommandRelations;
        @Generated
        private List<RelationView> providedRestApiRelations;
        @Generated
        private List<RelationView> consumedEventRelations;
        @Generated
        private List<RelationView> receivedCommandRelations;

        @Generated
        SystemContextBuilder() {
        }

        @Generated
        private SystemContextBuilder system(System system) {
            this.system = system;
            return this;
        }

        @Generated
        private SystemContextBuilder consumedRestApiRelations(List<RelationView> consumedRestApiRelations) {
            this.consumedRestApiRelations = consumedRestApiRelations;
            return this;
        }

        @Generated
        private SystemContextBuilder producedEventRelations(List<RelationView> producedEventRelations) {
            this.producedEventRelations = producedEventRelations;
            return this;
        }

        @Generated
        private SystemContextBuilder sentCommandRelations(List<RelationView> sentCommandRelations) {
            this.sentCommandRelations = sentCommandRelations;
            return this;
        }

        @Generated
        private SystemContextBuilder providedRestApiRelations(List<RelationView> providedRestApiRelations) {
            this.providedRestApiRelations = providedRestApiRelations;
            return this;
        }

        @Generated
        private SystemContextBuilder consumedEventRelations(List<RelationView> consumedEventRelations) {
            this.consumedEventRelations = consumedEventRelations;
            return this;
        }

        @Generated
        private SystemContextBuilder receivedCommandRelations(List<RelationView> receivedCommandRelations) {
            this.receivedCommandRelations = receivedCommandRelations;
            return this;
        }

        @Generated
        private SystemContext build() {
            return new SystemContext(this.system, this.consumedRestApiRelations, this.producedEventRelations, this.sentCommandRelations, this.providedRestApiRelations, this.consumedEventRelations, this.receivedCommandRelations);
        }

        @Generated
        public String toString() {
            return "SystemContext.SystemContextBuilder(system=" + String.valueOf(this.system) + ", consumedRestApiRelations=" + String.valueOf(this.consumedRestApiRelations) + ", producedEventRelations=" + String.valueOf(this.producedEventRelations) + ", sentCommandRelations=" + String.valueOf(this.sentCommandRelations) + ", providedRestApiRelations=" + String.valueOf(this.providedRestApiRelations) + ", consumedEventRelations=" + String.valueOf(this.consumedEventRelations) + ", receivedCommandRelations=" + String.valueOf(this.receivedCommandRelations) + ")";
        }
    }
}

