/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.docgen.graph;

import ch.admin.bit.jeap.archrepo.docgen.ConfluenceAdapter;
import ch.admin.bit.jeap.archrepo.docgen.graph.GraphvizRenderer;
import ch.admin.bit.jeap.archrepo.docgen.graph.models.GraphDto;
import ch.admin.bit.jeap.archrepo.docgen.graph.models.MessageNodeDto;
import ch.admin.bit.jeap.archrepo.docgen.graph.models.NodeDto;
import ch.admin.bit.jeap.archrepo.metamodel.message.MessageGraph;
import ch.admin.bit.jeap.archrepo.metamodel.message.MessageType;
import ch.admin.bit.jeap.archrepo.persistence.MessageGraphRepository;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MessageGraphAttachmentService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageGraphAttachmentService.class);
    private final MessageGraphRepository messageGraphRepository;
    private final GraphvizRenderer imageRenderer;
    private final ConfluenceAdapter confluenceAdapter;
    private final ObjectMapper objectMapper;

    public void generateAttachments(MessageType message, String pageId) {
        try {
            List messageGraphs = this.messageGraphRepository.findAllByMessageTypeName(message.getMessageTypeName());
            if (messageGraphs.isEmpty()) {
                log.info("No graph found for message {}", (Object)message.getMessageTypeName());
                return;
            }
            List<MessageGraph> outdatedGraphs = this.filterOutdatedGraphs(messageGraphs);
            for (MessageGraph graph : outdatedGraphs) {
                log.info("Graph fingerprint changed since last generation. Updating graph image for message {} with variant {}.", (Object)message.getMessageTypeName(), (Object)Optional.ofNullable(graph.getVariant()).filter(v -> !v.isBlank()).orElse("not set"));
                InputStream imageStream = this.createNewGraphPng(message, graph);
                this.confluenceAdapter.addOrUpdateAttachment(pageId, this.generateMessageAttachmentName(graph), imageStream);
                this.messageGraphRepository.updateLastPublishedFingerprint(graph.getId(), graph.getFingerprint());
            }
            this.deleteUnusedGraphAttachments(pageId, messageGraphs);
        }
        catch (IOException e) {
            throw new RuntimeException("Error generating graph attachments", e);
        }
    }

    private void deleteUnusedGraphAttachments(String pageId, List<MessageGraph> messageGraphs) {
        List<String> attachmentNamesToKeep = messageGraphs.stream().map(this::generateMessageAttachmentName).toList();
        this.confluenceAdapter.deleteUnusedAttachments(pageId, attachmentNamesToKeep);
    }

    private InputStream createNewGraphPng(MessageType message, MessageGraph graph) throws IOException {
        GraphDto graphDto = (GraphDto)this.objectMapper.readValue(graph.getGraphData(), GraphDto.class);
        this.highlightMessageNode(graphDto, message);
        return this.imageRenderer.renderPng(graphDto);
    }

    public List<String> getAttachmentNames(MessageType message) {
        List messageGraphs = this.messageGraphRepository.findAllByMessageTypeName(message.getMessageTypeName());
        return messageGraphs.stream().map(this::generateMessageAttachmentName).sorted().toList();
    }

    List<MessageGraph> filterOutdatedGraphs(List<MessageGraph> graphs) {
        return graphs.stream().filter(graph -> !graph.getFingerprint().equals(graph.getLastPublishedFingerprint())).toList();
    }

    void highlightMessageNode(GraphDto graph, MessageType message) {
        for (NodeDto node : graph.getNodes()) {
            if (!(node instanceof MessageNodeDto)) continue;
            MessageNodeDto msgNode = (MessageNodeDto)node;
            if (!message.getMessageTypeName().equals(msgNode.getMessageType())) continue;
            msgNode.setHighlighted(true);
        }
    }

    String generateMessageAttachmentName(MessageGraph graph) {
        String base = "graph-" + graph.getMessageTypeName();
        return graph.getVariant().isBlank() ? base + ".png" : base + "-" + graph.getVariant() + ".png";
    }

    @Generated
    public MessageGraphAttachmentService(MessageGraphRepository messageGraphRepository, GraphvizRenderer imageRenderer, ConfluenceAdapter confluenceAdapter, ObjectMapper objectMapper) {
        this.messageGraphRepository = messageGraphRepository;
        this.imageRenderer = imageRenderer;
        this.confluenceAdapter = confluenceAdapter;
        this.objectMapper = objectMapper;
    }
}

