/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.docgen.plantuml;

import ch.admin.bit.jeap.archrepo.docgen.plantuml.PlantUmlRelationEdge;
import ch.admin.bit.jeap.archrepo.metamodel.relation.RelationType;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

final class PlantUmlRelation {
    private static final String EVENT_ARROW = " -[#green,dashed]-> ";
    private static final String COMMAND_ARROW = " -[#blue,dashed]-> ";
    private static final String SYNC_ARROW = " -[#blue]-> ";
    private final PlantUmlRelationEdge edge;
    private final List<String> labels = new ArrayList<String>();

    PlantUmlRelation(PlantUmlRelationEdge edge) {
        this.edge = edge;
    }

    void addLabel(String label) {
        this.labels.add(label);
    }

    void render(StringBuilder uml) {
        uml.append(this.edge.getSource()).append(PlantUmlRelation.arrow(this.edge.getType())).append(this.edge.getTarget()).append(" : \"").append(this.label()).append("\"\n");
    }

    String label() {
        int labelCount = this.labels.size();
        if (labelCount > 5) {
            return labelCount + " " + this.edge.getType().getLabel() + "s";
        }
        return String.join((CharSequence)"\\l", this.labels);
    }

    private static String arrow(RelationType type) {
        return switch (type) {
            case RelationType.COMMAND_RELATION -> COMMAND_ARROW;
            case RelationType.EVENT_RELATION -> EVENT_ARROW;
            default -> SYNC_ARROW;
        };
    }

    @Generated
    public PlantUmlRelationEdge getEdge() {
        return this.edge;
    }

    @Generated
    public List<String> getLabels() {
        return this.labels;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlantUmlRelation)) {
            return false;
        }
        PlantUmlRelation other = (PlantUmlRelation)o;
        PlantUmlRelationEdge this$edge = this.getEdge();
        PlantUmlRelationEdge other$edge = other.getEdge();
        if (this$edge == null ? other$edge != null : !((Object)this$edge).equals(other$edge)) {
            return false;
        }
        List<String> this$labels = this.getLabels();
        List<String> other$labels = other.getLabels();
        return !(this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PlantUmlRelationEdge $edge = this.getEdge();
        result = result * 59 + ($edge == null ? 43 : ((Object)$edge).hashCode());
        List<String> $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PlantUmlRelation(edge=" + String.valueOf(this.getEdge()) + ", labels=" + String.valueOf(this.getLabels()) + ")";
    }
}

