/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.docgen.graph;

import ch.admin.bit.jeap.archrepo.docgen.graph.models.GraphDto;
import jakarta.annotation.PreDestroy;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GraphvizRenderer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GraphvizRenderer.class);
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private final long timeoutSeconds;

    public GraphvizRenderer() {
        this.timeoutSeconds = 60L;
    }

    public GraphvizRenderer(long timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    @PreDestroy
    public void shutdownExecutor() {
        this.executor.shutdownNow();
    }

    /*
     * Exception decompiling
     */
    public InputStream renderPng(GraphDto graph) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void writeDotToProcess(String dot, OutputStream outputStream) throws Exception {
        Future<?> writeFuture = this.executor.submit(() -> {
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream));){
                writer.write(dot);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        try {
            writeFuture.get(this.timeoutSeconds, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            writeFuture.cancel(true);
            throw new RuntimeException("Timeout while writing DOT to Graphviz process", e);
        }
    }

    private byte[] readProcessOutput(InputStream inputStream) throws Exception {
        Future<byte[]> readFuture = this.executor.submit(() -> {
            byte[] byArray;
            ByteArrayOutputStream pngOutput = new ByteArrayOutputStream();
            try {
                inputStream.transferTo(pngOutput);
                byArray = pngOutput.toByteArray();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        pngOutput.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            pngOutput.close();
            return byArray;
        });
        try {
            return readFuture.get(this.timeoutSeconds, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            readFuture.cancel(true);
            throw new RuntimeException("Timeout while reading output from Graphviz process", e);
        }
    }

    Process startGraphvizProcess() throws IOException {
        ProcessBuilder pb = new ProcessBuilder("dot", "-Tpng");
        log.debug("Starting Graphviz process");
        return pb.start();
    }

    void validateProcessExit(Process process) {
        try {
            boolean finished = process.waitFor(this.timeoutSeconds, TimeUnit.SECONDS);
            if (!finished) {
                process.destroyForcibly();
                log.error("Graphviz process timed out and was forcibly terminated.");
                return;
            }
            int exitCode = process.exitValue();
            if (exitCode != 0) {
                log.error("Graphviz failed with exit code {}", (Object)exitCode);
            }
        }
        catch (Exception e) {
            log.error("Unexpected error during Graphviz process validation.", (Throwable)e);
        }
    }
}

