/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.docgen.graph.models;

import ch.admin.bit.jeap.archrepo.docgen.graph.models.NodeDto;
import ch.admin.bit.jeap.archrepo.docgen.graph.models.NodeDtoType;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ReactionNodeDto
implements NodeDto {
    private long id;
    private String component;
    private boolean isHighlighted = false;

    @Override
    public String getDotId() {
        return NodeDtoType.REACTION.name() + "-" + this.id;
    }

    @Override
    public String toDot() {
        String style = this.isHighlighted ? ", style=filled, fillcolor=lightblue" : "";
        String componentName = this.component.replaceAll("(-scs|-service|-component)$", "");
        String label = String.format("%s\\n%d", componentName, this.id);
        return String.format("  \"%s\" [label=\"%s\", shape=box, style=rounded%s];", this.getDotId(), label, style);
    }

    @Override
    @Generated
    public long getId() {
        return this.id;
    }

    @Generated
    public String getComponent() {
        return this.component;
    }

    @Generated
    public boolean isHighlighted() {
        return this.isHighlighted;
    }

    @Generated
    public void setId(long id) {
        this.id = id;
    }

    @Generated
    public void setComponent(String component) {
        this.component = component;
    }

    @Generated
    public void setHighlighted(boolean isHighlighted) {
        this.isHighlighted = isHighlighted;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReactionNodeDto)) {
            return false;
        }
        ReactionNodeDto other = (ReactionNodeDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.isHighlighted() != other.isHighlighted()) {
            return false;
        }
        String this$component = this.getComponent();
        String other$component = other.getComponent();
        return !(this$component == null ? other$component != null : !this$component.equals(other$component));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReactionNodeDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        result = result * 59 + (this.isHighlighted() ? 79 : 97);
        String $component = this.getComponent();
        result = result * 59 + ($component == null ? 43 : $component.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ReactionNodeDto(id=" + this.getId() + ", component=" + this.getComponent() + ", isHighlighted=" + this.isHighlighted() + ")";
    }

    @Generated
    public ReactionNodeDto() {
    }

    @Generated
    public ReactionNodeDto(long id, String component, boolean isHighlighted) {
        this.id = id;
        this.component = component;
        this.isHighlighted = isHighlighted;
    }
}

