/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.docgen;

import ch.admin.bit.jeap.archrepo.docgen.ProvidedRestAPIRelationView;
import ch.admin.bit.jeap.archrepo.docgen.RelationView;
import ch.admin.bit.jeap.archrepo.docgen.RestApiGroupedResult;
import ch.admin.bit.jeap.archrepo.docgen.RestApiKey;
import ch.admin.bit.jeap.archrepo.metamodel.ArchitectureModel;
import ch.admin.bit.jeap.archrepo.metamodel.Relation;
import ch.admin.bit.jeap.archrepo.metamodel.relation.RelationType;
import ch.admin.bit.jeap.archrepo.metamodel.relation.RestApiRelation;
import ch.admin.bit.jeap.archrepo.metamodel.system.SystemComponent;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;

public final class ComponentContext {
    private static final Comparator<Relation> RELATION_COMPARATOR = Comparator.comparing(Relation::getConsumerName, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(Relation::getProviderName, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(Relation::getLabel);
    private final SystemComponent systemComponent;
    private final String openApiSpecUrl;
    private final List<RelationView> consumedRestApiRelations;
    private final List<RelationView> producedEventRelations;
    private final List<RelationView> sentCommandRelations;
    private final List<RelationView> providedRestApiRelations;
    private final List<ProvidedRestAPIRelationView> providedRestApiRelationViews;
    private final List<RelationView> consumedEventRelations;
    private final List<RelationView> receivedCommandRelations;

    public static ComponentContext of(ArchitectureModel model, SystemComponent systemComponent) {
        List<RelationView> consumedRestApiRelations = ComponentContext.getConsumedRelationsByType(model, systemComponent, RelationType.REST_API_RELATION);
        List<RelationView> producedEventRelations = ComponentContext.getProvidedRelationsByType(model, systemComponent, RelationType.EVENT_RELATION);
        List<RelationView> sentCommandRelations = ComponentContext.getProvidedRelationsByType(model, systemComponent, RelationType.COMMAND_RELATION);
        List<RelationView> providedRestApiRelations = ComponentContext.getProvidedRelationsByType(model, systemComponent, RelationType.REST_API_RELATION);
        List<ProvidedRestAPIRelationView> providedRestApiRelationViews = ComponentContext.getProvidedRestApiRelations(model, systemComponent);
        List<RelationView> consumedEventRelations = ComponentContext.getConsumedRelationsByType(model, systemComponent, RelationType.EVENT_RELATION);
        List<RelationView> receivedCommandRelations = ComponentContext.getConsumedRelationsByType(model, systemComponent, RelationType.COMMAND_RELATION);
        String openApiSpecUrl = ComponentContext.getOpenApiUrl(model, systemComponent);
        return ComponentContext.builder().systemComponent(systemComponent).consumedRestApiRelations(consumedRestApiRelations).producedEventRelations(producedEventRelations).sentCommandRelations(sentCommandRelations).providedRestApiRelations(providedRestApiRelations).providedRestApiRelationViews(providedRestApiRelationViews).consumedEventRelations(consumedEventRelations).receivedCommandRelations(receivedCommandRelations).openApiSpecUrl(openApiSpecUrl).build();
    }

    public Set<String> getComponentsInContext() {
        return Streams.concat((Stream[])new Stream[]{this.consumedEventRelations.stream(), this.producedEventRelations.stream(), this.sentCommandRelations.stream(), this.providedRestApiRelations.stream(), this.consumedRestApiRelations.stream(), this.receivedCommandRelations.stream()}).map(RelationView::getCounterpart).filter(StringUtils::isNotEmpty).filter(name -> !this.systemComponent.getName().equals(name)).collect(Collectors.toSet());
    }

    public Map<RelationView, List<RelationView>> getProducedEventsGroupedByEvent() {
        return ComponentContext.getRelationViewGroupedRecord(this.producedEventRelations);
    }

    public Map<RelationView, List<RelationView>> getSentCommandsGroupedByCommand() {
        return ComponentContext.getRelationViewGroupedRecord(this.sentCommandRelations);
    }

    public Map<RelationView, List<RelationView>> getConsumedEventsGroupedByEvent() {
        return ComponentContext.getRelationViewGroupedRecord(this.consumedEventRelations);
    }

    public Map<RelationView, List<RelationView>> getReceivedCommandsGroupedByCommand() {
        return ComponentContext.getRelationViewGroupedRecord(this.receivedCommandRelations);
    }

    public List<RestApiGroupedResult> getProvidedRestApiRelationsGroupedByPath() {
        ArrayList<RestApiGroupedResult> result = new ArrayList<RestApiGroupedResult>();
        for (Map.Entry<String, List<ProvidedRestAPIRelationView>> entry : this.getProvidedRestApiRelationViewsGroupedByPath().entrySet()) {
            Map<String, List<ProvidedRestAPIRelationView>> groupedByMethod = this.getProvidedRestApiRelationViewsGroupedByMethod(entry.getValue());
            boolean firstRow = true;
            for (Map.Entry<String, List<ProvidedRestAPIRelationView>> relation : groupedByMethod.entrySet()) {
                if (firstRow) {
                    result.add(new RestApiGroupedResult(new RestApiKey(entry.getKey(), groupedByMethod.size()), relation.getKey(), relation.getValue()));
                    firstRow = false;
                    continue;
                }
                result.add(new RestApiGroupedResult(null, relation.getKey(), relation.getValue()));
            }
        }
        return result;
    }

    private Map<String, List<ProvidedRestAPIRelationView>> getProvidedRestApiRelationViewsGroupedByPath() {
        return new TreeMap<String, List<ProvidedRestAPIRelationView>>(this.providedRestApiRelationViews.stream().collect(Collectors.groupingBy(ProvidedRestAPIRelationView::getPath)));
    }

    private Map<String, List<ProvidedRestAPIRelationView>> getProvidedRestApiRelationViewsGroupedByMethod(List<ProvidedRestAPIRelationView> relations) {
        return new TreeMap<String, List<ProvidedRestAPIRelationView>>(relations.stream().collect(Collectors.groupingBy(ProvidedRestAPIRelationView::getMethod)));
    }

    private static Map<RelationView, List<RelationView>> getRelationViewGroupedRecord(List<RelationView> relationViews) {
        TreeMap<RelationView, List<RelationView>> result = new TreeMap<RelationView, List<RelationView>>(Comparator.comparing(o -> o.getLabel().toLowerCase()));
        for (Map.Entry<String, List<RelationView>> entry : relationViews.stream().collect(Collectors.groupingBy(RelationView::getLabel)).entrySet()) {
            RelationView relationView = entry.getValue().getFirst();
            result.put(relationView, entry.getValue().stream().distinct().collect(Collectors.toList()));
        }
        return result;
    }

    private static List<RelationView> getConsumedRelationsByType(ArchitectureModel model, SystemComponent systemComponent, RelationType relationType) {
        return model.getAllActiveRelationsByType(relationType).stream().filter(relation -> systemComponent.getName().equals(relation.getConsumerName())).sorted(RELATION_COMPARATOR).map(RelationView::ofConsumedRelation).toList();
    }

    private static List<RelationView> getProvidedRelationsByType(ArchitectureModel model, SystemComponent systemComponent, RelationType relationType) {
        return model.getAllActiveRelationsByType(relationType).stream().filter(relation -> systemComponent.getName().equals(relation.getProviderName())).sorted(RELATION_COMPARATOR).map(RelationView::ofProvidedRelation).toList();
    }

    private static List<ProvidedRestAPIRelationView> getProvidedRestApiRelations(ArchitectureModel model, SystemComponent systemComponent) {
        return model.getAllActiveRelationsByType(RelationType.REST_API_RELATION).stream().filter(relation -> systemComponent.getName().equals(relation.getProviderName())).map(RestApiRelation.class::cast).map(ProvidedRestAPIRelationView::of).toList();
    }

    private static String getOpenApiUrl(ArchitectureModel model, SystemComponent systemComponent) {
        Optional restApi = model.getRestApiForSystemComponent(systemComponent);
        return restApi.orElse("");
    }

    @Generated
    ComponentContext(SystemComponent systemComponent, String openApiSpecUrl, List<RelationView> consumedRestApiRelations, List<RelationView> producedEventRelations, List<RelationView> sentCommandRelations, List<RelationView> providedRestApiRelations, List<ProvidedRestAPIRelationView> providedRestApiRelationViews, List<RelationView> consumedEventRelations, List<RelationView> receivedCommandRelations) {
        this.systemComponent = systemComponent;
        this.openApiSpecUrl = openApiSpecUrl;
        this.consumedRestApiRelations = consumedRestApiRelations;
        this.producedEventRelations = producedEventRelations;
        this.sentCommandRelations = sentCommandRelations;
        this.providedRestApiRelations = providedRestApiRelations;
        this.providedRestApiRelationViews = providedRestApiRelationViews;
        this.consumedEventRelations = consumedEventRelations;
        this.receivedCommandRelations = receivedCommandRelations;
    }

    @Generated
    private static ComponentContextBuilder builder() {
        return new ComponentContextBuilder();
    }

    @Generated
    public SystemComponent getSystemComponent() {
        return this.systemComponent;
    }

    @Generated
    public String getOpenApiSpecUrl() {
        return this.openApiSpecUrl;
    }

    @Generated
    public List<RelationView> getConsumedRestApiRelations() {
        return this.consumedRestApiRelations;
    }

    @Generated
    public List<RelationView> getProducedEventRelations() {
        return this.producedEventRelations;
    }

    @Generated
    public List<RelationView> getSentCommandRelations() {
        return this.sentCommandRelations;
    }

    @Generated
    public List<RelationView> getProvidedRestApiRelations() {
        return this.providedRestApiRelations;
    }

    @Generated
    public List<ProvidedRestAPIRelationView> getProvidedRestApiRelationViews() {
        return this.providedRestApiRelationViews;
    }

    @Generated
    public List<RelationView> getConsumedEventRelations() {
        return this.consumedEventRelations;
    }

    @Generated
    public List<RelationView> getReceivedCommandRelations() {
        return this.receivedCommandRelations;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComponentContext)) {
            return false;
        }
        ComponentContext other = (ComponentContext)o;
        SystemComponent this$systemComponent = this.getSystemComponent();
        SystemComponent other$systemComponent = other.getSystemComponent();
        if (this$systemComponent == null ? other$systemComponent != null : !this$systemComponent.equals(other$systemComponent)) {
            return false;
        }
        String this$openApiSpecUrl = this.getOpenApiSpecUrl();
        String other$openApiSpecUrl = other.getOpenApiSpecUrl();
        if (this$openApiSpecUrl == null ? other$openApiSpecUrl != null : !this$openApiSpecUrl.equals(other$openApiSpecUrl)) {
            return false;
        }
        List<RelationView> this$consumedRestApiRelations = this.getConsumedRestApiRelations();
        List<RelationView> other$consumedRestApiRelations = other.getConsumedRestApiRelations();
        if (this$consumedRestApiRelations == null ? other$consumedRestApiRelations != null : !((Object)this$consumedRestApiRelations).equals(other$consumedRestApiRelations)) {
            return false;
        }
        List<RelationView> this$producedEventRelations = this.getProducedEventRelations();
        List<RelationView> other$producedEventRelations = other.getProducedEventRelations();
        if (this$producedEventRelations == null ? other$producedEventRelations != null : !((Object)this$producedEventRelations).equals(other$producedEventRelations)) {
            return false;
        }
        List<RelationView> this$sentCommandRelations = this.getSentCommandRelations();
        List<RelationView> other$sentCommandRelations = other.getSentCommandRelations();
        if (this$sentCommandRelations == null ? other$sentCommandRelations != null : !((Object)this$sentCommandRelations).equals(other$sentCommandRelations)) {
            return false;
        }
        List<RelationView> this$providedRestApiRelations = this.getProvidedRestApiRelations();
        List<RelationView> other$providedRestApiRelations = other.getProvidedRestApiRelations();
        if (this$providedRestApiRelations == null ? other$providedRestApiRelations != null : !((Object)this$providedRestApiRelations).equals(other$providedRestApiRelations)) {
            return false;
        }
        List<ProvidedRestAPIRelationView> this$providedRestApiRelationViews = this.getProvidedRestApiRelationViews();
        List<ProvidedRestAPIRelationView> other$providedRestApiRelationViews = other.getProvidedRestApiRelationViews();
        if (this$providedRestApiRelationViews == null ? other$providedRestApiRelationViews != null : !((Object)this$providedRestApiRelationViews).equals(other$providedRestApiRelationViews)) {
            return false;
        }
        List<RelationView> this$consumedEventRelations = this.getConsumedEventRelations();
        List<RelationView> other$consumedEventRelations = other.getConsumedEventRelations();
        if (this$consumedEventRelations == null ? other$consumedEventRelations != null : !((Object)this$consumedEventRelations).equals(other$consumedEventRelations)) {
            return false;
        }
        List<RelationView> this$receivedCommandRelations = this.getReceivedCommandRelations();
        List<RelationView> other$receivedCommandRelations = other.getReceivedCommandRelations();
        return !(this$receivedCommandRelations == null ? other$receivedCommandRelations != null : !((Object)this$receivedCommandRelations).equals(other$receivedCommandRelations));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SystemComponent $systemComponent = this.getSystemComponent();
        result = result * 59 + ($systemComponent == null ? 43 : $systemComponent.hashCode());
        String $openApiSpecUrl = this.getOpenApiSpecUrl();
        result = result * 59 + ($openApiSpecUrl == null ? 43 : $openApiSpecUrl.hashCode());
        List<RelationView> $consumedRestApiRelations = this.getConsumedRestApiRelations();
        result = result * 59 + ($consumedRestApiRelations == null ? 43 : ((Object)$consumedRestApiRelations).hashCode());
        List<RelationView> $producedEventRelations = this.getProducedEventRelations();
        result = result * 59 + ($producedEventRelations == null ? 43 : ((Object)$producedEventRelations).hashCode());
        List<RelationView> $sentCommandRelations = this.getSentCommandRelations();
        result = result * 59 + ($sentCommandRelations == null ? 43 : ((Object)$sentCommandRelations).hashCode());
        List<RelationView> $providedRestApiRelations = this.getProvidedRestApiRelations();
        result = result * 59 + ($providedRestApiRelations == null ? 43 : ((Object)$providedRestApiRelations).hashCode());
        List<ProvidedRestAPIRelationView> $providedRestApiRelationViews = this.getProvidedRestApiRelationViews();
        result = result * 59 + ($providedRestApiRelationViews == null ? 43 : ((Object)$providedRestApiRelationViews).hashCode());
        List<RelationView> $consumedEventRelations = this.getConsumedEventRelations();
        result = result * 59 + ($consumedEventRelations == null ? 43 : ((Object)$consumedEventRelations).hashCode());
        List<RelationView> $receivedCommandRelations = this.getReceivedCommandRelations();
        result = result * 59 + ($receivedCommandRelations == null ? 43 : ((Object)$receivedCommandRelations).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ComponentContext(systemComponent=" + String.valueOf(this.getSystemComponent()) + ", openApiSpecUrl=" + this.getOpenApiSpecUrl() + ", consumedRestApiRelations=" + String.valueOf(this.getConsumedRestApiRelations()) + ", producedEventRelations=" + String.valueOf(this.getProducedEventRelations()) + ", sentCommandRelations=" + String.valueOf(this.getSentCommandRelations()) + ", providedRestApiRelations=" + String.valueOf(this.getProvidedRestApiRelations()) + ", providedRestApiRelationViews=" + String.valueOf(this.getProvidedRestApiRelationViews()) + ", consumedEventRelations=" + String.valueOf(this.getConsumedEventRelations()) + ", receivedCommandRelations=" + String.valueOf(this.getReceivedCommandRelations()) + ")";
    }

    @Generated
    private static class ComponentContextBuilder {
        @Generated
        private SystemComponent systemComponent;
        @Generated
        private String openApiSpecUrl;
        @Generated
        private List<RelationView> consumedRestApiRelations;
        @Generated
        private List<RelationView> producedEventRelations;
        @Generated
        private List<RelationView> sentCommandRelations;
        @Generated
        private List<RelationView> providedRestApiRelations;
        @Generated
        private List<ProvidedRestAPIRelationView> providedRestApiRelationViews;
        @Generated
        private List<RelationView> consumedEventRelations;
        @Generated
        private List<RelationView> receivedCommandRelations;

        @Generated
        ComponentContextBuilder() {
        }

        @Generated
        private ComponentContextBuilder systemComponent(SystemComponent systemComponent) {
            this.systemComponent = systemComponent;
            return this;
        }

        @Generated
        private ComponentContextBuilder openApiSpecUrl(String openApiSpecUrl) {
            this.openApiSpecUrl = openApiSpecUrl;
            return this;
        }

        @Generated
        private ComponentContextBuilder consumedRestApiRelations(List<RelationView> consumedRestApiRelations) {
            this.consumedRestApiRelations = consumedRestApiRelations;
            return this;
        }

        @Generated
        private ComponentContextBuilder producedEventRelations(List<RelationView> producedEventRelations) {
            this.producedEventRelations = producedEventRelations;
            return this;
        }

        @Generated
        private ComponentContextBuilder sentCommandRelations(List<RelationView> sentCommandRelations) {
            this.sentCommandRelations = sentCommandRelations;
            return this;
        }

        @Generated
        private ComponentContextBuilder providedRestApiRelations(List<RelationView> providedRestApiRelations) {
            this.providedRestApiRelations = providedRestApiRelations;
            return this;
        }

        @Generated
        private ComponentContextBuilder providedRestApiRelationViews(List<ProvidedRestAPIRelationView> providedRestApiRelationViews) {
            this.providedRestApiRelationViews = providedRestApiRelationViews;
            return this;
        }

        @Generated
        private ComponentContextBuilder consumedEventRelations(List<RelationView> consumedEventRelations) {
            this.consumedEventRelations = consumedEventRelations;
            return this;
        }

        @Generated
        private ComponentContextBuilder receivedCommandRelations(List<RelationView> receivedCommandRelations) {
            this.receivedCommandRelations = receivedCommandRelations;
            return this;
        }

        @Generated
        private ComponentContext build() {
            return new ComponentContext(this.systemComponent, this.openApiSpecUrl, this.consumedRestApiRelations, this.producedEventRelations, this.sentCommandRelations, this.providedRestApiRelations, this.providedRestApiRelationViews, this.consumedEventRelations, this.receivedCommandRelations);
        }

        @Generated
        public String toString() {
            return "ComponentContext.ComponentContextBuilder(systemComponent=" + String.valueOf(this.systemComponent) + ", openApiSpecUrl=" + this.openApiSpecUrl + ", consumedRestApiRelations=" + String.valueOf(this.consumedRestApiRelations) + ", producedEventRelations=" + String.valueOf(this.producedEventRelations) + ", sentCommandRelations=" + String.valueOf(this.sentCommandRelations) + ", providedRestApiRelations=" + String.valueOf(this.providedRestApiRelations) + ", providedRestApiRelationViews=" + String.valueOf(this.providedRestApiRelationViews) + ", consumedEventRelations=" + String.valueOf(this.consumedEventRelations) + ", receivedCommandRelations=" + String.valueOf(this.receivedCommandRelations) + ")";
        }
    }
}

