/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.docgen.graph;

import ch.admin.bit.jeap.archrepo.docgen.ConfluenceAdapter;
import ch.admin.bit.jeap.archrepo.docgen.graph.GraphvizRenderer;
import ch.admin.bit.jeap.archrepo.docgen.graph.models.GraphDto;
import ch.admin.bit.jeap.archrepo.docgen.graph.models.MessageNodeDto;
import ch.admin.bit.jeap.archrepo.docgen.graph.models.NodeDto;
import ch.admin.bit.jeap.archrepo.metamodel.System;
import ch.admin.bit.jeap.archrepo.metamodel.system.SystemGraph;
import ch.admin.bit.jeap.archrepo.persistence.SystemGraphRepository;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SystemGraphAttachmentService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SystemGraphAttachmentService.class);
    private final SystemGraphRepository systemGraphRepository;
    private final GraphvizRenderer imageRenderer;
    private final ConfluenceAdapter confluenceAdapter;
    private final ObjectMapper objectMapper;

    public void generateAttachment(System system, String pageId) {
        try {
            SystemGraph graph = this.systemGraphRepository.findBySystemNameIgnoreCase(system.getName());
            if (graph == null) {
                log.info("No graph found for system {}", (Object)system.getName());
                return;
            }
            if (this.isOutdated(graph)) {
                log.info("Graph fingerprint changed since last generation. Updating graph image for system {}.", (Object)system.getName());
                InputStream imageStream = this.createNewGraphPng(system, graph);
                this.confluenceAdapter.addOrUpdateAttachment(pageId, this.getSystemAttachmentName(system.getName()), imageStream);
                this.systemGraphRepository.updateLastPublishedFingerprint(graph.getId(), graph.getFingerprint());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error generating graph attachment", e);
        }
    }

    private InputStream createNewGraphPng(System system, SystemGraph graph) throws IOException {
        GraphDto graphDto = (GraphDto)this.objectMapper.readValue(graph.getGraphData(), GraphDto.class);
        this.highlightOtherSystemsMessageNodes(graphDto, system);
        return this.imageRenderer.renderPng(graphDto);
    }

    boolean isOutdated(SystemGraph graph) {
        return !graph.getFingerprint().equals(graph.getLastPublishedFingerprint());
    }

    void highlightOtherSystemsMessageNodes(GraphDto graph, System system) {
        for (NodeDto node : graph.getNodes()) {
            MessageNodeDto msgNode;
            if (!(node instanceof MessageNodeDto) || (msgNode = (MessageNodeDto)node).getMessageType().toLowerCase().startsWith(system.getName().toLowerCase())) continue;
            msgNode.setHighlighted(true);
        }
    }

    public String getSystemAttachmentNameIfExists(String systemName) {
        SystemGraph graph = this.systemGraphRepository.findBySystemNameIgnoreCase(systemName);
        if (graph == null) {
            return null;
        }
        return this.getSystemAttachmentName(systemName);
    }

    public String getSystemAttachmentName(String systemName) {
        return "graph-" + systemName + ".png";
    }

    @Generated
    public SystemGraphAttachmentService(SystemGraphRepository systemGraphRepository, GraphvizRenderer imageRenderer, ConfluenceAdapter confluenceAdapter, ObjectMapper objectMapper) {
        this.systemGraphRepository = systemGraphRepository;
        this.imageRenderer = imageRenderer;
        this.confluenceAdapter = confluenceAdapter;
        this.objectMapper = objectMapper;
    }
}

