/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.importer.openapi;

import ch.admin.bit.jeap.archrepo.importer.openapi.OpenApiFileParsingException;
import ch.admin.bit.jeap.archrepo.metamodel.Importer;
import ch.admin.bit.jeap.archrepo.metamodel.restapi.RestApi;
import ch.admin.bit.jeap.archrepo.metamodel.system.SystemComponent;
import ch.admin.bit.jeap.archrepo.persistence.RestApiRepository;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class OpenApiImporter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenApiImporter.class);
    private final ObjectMapper objectMapper;
    private final RestApiRepository restApiRepository;

    @Transactional
    public void importIntoModel(SystemComponent systemComponent, byte[] openApiSpecFileContent) {
        log.info("Importing into OpenAPI model");
        List<RestApi> restApisFromFile = this.readEndpointsFromOpenApiFile(systemComponent, openApiSpecFileContent);
        List currentRestApis = this.restApiRepository.findByDefiningSystemAndProvider(systemComponent.getParent(), systemComponent);
        List<RestApi> toDelete = this.filterRestApisToDelete(currentRestApis);
        this.updateOrAddRestApis(restApisFromFile, currentRestApis, toDelete);
        this.deleteOldRestApis(toDelete);
    }

    private void updateOrAddRestApis(List<RestApi> restApisFromFile, List<RestApi> currentRestApis, List<RestApi> toDelete) {
        for (RestApi restApi : restApisFromFile) {
            Optional<RestApi> currentRestApi = this.findMatchingRestApi(restApi, currentRestApis);
            if (currentRestApi.isPresent()) {
                log.info("REST API already defined: {} {}", (Object)restApi.getMethod(), (Object)restApi.getPath());
                currentRestApi.get().addImporter(Importer.OPEN_API);
                toDelete.remove(currentRestApi.get());
                continue;
            }
            log.info("REST API not defined: {} {}", (Object)restApi.getMethod(), (Object)restApi.getPath());
            this.restApiRepository.save((Object)restApi);
        }
        this.markRestApisForDeletion(toDelete);
    }

    private void markRestApisForDeletion(List<RestApi> toDelete) {
        toDelete.removeIf(restApi -> {
            restApi.removeImporter(Importer.OPEN_API);
            return !restApi.getImporters().isEmpty();
        });
    }

    private List<RestApi> filterRestApisToDelete(List<RestApi> currentRestApis) {
        return currentRestApis.stream().filter(current -> current.getImporters().contains(Importer.OPEN_API)).collect(Collectors.toList());
    }

    private void deleteOldRestApis(List<RestApi> toDelete) {
        log.info("Deleting old REST APIs, count: {}", (Object)toDelete.size());
        toDelete.forEach(restApi -> log.info("REST API deleted: {} {}", (Object)restApi.getMethod(), (Object)restApi.getPath()));
        this.restApiRepository.deleteAll(toDelete);
    }

    private Optional<RestApi> findMatchingRestApi(RestApi restApi, List<RestApi> currentRestApis) {
        return currentRestApis.stream().filter(current -> current.getPath().equals(restApi.getPath()) && current.getMethod().equals(restApi.getMethod())).findFirst();
    }

    private List<RestApi> readEndpointsFromOpenApiFile(SystemComponent systemComponent, byte[] openApiSpecFileContent) {
        log.info("Parsing OpenAPI file...");
        ArrayList<RestApi> restApis = new ArrayList<RestApi>();
        try {
            Map openApi = (Map)this.objectMapper.readValue(openApiSpecFileContent, (TypeReference)new TypeReference<Map<String, Object>>(this){});
            Map paths = (Map)openApi.get("paths");
            paths.forEach((path, methods) -> ((Map)methods).forEach((method, value) -> {
                log.debug("Found path: {} {}", method, path);
                restApis.add(new RestApi(systemComponent, method, path, Importer.OPEN_API));
            }));
        }
        catch (Exception e) {
            String message = "Failed to parse the provided OpenAPI file to retrieve the rest apis";
            log.warn(message, (Throwable)e);
            throw new OpenApiFileParsingException(message, e);
        }
        return restApis;
    }

    public String getServerUrl(byte[] openApiSpecFileContent) {
        log.info("Get Server URL from OpenAPI file...");
        try {
            Map openApi = (Map)this.objectMapper.readValue(openApiSpecFileContent, (TypeReference)new TypeReference<Map<String, Object>>(this){});
            List servers = (List)openApi.get("servers");
            String url = (String)((Map)servers.getFirst()).get("url");
            log.info("Found server url: {}", (Object)url);
            return url;
        }
        catch (Exception e) {
            String message = "Failed to parse the provided OpenAPI file to retrieve the server url";
            log.warn(message, (Throwable)e);
            throw new OpenApiFileParsingException(message, e);
        }
    }

    @Generated
    public OpenApiImporter(ObjectMapper objectMapper, RestApiRepository restApiRepository) {
        this.objectMapper = objectMapper;
        this.restApiRepository = restApiRepository;
    }
}

