/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.importer.pactbroker.client;

import au.com.dius.pact.core.model.BrokerUrlSource;
import au.com.dius.pact.core.model.DefaultPactReader;
import au.com.dius.pact.core.model.Pact;
import au.com.dius.pact.core.model.PactReaderKt;
import au.com.dius.pact.core.model.PactSource;
import au.com.dius.pact.core.model.UrlPactSource;
import au.com.dius.pact.core.pactbroker.HalClient;
import au.com.dius.pact.core.pactbroker.PactBrokerClientConfig;
import au.com.dius.pact.core.support.json.JsonValue;
import ch.admin.bit.jeap.archrepo.importer.pactbroker.client.BrokeredPact;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Pair;
import lombok.Generated;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PactBrokerClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PactBrokerClient.class);
    private static final String LATEST_PACTS_LINK_NAME = "pb:latest-pact-versions";
    private static final String PACTS_LINK_NAME = "pb:pacts";
    private static final String HREF_ATTRIBUTE_NAME = "href";
    private final CloseableHttpClient httpClient;
    private final String pactBrokerUrl;

    public void withAllPacts(Consumer<BrokeredPact> pactCallback) {
        List<String> latestPactUrls = this.getLatestPactUrls();
        latestPactUrls.forEach(pactUrl -> this.loadPactInvokingCallbackOnSuccess(pactCallback, (String)pactUrl));
    }

    private void loadPactInvokingCallbackOnSuccess(Consumer<BrokeredPact> pactCallback, String pactUrl) {
        try {
            BrokeredPact brokeredPact = BrokeredPact.builder().pactUrl(pactUrl).pact(this.loadPact(pactUrl)).build();
            pactCallback.accept(brokeredPact);
        }
        catch (Exception ex) {
            log.warn("Failed to load pact from URL {}", (Object)pactUrl, (Object)ex);
        }
    }

    private List<String> getLatestPactUrls() {
        HalClient halClient = new HalClient(this.pactBrokerUrl, new PactBrokerClientConfig());
        ArrayList<String> pactUrls = new ArrayList<String>();
        halClient.navigate(LATEST_PACTS_LINK_NAME).forAll(PACTS_LINK_NAME, map -> {
            String pactUrl = (String)map.get(HREF_ATTRIBUTE_NAME);
            pactUrls.add(pactUrl);
        });
        return pactUrls;
    }

    private Pact loadPact(String url) {
        BrokerUrlSource urlSource = new BrokerUrlSource(url, this.pactBrokerUrl);
        JsonValue.Object pactJson = this.downloadPact(urlSource);
        return this.parsePact(urlSource, pactJson);
    }

    private JsonValue.Object downloadPact(BrokerUrlSource urlSource) {
        Pair jsonElementPactSourcePair = PactReaderKt.loadPactFromUrl((UrlPactSource)urlSource, Map.of(), (CloseableHttpClient)this.httpClient);
        return (JsonValue.Object)jsonElementPactSourcePair.getFirst();
    }

    private Pact parsePact(BrokerUrlSource urlSource, JsonValue.Object pactJson) {
        return DefaultPactReader.loadV3Pact((PactSource)urlSource, (JsonValue.Object)pactJson);
    }

    @Generated
    public PactBrokerClient(CloseableHttpClient httpClient, String pactBrokerUrl) {
        this.httpClient = httpClient;
        this.pactBrokerUrl = pactBrokerUrl;
    }
}

