/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.importer.pactbroker;

import au.com.dius.pact.core.model.Interaction;
import au.com.dius.pact.core.model.Pact;
import au.com.dius.pact.core.model.RequestResponseInteraction;
import ch.admin.bit.jeap.archrepo.importer.pactbroker.RequestResponseInteractionImporter;
import ch.admin.bit.jeap.archrepo.importer.pactbroker.client.BrokeredPact;
import ch.admin.bit.jeap.archrepo.importer.pactbroker.client.PactBrokerClient;
import ch.admin.bit.jeap.archrepo.importers.ArchRepoImporter;
import ch.admin.bit.jeap.archrepo.metamodel.ArchitectureModel;
import ch.admin.bit.jeap.archrepo.metamodel.ArchitectureModelHelper;
import ch.admin.bit.jeap.archrepo.metamodel.Importer;
import ch.admin.bit.jeap.archrepo.metamodel.system.BackendService;
import ch.admin.bit.jeap.archrepo.metamodel.system.SelfContainedSystem;
import ch.admin.bit.jeap.archrepo.metamodel.system.SystemComponent;
import java.util.Optional;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
class PactBrokerImporter
implements ArchRepoImporter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PactBrokerImporter.class);
    private static final Pattern NAME_PARTS = Pattern.compile("(?<departement>.+?)-(?<system>.+?)-(?<component>.+)");
    private final PactBrokerClient pactBrokerClient;

    public void importIntoModel(ArchitectureModel model, String environment) {
        model.removeAllByImporter(Importer.PACT_BROKER);
        this.pactBrokerClient.withAllPacts(pact -> this.importRelationsFromPact(model, (BrokeredPact)pact));
    }

    private void importRelationsFromPact(ArchitectureModel model, BrokeredPact brokeredPact) {
        Pact pact = brokeredPact.getPact();
        Optional consumerComponent = ArchitectureModelHelper.findComponentByNameWithSystemPrefix((ArchitectureModel)model, (String)pact.getConsumer().getName(), (Pattern)NAME_PARTS);
        Optional providerComponent = ArchitectureModelHelper.findComponentByNameWithSystemPrefix((ArchitectureModel)model, (String)PactBrokerImporter.removeSuffix(pact.getProvider().getName()), (Pattern)NAME_PARTS);
        if (consumerComponent.isEmpty()) {
            log.warn("Consumer {} not found", (Object)pact.getConsumer().getName());
            return;
        }
        if (providerComponent.isEmpty()) {
            log.warn("Provider {} not found", (Object)pact.getProvider().getName());
            return;
        }
        if (!(providerComponent.get() instanceof BackendService) && !(providerComponent.get() instanceof SelfContainedSystem)) {
            log.warn("Provider {} found, but is not a component type that can provide REST APIs", (Object)pact.getProvider().getName());
            return;
        }
        String pactUrl = brokeredPact.getPactUrl();
        RequestResponseInteractionImporter requestResponseImporter = new RequestResponseInteractionImporter((SystemComponent)consumerComponent.get(), (SystemComponent)providerComponent.get(), pactUrl);
        pact.getInteractions().forEach(interaction -> this.importInteraction((Interaction)interaction, requestResponseImporter));
    }

    private void importInteraction(Interaction interaction, RequestResponseInteractionImporter requestResponseImporter) {
        if (interaction instanceof RequestResponseInteraction) {
            RequestResponseInteraction responseInteraction = (RequestResponseInteraction)interaction;
            requestResponseImporter.importInteraction(responseInteraction);
        } else {
            log.warn("Unsupported interaction type {}", (Object)interaction.getClass().getName());
        }
    }

    private static String removeSuffix(String input) {
        int lastIndex = input.lastIndexOf("_");
        if (lastIndex != -1) {
            return input.substring(0, lastIndex);
        }
        return input;
    }

    @Generated
    public PactBrokerImporter(PactBrokerClient pactBrokerClient) {
        this.pactBrokerClient = pactBrokerClient;
    }
}

