/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.importer.pactbroker;

import au.com.dius.pact.core.model.Request;
import au.com.dius.pact.core.model.RequestResponseInteraction;
import ch.admin.bit.jeap.archrepo.importers.RestApiResolver;
import ch.admin.bit.jeap.archrepo.importers.UrlHelper;
import ch.admin.bit.jeap.archrepo.metamodel.Importer;
import ch.admin.bit.jeap.archrepo.metamodel.relation.AbstractRelation;
import ch.admin.bit.jeap.archrepo.metamodel.relation.RestApiRelation;
import ch.admin.bit.jeap.archrepo.metamodel.restapi.RestApi;
import ch.admin.bit.jeap.archrepo.metamodel.system.SystemComponent;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RequestResponseInteractionImporter
implements RestApiResolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RequestResponseInteractionImporter.class);
    private static final Pattern PATH_WITH_CONTEXT_PREFIX_PATTERN = Pattern.compile("(?<context>/.*?)(?<path>/(?<segregatedapi>.+?-)?api/.*)");
    private final SystemComponent consumer;
    private final SystemComponent provider;
    private final String pactUrl;

    public void importInteraction(RequestResponseInteraction interaction) {
        RestApiRelation relation;
        Optional<RestApiRelation> relationOptional;
        Request request = interaction.getRequest();
        String pathWithoutContextPrefix = this.pathWithoutContextPrefix(request.getPath());
        Optional<RestApi> optionalRestApi = this.retrieveExistingRestApi(request.getMethod(), pathWithoutContextPrefix);
        if (optionalRestApi.isEmpty()) {
            optionalRestApi = this.retrieveExistingRestApi(request.getMethod(), request.getPath());
        }
        if (optionalRestApi.isEmpty()) {
            RestApi restApi = RestApi.builder().provider(this.provider).method(request.getMethod()).path(pathWithoutContextPrefix).importer(Importer.PACT_BROKER).build();
            this.provider.getParent().addRestApi(restApi);
            log.info("Create new rest api {}", (Object)restApi);
            optionalRestApi = Optional.of(restApi);
        }
        if ((relationOptional = this.retrieveExistingRelation(relation = RestApiRelation.builder().consumerName(this.consumer.getName()).providerName(this.provider.getName()).pactUrl(this.pactUrl).restApi(optionalRestApi.get()).importer(Importer.PACT_BROKER).lastSeen(ZonedDateTime.now()).build())).isEmpty()) {
            this.provider.getParent().addRelation((AbstractRelation)relation);
            log.info("Added relation for pact {}", (Object)this.pactUrl);
        } else {
            RestApiRelation existingRelation = relationOptional.get();
            if (!existingRelation.getImporters().contains(Importer.PACT_BROKER) || !this.pactUrl.equals(existingRelation.getPactUrl())) {
                existingRelation.addImporter(Importer.PACT_BROKER);
                existingRelation.setPactUrl(this.pactUrl);
                existingRelation.setLastSeen(ZonedDateTime.now());
                log.info("Updating existing relation with path '{}' with pact with path '{}'", (Object)existingRelation.getRestApi().getPath(), (Object)relation.getRestApi().getPath());
                log.info("Updated pactUrl '{}' to existing relation '{}' and updated last-seen", (Object)this.pactUrl, (Object)existingRelation);
            }
        }
    }

    private String pathWithoutContextPrefix(String path) {
        Matcher matcher = PATH_WITH_CONTEXT_PREFIX_PATTERN.matcher(path);
        if (matcher.matches()) {
            return matcher.group("path");
        }
        return path;
    }

    private Optional<RestApiRelation> retrieveExistingRelation(RestApiRelation relation) {
        return this.provider.getParent().getRelations().stream().filter(RestApiRelation.class::isInstance).map(RestApiRelation.class::cast).filter(r -> r.getConsumerName().equals(relation.getConsumerName()) && r.getProviderName().equals(relation.getProviderName()) && r.getRestApi().getId().equals(relation.getRestApi().getId())).findFirst();
    }

    private Optional<RestApi> retrieveExistingRestApi(String httpMethod, String path) {
        Optional optionalRestApi = this.getRestApi(this.provider, httpMethod, path);
        if (optionalRestApi.isPresent()) {
            if (!((RestApi)optionalRestApi.get()).getImporters().contains(Importer.PACT_BROKER)) {
                ((RestApi)optionalRestApi.get()).addImporter(Importer.PACT_BROKER);
            }
            log.info("Found available rest api {}", optionalRestApi.get());
            return optionalRestApi;
        }
        return Optional.empty();
    }

    public Optional<RestApi> retrieveExistingRestApiWithMatchingPattern(SystemComponent provider, String method, String path) {
        for (RestApi currentRestApi : provider.getParent().getRestApis()) {
            if (!UrlHelper.restApisProviderMethodAreMatching((RestApi)currentRestApi, (SystemComponent)provider, (String)method)) continue;
            String currentRestApiPathWithoutContextPrefix = this.pathWithoutContextPrefix(currentRestApi.getPath());
            String pathRegex = UrlHelper.convertPathToRegex((String)currentRestApiPathWithoutContextPrefix);
            Matcher matcher = Pattern.compile(pathRegex, 2).matcher(UrlHelper.removeTrailingSlash((String)path));
            if (matcher.matches()) {
                log.debug("Found matching rest api with regex from jeap ('{}') with the pact relation '{}'", (Object)currentRestApi.getPath(), (Object)path);
                return Optional.of(currentRestApi);
            }
            matcher = Pattern.compile(UrlHelper.convertPathToRegex((String)path), 2).matcher(UrlHelper.removeTrailingSlash((String)currentRestApiPathWithoutContextPrefix));
            if (!matcher.matches()) continue;
            log.debug("Found matching rest api with regex from jeap ('{}') with the pact relation '{}'", (Object)currentRestApi.getPath(), (Object)path);
            return Optional.of(currentRestApi);
        }
        log.debug("No rest api present for provider {} on {} : {}", new Object[]{provider, method, path});
        return Optional.empty();
    }

    @Generated
    public RequestResponseInteractionImporter(SystemComponent consumer, SystemComponent provider, String pactUrl) {
        this.consumer = consumer;
        this.provider = provider;
        this.pactUrl = pactUrl;
    }
}

