/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.importer.prometheus;

import ch.admin.bit.jeap.archrepo.importer.prometheus.client.JeapRelation;
import ch.admin.bit.jeap.archrepo.importers.RestApiResolver;
import ch.admin.bit.jeap.archrepo.importers.UrlHelper;
import ch.admin.bit.jeap.archrepo.metamodel.Importer;
import ch.admin.bit.jeap.archrepo.metamodel.relation.AbstractRelation;
import ch.admin.bit.jeap.archrepo.metamodel.relation.RestApiRelation;
import ch.admin.bit.jeap.archrepo.metamodel.restapi.RestApi;
import ch.admin.bit.jeap.archrepo.metamodel.system.SystemComponent;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JeapRelationImporter
implements RestApiResolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JeapRelationImporter.class);
    private final SystemComponent consumer;
    private final SystemComponent provider;

    public void importRelation(JeapRelation jeapRelation) {
        RestApiRelation relation = RestApiRelation.builder().consumerName(this.consumer.getName()).providerName(this.provider.getName()).restApi(this.getOrCreateRestApi(jeapRelation.getMethod(), jeapRelation.getDatapoint())).importer(Importer.GRAFANA).lastSeen(ZonedDateTime.now()).build();
        Optional<RestApiRelation> relationOptional = this.provider.getParent().getRelations().stream().filter(RestApiRelation.class::isInstance).map(RestApiRelation.class::cast).filter(r -> r.getConsumerName().equals(relation.getConsumerName()) && r.getProviderName().equals(relation.getProviderName()) && r.getRestApi().getId().equals(relation.getRestApi().getId())).findFirst();
        if (relationOptional.isEmpty()) {
            this.provider.getParent().addRelation((AbstractRelation)relation);
            log.info("Added to parent '{}' new relation '{}'.", (Object)this.provider.getParent().getName(), (Object)jeapRelation);
        } else {
            RestApiRelation existingRelation = relationOptional.get();
            if (!existingRelation.getImporters().contains(Importer.GRAFANA)) {
                existingRelation.addImporter(Importer.GRAFANA);
                log.info("Added Importer.GRAFANA to existing relation '{}'.", (Object)existingRelation);
            }
            existingRelation.setLastSeen(ZonedDateTime.now());
            log.info("Updated last-seen to existing relation '{}'.", (Object)existingRelation);
        }
    }

    private RestApi getOrCreateRestApi(String httpMethod, String path) {
        RestApi restApi;
        Optional optionalRestApi = this.getRestApi(this.provider, httpMethod, path);
        if (optionalRestApi.isPresent()) {
            restApi = (RestApi)optionalRestApi.get();
            if (!restApi.getImporters().contains(Importer.GRAFANA)) {
                restApi.updatePath(path);
                restApi.addImporter(Importer.GRAFANA);
            }
            log.info("Retrieved available rest api {}", (Object)restApi);
        } else {
            restApi = RestApi.builder().provider(this.provider).method(httpMethod).path(path).importer(Importer.GRAFANA).build();
            this.provider.getParent().addRestApi(restApi);
            log.info("Create new rest api {}", (Object)restApi);
        }
        return restApi;
    }

    public Optional<RestApi> retrieveExistingRestApiWithMatchingPattern(SystemComponent provider, String method, String path) {
        for (RestApi currentRestApi : provider.getParent().getRestApis()) {
            if (!UrlHelper.restApisProviderMethodAreMatching((RestApi)currentRestApi, (SystemComponent)provider, (String)method)) continue;
            String pathRegex = UrlHelper.convertPathToRegex((String)currentRestApi.getPath());
            Matcher matcher = Pattern.compile(pathRegex, 2).matcher(UrlHelper.removeTrailingSlash((String)path));
            if (matcher.matches()) {
                log.debug("Found matching rest api with regex from jeap ('{}') with the pact relation '{}'", (Object)currentRestApi.getPath(), (Object)path);
                return Optional.of(currentRestApi);
            }
            matcher = Pattern.compile(UrlHelper.convertPathToRegex((String)path), 2).matcher(UrlHelper.removeTrailingSlash((String)currentRestApi.getPath()));
            if (!matcher.matches() || UrlHelper.hasPathVariable((String)path) && !UrlHelper.hasPathVariable((String)currentRestApi.getPath())) continue;
            log.debug("Found matching rest api with regex from jeap ('{}') with the pact relation '{}'", (Object)currentRestApi.getPath(), (Object)path);
            return Optional.of(currentRestApi);
        }
        log.debug("No rest api present for provider {} on {} : {}", new Object[]{provider, method, path});
        return Optional.empty();
    }

    @Generated
    public JeapRelationImporter(SystemComponent consumer, SystemComponent provider) {
        this.consumer = consumer;
        this.provider = provider;
    }
}

