/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.importer.prometheus.client;

import ch.admin.bit.jeap.archrepo.importer.prometheus.client.prometheus.dto.PrometheusQueryResponseResult;
import java.util.Map;
import lombok.Generated;

public final class JeapRelation
implements Comparable<JeapRelation> {
    private final String provider;
    private final String consumer;
    private final String method;
    private final String technology;
    private final String datapoint;

    public static JeapRelation fromPrometheusQueryResponseResult(PrometheusQueryResponseResult result) {
        Map<String, String> metric = result.getMetric();
        String datapoint = JeapRelation.datapointWithoutTrailingSlash(metric);
        return new JeapRelation(metric.get("producer"), metric.get("consumer"), metric.get("method"), metric.get("technology"), datapoint);
    }

    private static String datapointWithoutTrailingSlash(Map<String, String> metric) {
        String datapoint = metric.get("datapoint");
        if (datapoint == null || !datapoint.endsWith("/") || datapoint.length() == 1) {
            return datapoint;
        }
        return datapoint.substring(0, datapoint.length() - 1);
    }

    @Override
    public int compareTo(JeapRelation jeapRelation) {
        return this.compare(this.provider, jeapRelation.provider) * 10000 + this.compare(this.consumer, jeapRelation.consumer) * 1000 + this.compare(this.method, jeapRelation.method) * 100 + this.compare(this.technology, jeapRelation.technology) * 10 + this.compare(this.datapoint, jeapRelation.datapoint);
    }

    private int compare(String a, String b) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return 1;
        }
        if (b == null) {
            return -1;
        }
        return a.compareTo(b);
    }

    @Generated
    public JeapRelation(String provider, String consumer, String method, String technology, String datapoint) {
        this.provider = provider;
        this.consumer = consumer;
        this.method = method;
        this.technology = technology;
        this.datapoint = datapoint;
    }

    @Generated
    public String getProvider() {
        return this.provider;
    }

    @Generated
    public String getConsumer() {
        return this.consumer;
    }

    @Generated
    public String getMethod() {
        return this.method;
    }

    @Generated
    public String getTechnology() {
        return this.technology;
    }

    @Generated
    public String getDatapoint() {
        return this.datapoint;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JeapRelation)) {
            return false;
        }
        JeapRelation other = (JeapRelation)o;
        String this$provider = this.getProvider();
        String other$provider = other.getProvider();
        if (this$provider == null ? other$provider != null : !this$provider.equals(other$provider)) {
            return false;
        }
        String this$consumer = this.getConsumer();
        String other$consumer = other.getConsumer();
        if (this$consumer == null ? other$consumer != null : !this$consumer.equals(other$consumer)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$technology = this.getTechnology();
        String other$technology = other.getTechnology();
        if (this$technology == null ? other$technology != null : !this$technology.equals(other$technology)) {
            return false;
        }
        String this$datapoint = this.getDatapoint();
        String other$datapoint = other.getDatapoint();
        return !(this$datapoint == null ? other$datapoint != null : !this$datapoint.equals(other$datapoint));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $provider = this.getProvider();
        result = result * 59 + ($provider == null ? 43 : $provider.hashCode());
        String $consumer = this.getConsumer();
        result = result * 59 + ($consumer == null ? 43 : $consumer.hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $technology = this.getTechnology();
        result = result * 59 + ($technology == null ? 43 : $technology.hashCode());
        String $datapoint = this.getDatapoint();
        result = result * 59 + ($datapoint == null ? 43 : $datapoint.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "JeapRelation(provider=" + this.getProvider() + ", consumer=" + this.getConsumer() + ", method=" + this.getMethod() + ", technology=" + this.getTechnology() + ", datapoint=" + this.getDatapoint() + ")";
    }
}

