/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.metamodel.message;

import ch.admin.bit.jeap.archrepo.metamodel.message.MessageContract;
import ch.admin.bit.jeap.archrepo.metamodel.message.MessageType;
import com.google.common.collect.Streams;
import jakarta.persistence.CascadeType;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

@Entity
@DiscriminatorValue(value="EVENT")
public class Event
extends MessageType {
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="messagePublisher")
    private List<MessageContract> publisherContracts;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="messageConsumer")
    private List<MessageContract> consumerContracts;

    public List<MessageContract> getPublisherContracts() {
        return this.publisherContracts == null ? Collections.emptyList() : this.publisherContracts;
    }

    public List<MessageContract> getConsumerContracts() {
        return this.consumerContracts == null ? Collections.emptyList() : this.consumerContracts;
    }

    public void addConsumerContract(MessageContract messageContract) {
        if (this.consumerContracts == null) {
            this.consumerContracts = new ArrayList<MessageContract>();
        }
        messageContract.setMessageConsumer(this);
        this.consumerContracts.add(messageContract);
    }

    public void addPublisherContract(MessageContract messageContract) {
        if (this.publisherContracts == null) {
            this.publisherContracts = new ArrayList<MessageContract>();
        }
        messageContract.setMessagePublisher(this);
        this.publisherContracts.add(messageContract);
    }

    @Override
    public Set<String> getComponentNamesWithContract() {
        Stream publisherStream = Optional.ofNullable(this.publisherContracts).map(Collection::stream).orElse(Stream.empty());
        Stream consumerStream = Optional.ofNullable(this.consumerContracts).map(Collection::stream).orElse(Stream.empty());
        return Streams.concat((Stream[])new Stream[]{publisherStream, consumerStream}).map(MessageContract::getComponentName).collect(Collectors.toSet());
    }

    @Generated
    protected Event(EventBuilder<?, ?> b) {
        super(b);
        this.publisherContracts = b.publisherContracts;
        this.consumerContracts = b.consumerContracts;
    }

    @Generated
    public static EventBuilder<?, ?> builder() {
        return new EventBuilderImpl();
    }

    @Generated
    public EventBuilder<?, ?> toBuilder() {
        return new EventBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Event)) {
            return false;
        }
        Event other = (Event)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<MessageContract> this$publisherContracts = this.getPublisherContracts();
        List<MessageContract> other$publisherContracts = other.getPublisherContracts();
        if (this$publisherContracts == null ? other$publisherContracts != null : !((Object)this$publisherContracts).equals(other$publisherContracts)) {
            return false;
        }
        List<MessageContract> this$consumerContracts = this.getConsumerContracts();
        List<MessageContract> other$consumerContracts = other.getConsumerContracts();
        return !(this$consumerContracts == null ? other$consumerContracts != null : !((Object)this$consumerContracts).equals(other$consumerContracts));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Event;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<MessageContract> $publisherContracts = this.getPublisherContracts();
        result = result * 59 + ($publisherContracts == null ? 43 : ((Object)$publisherContracts).hashCode());
        List<MessageContract> $consumerContracts = this.getConsumerContracts();
        result = result * 59 + ($consumerContracts == null ? 43 : ((Object)$consumerContracts).hashCode());
        return result;
    }

    @Generated
    public Event() {
    }

    @Generated
    public static abstract class EventBuilder<C extends Event, B extends EventBuilder<C, B>>
    extends MessageType.MessageTypeBuilder<C, B> {
        @Generated
        private List<MessageContract> publisherContracts;
        @Generated
        private List<MessageContract> consumerContracts;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            EventBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Event instance, EventBuilder<?, ?> b) {
            b.publisherContracts(instance.publisherContracts);
            b.consumerContracts(instance.consumerContracts);
        }

        @Generated
        public B publisherContracts(List<MessageContract> publisherContracts) {
            this.publisherContracts = publisherContracts;
            return (B)this.self();
        }

        @Generated
        public B consumerContracts(List<MessageContract> consumerContracts) {
            this.consumerContracts = consumerContracts;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Event.EventBuilder(super=" + super.toString() + ", publisherContracts=" + String.valueOf(this.publisherContracts) + ", consumerContracts=" + String.valueOf(this.consumerContracts) + ")";
        }
    }

    @Generated
    private static final class EventBuilderImpl
    extends EventBuilder<Event, EventBuilderImpl> {
        @Generated
        private EventBuilderImpl() {
        }

        @Override
        @Generated
        protected EventBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Event build() {
            return new Event(this);
        }
    }
}

