/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.metamodel.restapi;

import ch.admin.bit.jeap.archrepo.metamodel.Importer;
import ch.admin.bit.jeap.archrepo.metamodel.MultipleImportable;
import ch.admin.bit.jeap.archrepo.metamodel.MutableDomainEntity;
import ch.admin.bit.jeap.archrepo.metamodel.System;
import ch.admin.bit.jeap.archrepo.metamodel.system.SystemComponent;
import jakarta.persistence.CascadeType;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.validation.constraints.NotNull;
import java.util.Collections;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;

@Entity
public class RestApi
extends MutableDomainEntity
implements MultipleImportable {
    @Id
    @NotNull
    private UUID id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="system_id")
    private System definingSystem;
    @NotNull
    @ManyToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE}, fetch=FetchType.EAGER)
    private SystemComponent provider;
    @NotNull
    private String method;
    @NotNull
    private String path;
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="rest_api_importers")
    @Enumerated(value=EnumType.STRING)
    private SortedSet<Importer> importers = new TreeSet<Importer>();

    protected RestApi() {
    }

    public RestApi(@NonNull SystemComponent provider, @NonNull String method, @NonNull String path, Importer importer) {
        if (provider == null) {
            throw new NullPointerException("provider is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        this.id = UUID.randomUUID();
        this.definingSystem = provider.getParent();
        this.provider = provider;
        this.method = method.toUpperCase();
        this.path = path;
        this.addImporter(importer);
    }

    public void updatePath(String path) {
        this.path = path;
    }

    @Override
    public void addImporter(Importer importer) {
        if (importer != null) {
            this.importers.add(importer);
        }
    }

    public void removeImporter(Importer importer) {
        if (importer != null) {
            this.importers.remove((Object)importer);
        }
    }

    @Override
    public Set<Importer> getImporters() {
        return Collections.unmodifiableSet(this.importers);
    }

    public boolean pathMatches(String path) {
        return RestApi.pathWithoutVariableNames(this.path).equals(RestApi.pathWithoutVariableNames(path));
    }

    private static String pathWithoutVariableNames(String path) {
        String replaced = path.replaceAll("\\{.*?}", "{}");
        if (!replaced.endsWith("/") || replaced.length() == 1) {
            return replaced;
        }
        return replaced.substring(0, replaced.length() - 1);
    }

    @Generated
    public static RestApiBuilder builder() {
        return new RestApiBuilder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RestApi)) {
            return false;
        }
        RestApi other = (RestApi)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        SystemComponent this$provider = this.getProvider();
        SystemComponent other$provider = other.getProvider();
        if (this$provider == null ? other$provider != null : !this$provider.equals(other$provider)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        return !(this$path == null ? other$path != null : !this$path.equals(other$path));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RestApi;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        SystemComponent $provider = this.getProvider();
        result = result * 59 + ($provider == null ? 43 : $provider.hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RestApi(id=" + String.valueOf(this.getId()) + ", method=" + this.getMethod() + ", path=" + this.getPath() + ", importers=" + String.valueOf(this.getImporters()) + ")";
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public System getDefiningSystem() {
        return this.definingSystem;
    }

    @Generated
    public SystemComponent getProvider() {
        return this.provider;
    }

    @Generated
    public String getMethod() {
        return this.method;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public static class RestApiBuilder {
        @Generated
        private SystemComponent provider;
        @Generated
        private String method;
        @Generated
        private String path;
        @Generated
        private Importer importer;

        @Generated
        RestApiBuilder() {
        }

        @Generated
        public RestApiBuilder provider(@NonNull SystemComponent provider) {
            if (provider == null) {
                throw new NullPointerException("provider is marked non-null but is null");
            }
            this.provider = provider;
            return this;
        }

        @Generated
        public RestApiBuilder method(@NonNull String method) {
            if (method == null) {
                throw new NullPointerException("method is marked non-null but is null");
            }
            this.method = method;
            return this;
        }

        @Generated
        public RestApiBuilder path(@NonNull String path) {
            if (path == null) {
                throw new NullPointerException("path is marked non-null but is null");
            }
            this.path = path;
            return this;
        }

        @Generated
        public RestApiBuilder importer(Importer importer) {
            this.importer = importer;
            return this;
        }

        @Generated
        public RestApi build() {
            return new RestApi(this.provider, this.method, this.path, this.importer);
        }

        @Generated
        public String toString() {
            return "RestApi.RestApiBuilder(provider=" + String.valueOf(this.provider) + ", method=" + this.method + ", path=" + this.path + ", importer=" + String.valueOf((Object)this.importer) + ")";
        }
    }
}

