/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.metamodel.relation;

import ch.admin.bit.jeap.archrepo.metamodel.Importer;
import ch.admin.bit.jeap.archrepo.metamodel.System;
import ch.admin.bit.jeap.archrepo.metamodel.relation.AbstractRelation;
import ch.admin.bit.jeap.archrepo.metamodel.relation.RelationType;
import ch.admin.bit.jeap.archrepo.metamodel.restapi.RestApi;
import jakarta.persistence.CascadeType;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ManyToOne;
import java.time.ZonedDateTime;
import lombok.Generated;

@Entity
@DiscriminatorValue(value="REST_API")
public class RestApiRelation
extends AbstractRelation {
    private String pactUrl;
    @ManyToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE}, fetch=FetchType.EAGER)
    private RestApi restApi;
    private ZonedDateTime lastSeen;

    @Override
    public String getLabel() {
        return this.restApi.getMethod() + " " + this.restApi.getPath();
    }

    @Override
    public boolean isLabelLinkable() {
        return false;
    }

    @Override
    public RelationType getType() {
        return RelationType.REST_API_RELATION;
    }

    @Override
    public String getProviderName() {
        return this.restApi == null ? null : this.restApi.getProvider().getName();
    }

    public RestApiRelation(System definingSystem, String providerName, String consumerName, Importer importer, String pactUrl, RestApi restApi, ZonedDateTime lastSeen) {
        super(definingSystem, providerName, consumerName, importer);
        this.pactUrl = pactUrl;
        this.restApi = restApi;
        this.lastSeen = lastSeen;
    }

    @Generated
    public static RestApiRelationBuilder builder() {
        return new RestApiRelationBuilder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RestApiRelation)) {
            return false;
        }
        RestApiRelation other = (RestApiRelation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RestApi this$restApi = this.getRestApi();
        RestApi other$restApi = other.getRestApi();
        return !(this$restApi == null ? other$restApi != null : !((Object)this$restApi).equals(other$restApi));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RestApiRelation;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        RestApi $restApi = this.getRestApi();
        result = result * 59 + ($restApi == null ? 43 : ((Object)$restApi).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RestApiRelation(super=" + super.toString() + ", pactUrl=" + this.getPactUrl() + ", restApi=" + String.valueOf(this.getRestApi()) + ", lastSeen=" + String.valueOf(this.getLastSeen()) + ")";
    }

    @Generated
    public RestApiRelation() {
    }

    @Generated
    public String getPactUrl() {
        return this.pactUrl;
    }

    @Generated
    public RestApi getRestApi() {
        return this.restApi;
    }

    @Generated
    public ZonedDateTime getLastSeen() {
        return this.lastSeen;
    }

    @Generated
    public void setPactUrl(String pactUrl) {
        this.pactUrl = pactUrl;
    }

    @Generated
    public void setLastSeen(ZonedDateTime lastSeen) {
        this.lastSeen = lastSeen;
    }

    @Generated
    public static class RestApiRelationBuilder {
        @Generated
        private System definingSystem;
        @Generated
        private String providerName;
        @Generated
        private String consumerName;
        @Generated
        private Importer importer;
        @Generated
        private String pactUrl;
        @Generated
        private RestApi restApi;
        @Generated
        private ZonedDateTime lastSeen;

        @Generated
        RestApiRelationBuilder() {
        }

        @Generated
        public RestApiRelationBuilder definingSystem(System definingSystem) {
            this.definingSystem = definingSystem;
            return this;
        }

        @Generated
        public RestApiRelationBuilder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        @Generated
        public RestApiRelationBuilder consumerName(String consumerName) {
            this.consumerName = consumerName;
            return this;
        }

        @Generated
        public RestApiRelationBuilder importer(Importer importer) {
            this.importer = importer;
            return this;
        }

        @Generated
        public RestApiRelationBuilder pactUrl(String pactUrl) {
            this.pactUrl = pactUrl;
            return this;
        }

        @Generated
        public RestApiRelationBuilder restApi(RestApi restApi) {
            this.restApi = restApi;
            return this;
        }

        @Generated
        public RestApiRelationBuilder lastSeen(ZonedDateTime lastSeen) {
            this.lastSeen = lastSeen;
            return this;
        }

        @Generated
        public RestApiRelation build() {
            return new RestApiRelation(this.definingSystem, this.providerName, this.consumerName, this.importer, this.pactUrl, this.restApi, this.lastSeen);
        }

        @Generated
        public String toString() {
            return "RestApiRelation.RestApiRelationBuilder(definingSystem=" + String.valueOf(this.definingSystem) + ", providerName=" + this.providerName + ", consumerName=" + this.consumerName + ", importer=" + String.valueOf((Object)this.importer) + ", pactUrl=" + this.pactUrl + ", restApi=" + String.valueOf(this.restApi) + ", lastSeen=" + String.valueOf(this.lastSeen) + ")";
        }
    }
}

