/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.metamodel;

import ch.admin.bit.jeap.archrepo.metamodel.ArchitectureModelHelper;
import ch.admin.bit.jeap.archrepo.metamodel.Importer;
import ch.admin.bit.jeap.archrepo.metamodel.Relation;
import ch.admin.bit.jeap.archrepo.metamodel.System;
import ch.admin.bit.jeap.archrepo.metamodel.Team;
import ch.admin.bit.jeap.archrepo.metamodel.message.MessageType;
import ch.admin.bit.jeap.archrepo.metamodel.relation.RelationType;
import ch.admin.bit.jeap.archrepo.metamodel.relation.RestApiRelation;
import ch.admin.bit.jeap.archrepo.metamodel.restapi.OpenApiSpec;
import ch.admin.bit.jeap.archrepo.metamodel.restapi.RestApi;
import ch.admin.bit.jeap.archrepo.metamodel.system.SystemComponent;
import ch.admin.bit.jeap.archrepo.metamodel.system.SystemComponentType;
import com.google.common.collect.Streams;
import com.google.common.eventbus.EventBus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public class ArchitectureModel {
    private final List<Team> teams;
    private final List<System> systems;
    private final EventBus domainEventBus;
    private final String openApiBaseUrl;

    private ArchitectureModel(List<Team> teams, List<System> systems, String openApiBaseUrl) {
        this.teams = teams;
        this.systems = systems;
        this.openApiBaseUrl = openApiBaseUrl;
        this.domainEventBus = new EventBus();
        this.systems.forEach(domain -> domain.setDomainEventBus(this.domainEventBus));
    }

    public List<System> getSystems() {
        return Collections.unmodifiableList(this.systems);
    }

    private static boolean systemNameOrAliasMatches(String systemName, System system) {
        return systemName.equalsIgnoreCase(system.getName()) || system.getAliases() != null && system.getAliases().stream().anyMatch(alias -> alias.equalsIgnoreCase(systemName));
    }

    public Optional<System> findSystem(String systemName) {
        return this.systems.stream().filter(system -> ArchitectureModel.systemNameOrAliasMatches(systemName, system)).findFirst();
    }

    public <T extends Relation> List<T> getAllRelationsByType(Class<T> relationClass) {
        return this.systems.stream().flatMap(system -> system.getRelations().stream().filter(relation -> relationClass.isAssignableFrom(relation.getClass()))).map(rel -> rel).toList();
    }

    public List<RestApi> getAllRestApis() {
        return this.systems.stream().flatMap(system -> system.getRestApis().stream()).toList();
    }

    public void cleanup() {
        ArchitectureModelHelper.cleanup(this);
    }

    public List<Relation> getAllActiveRelationsByType(RelationType relationType) {
        return this.systems.stream().flatMap(system -> system.getActiveRelations().stream().filter(relation -> relation.getType() == relationType)).toList();
    }

    public List<Relation> getAllRelations() {
        return this.systems.stream().flatMap(system -> system.getRelations().stream()).toList();
    }

    public List<RestApiRelation> getRestApiRelationsWithoutPact() {
        return this.systems.stream().flatMap(system -> system.getActiveRelations().stream()).filter(RestApiRelation.class::isInstance).map(RestApiRelation.class::cast).filter(relation -> relation.getPactUrl() == null).toList();
    }

    public Optional<SystemComponent> findSystemComponent(String componentName) {
        return this.systems.stream().flatMap(system -> system.findSystemComponent(componentName).stream()).findFirst();
    }

    public void removeAllByImporter(Importer importer) {
        this.getAllSystems().forEach(s -> s.removeAllByImporter(importer));
    }

    public List<SystemComponent> getAllSystemComponentsByImporter(Importer importer) {
        return this.getAllSystems().flatMap(s -> s.getSystemComponents().stream()).filter(s -> s.getImporter() == importer).toList();
    }

    public List<MessageType> getAllMessageTypes() {
        return this.getAllSystems().flatMap(s -> Streams.concat((Stream[])new Stream[]{s.getCommands().stream(), s.getEvents().stream()})).toList();
    }

    public Optional<String> getRestApiForSystemComponent(SystemComponent systemComponent) {
        Optional<OpenApiSpec> openApiSpec;
        if ((SystemComponentType.BACKEND_SERVICE.equals((Object)systemComponent.getType()) || SystemComponentType.SELF_CONTAINED_SYSTEM.equals((Object)systemComponent.getType())) && (openApiSpec = systemComponent.getParent().getOpenApiSpecs().stream().filter(o -> o.getProvider().equals(systemComponent)).findFirst()).isPresent()) {
            return Optional.of(this.createOpenApiSpecSwaggerUrl(systemComponent));
        }
        return Optional.empty();
    }

    public List<String> getSystemComponentsWithoutOpenApiSpec() {
        return this.getAllSystemComponents().filter(sc -> SystemComponentType.BACKEND_SERVICE.equals((Object)sc.getType()) || SystemComponentType.SELF_CONTAINED_SYSTEM.equals((Object)sc.getType())).filter(sc -> sc.getParent().getOpenApiSpecs().stream().filter(o -> o.getProvider().equals(sc)).findFirst().isEmpty()).map(SystemComponent::getName).toList();
    }

    private String createOpenApiSpecSwaggerUrl(SystemComponent systemComponent) {
        return (this.openApiBaseUrl + systemComponent.getParent().getName() + "/" + systemComponent.getName()).toLowerCase();
    }

    public void remove(SystemComponent component) {
        this.getAllSystems().forEach(system -> system.removeSystemComponent(component));
    }

    public Optional<MessageType> findMessageType(String messageTypeName) {
        return this.getAllSystems().map(system -> system.findMessageType(messageTypeName)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    private Stream<System> getAllSystems() {
        return this.systems.stream();
    }

    private Stream<SystemComponent> getAllSystemComponents() {
        return this.getAllSystems().flatMap(system -> system.getSystemComponents().stream());
    }

    public Map<String, String> getAllSystemComponentNamesWithSystemName() {
        return this.getAllSystemComponents().collect(Collectors.toMap(SystemComponent::getName, component -> component.getParent().getName()));
    }

    public static ArchitectureModelBuilder builder() {
        return new ArchitectureModelBuilder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArchitectureModel)) {
            return false;
        }
        ArchitectureModel other = (ArchitectureModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Team> this$teams = this.teams;
        List<Team> other$teams = other.teams;
        if (this$teams == null ? other$teams != null : !((Object)this$teams).equals(other$teams)) {
            return false;
        }
        List<System> this$systems = this.getSystems();
        List<System> other$systems = other.getSystems();
        if (this$systems == null ? other$systems != null : !((Object)this$systems).equals(other$systems)) {
            return false;
        }
        String this$openApiBaseUrl = this.openApiBaseUrl;
        String other$openApiBaseUrl = other.openApiBaseUrl;
        return !(this$openApiBaseUrl == null ? other$openApiBaseUrl != null : !this$openApiBaseUrl.equals(other$openApiBaseUrl));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ArchitectureModel;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Team> $teams = this.teams;
        result = result * 59 + ($teams == null ? 43 : ((Object)$teams).hashCode());
        List<System> $systems = this.getSystems();
        result = result * 59 + ($systems == null ? 43 : ((Object)$systems).hashCode());
        String $openApiBaseUrl = this.openApiBaseUrl;
        result = result * 59 + ($openApiBaseUrl == null ? 43 : $openApiBaseUrl.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ArchitectureModel(teams=" + String.valueOf(this.teams) + ", systems=" + String.valueOf(this.getSystems()) + ", domainEventBus=" + String.valueOf(this.domainEventBus) + ", openApiBaseUrl=" + this.openApiBaseUrl + ")";
    }

    public static class ArchitectureModelBuilder {
        private List<Team> teams = new ArrayList<Team>();
        private List<System> systems = new ArrayList<System>();
        private String openApiBaseUrl;

        ArchitectureModelBuilder() {
        }

        public ArchitectureModelBuilder teams(List<Team> teams) {
            this.teams = teams;
            return this;
        }

        public ArchitectureModelBuilder systems(List<System> systems) {
            this.systems = systems;
            return this;
        }

        public ArchitectureModelBuilder openApiBaseUrl(String openApiBaseUrl) {
            this.openApiBaseUrl = openApiBaseUrl;
            return this;
        }

        public ArchitectureModel build() {
            return new ArchitectureModel(this.teams, this.systems, this.openApiBaseUrl);
        }
    }
}

