/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.metamodel.message;

import ch.admin.bit.jeap.archrepo.metamodel.message.MessageContract;
import ch.admin.bit.jeap.archrepo.metamodel.message.MessageType;
import com.google.common.collect.Streams;
import jakarta.persistence.CascadeType;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

@Entity
@DiscriminatorValue(value="COMMAND")
public class Command
extends MessageType {
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="messageSender")
    private List<MessageContract> senderContracts;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="messageReceiver")
    private List<MessageContract> receiverContracts;

    public List<MessageContract> getSenderContracts() {
        return this.senderContracts == null ? Collections.emptyList() : this.senderContracts;
    }

    public List<MessageContract> getReceiverContracts() {
        return this.receiverContracts == null ? Collections.emptyList() : this.receiverContracts;
    }

    public void addReceiverContract(MessageContract messageContract) {
        if (this.receiverContracts == null) {
            this.receiverContracts = new ArrayList<MessageContract>();
        }
        messageContract.setMessageReceiver(this);
        this.receiverContracts.add(messageContract);
    }

    public void addSenderContract(MessageContract messageContract) {
        if (this.senderContracts == null) {
            this.senderContracts = new ArrayList<MessageContract>();
        }
        messageContract.setMessageSender(this);
        this.senderContracts.add(messageContract);
    }

    @Override
    public Set<String> getComponentNamesWithContract() {
        Stream senderStream = Optional.ofNullable(this.senderContracts).map(Collection::stream).orElse(Stream.empty());
        Stream receiverStream = Optional.ofNullable(this.receiverContracts).map(Collection::stream).orElse(Stream.empty());
        return Streams.concat((Stream[])new Stream[]{senderStream, receiverStream}).map(MessageContract::getComponentName).collect(Collectors.toSet());
    }

    @Generated
    protected Command(CommandBuilder<?, ?> b) {
        super(b);
        this.senderContracts = b.senderContracts;
        this.receiverContracts = b.receiverContracts;
    }

    @Generated
    public static CommandBuilder<?, ?> builder() {
        return new CommandBuilderImpl();
    }

    @Generated
    public CommandBuilder<?, ?> toBuilder() {
        return new CommandBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Command)) {
            return false;
        }
        Command other = (Command)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<MessageContract> this$senderContracts = this.getSenderContracts();
        List<MessageContract> other$senderContracts = other.getSenderContracts();
        if (this$senderContracts == null ? other$senderContracts != null : !((Object)this$senderContracts).equals(other$senderContracts)) {
            return false;
        }
        List<MessageContract> this$receiverContracts = this.getReceiverContracts();
        List<MessageContract> other$receiverContracts = other.getReceiverContracts();
        return !(this$receiverContracts == null ? other$receiverContracts != null : !((Object)this$receiverContracts).equals(other$receiverContracts));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Command;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<MessageContract> $senderContracts = this.getSenderContracts();
        result = result * 59 + ($senderContracts == null ? 43 : ((Object)$senderContracts).hashCode());
        List<MessageContract> $receiverContracts = this.getReceiverContracts();
        result = result * 59 + ($receiverContracts == null ? 43 : ((Object)$receiverContracts).hashCode());
        return result;
    }

    @Generated
    public Command() {
    }

    @Generated
    public static abstract class CommandBuilder<C extends Command, B extends CommandBuilder<C, B>>
    extends MessageType.MessageTypeBuilder<C, B> {
        @Generated
        private List<MessageContract> senderContracts;
        @Generated
        private List<MessageContract> receiverContracts;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            CommandBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Command instance, CommandBuilder<?, ?> b) {
            b.senderContracts(instance.senderContracts);
            b.receiverContracts(instance.receiverContracts);
        }

        @Generated
        public B senderContracts(List<MessageContract> senderContracts) {
            this.senderContracts = senderContracts;
            return (B)this.self();
        }

        @Generated
        public B receiverContracts(List<MessageContract> receiverContracts) {
            this.receiverContracts = receiverContracts;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Command.CommandBuilder(super=" + super.toString() + ", senderContracts=" + String.valueOf(this.senderContracts) + ", receiverContracts=" + String.valueOf(this.receiverContracts) + ")";
        }
    }

    @Generated
    private static final class CommandBuilderImpl
    extends CommandBuilder<Command, CommandBuilderImpl> {
        @Generated
        private CommandBuilderImpl() {
        }

        @Override
        @Generated
        protected CommandBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Command build() {
            return new Command(this);
        }
    }
}

