/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.metamodel.reaction;

import ch.admin.bit.jeap.archrepo.metamodel.MutableDomainEntity;
import ch.admin.bit.jeap.archrepo.metamodel.system.SystemComponent;
import com.fasterxml.uuid.Generators;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.validation.constraints.NotNull;
import java.util.UUID;
import lombok.Generated;

@Entity
public class ReactionStatistics
extends MutableDomainEntity {
    @Id
    @NotNull
    private UUID id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="component_id")
    private SystemComponent component;
    private String triggerType;
    private String triggerFqn;
    private String actionType;
    private String actionFqn;
    private int count;
    private double median;
    private double percentage;

    protected ReactionStatistics() {
    }

    public ReactionStatistics(SystemComponent component, String triggerType, String triggerFqn, String actionType, String actionFqn, int count, double median, double percentage) {
        this.id = Generators.timeBasedEpochGenerator().generate();
        this.component = component;
        this.triggerType = triggerType;
        this.triggerFqn = triggerFqn;
        this.actionType = actionType;
        this.actionFqn = actionFqn;
        this.count = count;
        this.median = median;
        this.percentage = percentage;
    }

    @Generated
    public static ReactionStatisticsBuilder builder() {
        return new ReactionStatisticsBuilder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReactionStatistics)) {
            return false;
        }
        ReactionStatistics other = (ReactionStatistics)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCount() != other.getCount()) {
            return false;
        }
        if (Double.compare(this.getMedian(), other.getMedian()) != 0) {
            return false;
        }
        if (Double.compare(this.getPercentage(), other.getPercentage()) != 0) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$triggerType = this.getTriggerType();
        String other$triggerType = other.getTriggerType();
        if (this$triggerType == null ? other$triggerType != null : !this$triggerType.equals(other$triggerType)) {
            return false;
        }
        String this$triggerFqn = this.getTriggerFqn();
        String other$triggerFqn = other.getTriggerFqn();
        if (this$triggerFqn == null ? other$triggerFqn != null : !this$triggerFqn.equals(other$triggerFqn)) {
            return false;
        }
        String this$actionType = this.getActionType();
        String other$actionType = other.getActionType();
        if (this$actionType == null ? other$actionType != null : !this$actionType.equals(other$actionType)) {
            return false;
        }
        String this$actionFqn = this.getActionFqn();
        String other$actionFqn = other.getActionFqn();
        return !(this$actionFqn == null ? other$actionFqn != null : !this$actionFqn.equals(other$actionFqn));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReactionStatistics;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCount();
        long $median = Double.doubleToLongBits(this.getMedian());
        result = result * 59 + (int)($median >>> 32 ^ $median);
        long $percentage = Double.doubleToLongBits(this.getPercentage());
        result = result * 59 + (int)($percentage >>> 32 ^ $percentage);
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $triggerType = this.getTriggerType();
        result = result * 59 + ($triggerType == null ? 43 : $triggerType.hashCode());
        String $triggerFqn = this.getTriggerFqn();
        result = result * 59 + ($triggerFqn == null ? 43 : $triggerFqn.hashCode());
        String $actionType = this.getActionType();
        result = result * 59 + ($actionType == null ? 43 : $actionType.hashCode());
        String $actionFqn = this.getActionFqn();
        result = result * 59 + ($actionFqn == null ? 43 : $actionFqn.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ReactionStatistics(id=" + String.valueOf(this.getId()) + ", triggerType=" + this.getTriggerType() + ", triggerFqn=" + this.getTriggerFqn() + ", actionType=" + this.getActionType() + ", actionFqn=" + this.getActionFqn() + ", count=" + this.getCount() + ", median=" + this.getMedian() + ", percentage=" + this.getPercentage() + ")";
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public SystemComponent getComponent() {
        return this.component;
    }

    @Generated
    public String getTriggerType() {
        return this.triggerType;
    }

    @Generated
    public String getTriggerFqn() {
        return this.triggerFqn;
    }

    @Generated
    public String getActionType() {
        return this.actionType;
    }

    @Generated
    public String getActionFqn() {
        return this.actionFqn;
    }

    @Generated
    public int getCount() {
        return this.count;
    }

    @Generated
    public double getMedian() {
        return this.median;
    }

    @Generated
    public double getPercentage() {
        return this.percentage;
    }

    @Generated
    public static class ReactionStatisticsBuilder {
        @Generated
        private SystemComponent component;
        @Generated
        private String triggerType;
        @Generated
        private String triggerFqn;
        @Generated
        private String actionType;
        @Generated
        private String actionFqn;
        @Generated
        private int count;
        @Generated
        private double median;
        @Generated
        private double percentage;

        @Generated
        ReactionStatisticsBuilder() {
        }

        @Generated
        public ReactionStatisticsBuilder component(SystemComponent component) {
            this.component = component;
            return this;
        }

        @Generated
        public ReactionStatisticsBuilder triggerType(String triggerType) {
            this.triggerType = triggerType;
            return this;
        }

        @Generated
        public ReactionStatisticsBuilder triggerFqn(String triggerFqn) {
            this.triggerFqn = triggerFqn;
            return this;
        }

        @Generated
        public ReactionStatisticsBuilder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Generated
        public ReactionStatisticsBuilder actionFqn(String actionFqn) {
            this.actionFqn = actionFqn;
            return this;
        }

        @Generated
        public ReactionStatisticsBuilder count(int count) {
            this.count = count;
            return this;
        }

        @Generated
        public ReactionStatisticsBuilder median(double median) {
            this.median = median;
            return this;
        }

        @Generated
        public ReactionStatisticsBuilder percentage(double percentage) {
            this.percentage = percentage;
            return this;
        }

        @Generated
        public ReactionStatistics build() {
            return new ReactionStatistics(this.component, this.triggerType, this.triggerFqn, this.actionType, this.actionFqn, this.count, this.median, this.percentage);
        }

        @Generated
        public String toString() {
            return "ReactionStatistics.ReactionStatisticsBuilder(component=" + String.valueOf(this.component) + ", triggerType=" + this.triggerType + ", triggerFqn=" + this.triggerFqn + ", actionType=" + this.actionType + ", actionFqn=" + this.actionFqn + ", count=" + this.count + ", median=" + this.median + ", percentage=" + this.percentage + ")";
        }
    }
}

