/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.metamodel.system;

import ch.admin.bit.jeap.archrepo.metamodel.Importable;
import ch.admin.bit.jeap.archrepo.metamodel.Importer;
import ch.admin.bit.jeap.archrepo.metamodel.System;
import ch.admin.bit.jeap.archrepo.metamodel.Team;
import ch.admin.bit.jeap.archrepo.metamodel.reaction.ReactionStatistics;
import ch.admin.bit.jeap.archrepo.metamodel.system.SystemComponentType;
import jakarta.persistence.CascadeType;
import jakarta.persistence.DiscriminatorColumn;
import jakarta.persistence.DiscriminatorType;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.validation.constraints.NotNull;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;

@Entity
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="type", discriminatorType=DiscriminatorType.STRING)
public abstract class SystemComponent
implements Importable {
    private static final int NB_OF_DAYS_TO_KEEP_SYSTEM_COMPONENT = 14;
    @Id
    @NotNull
    private UUID id;
    @NonNull
    String name;
    String description;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="team_id")
    Team ownedBy;
    @OneToMany(mappedBy="component", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private List<ReactionStatistics> reactionStatistics;
    @Enumerated(value=EnumType.STRING)
    Importer importer;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="system_id")
    System parent;
    @NotNull
    ZonedDateTime createdAt;
    ZonedDateTime lastSeen;

    public void addReactionStatistics(ReactionStatistics statistics) {
        if (this.reactionStatistics == null) {
            this.reactionStatistics = new ArrayList<ReactionStatistics>();
        }
        this.reactionStatistics.add(statistics);
    }

    public abstract SystemComponentType getType();

    protected SystemComponent(String name) {
        this.id = UUID.randomUUID();
        this.createdAt = ZonedDateTime.now();
        this.name = name;
    }

    public void setLastSeenFromDate(ZonedDateTime zonedDateTime) {
        this.lastSeen = zonedDateTime;
    }

    public void setLastSeenFromNow() {
        this.setLastSeenFromDate(ZonedDateTime.now());
    }

    public boolean isObsolete() {
        if (this.lastSeen == null) {
            return true;
        }
        return this.lastSeen.isBefore(ZonedDateTime.now().minusDays(14L));
    }

    @Override
    public void setImporter(Importer importer) {
        this.importer = importer;
    }

    @Generated
    private static List<ReactionStatistics> $default$reactionStatistics() {
        return new ArrayList<ReactionStatistics>();
    }

    @Generated
    protected SystemComponent(SystemComponentBuilder<?, ?> b) {
        this.id = b.id;
        this.name = b.name;
        if (this.name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.description = b.description;
        this.ownedBy = b.ownedBy;
        this.reactionStatistics = b.reactionStatistics$set ? b.reactionStatistics$value : SystemComponent.$default$reactionStatistics();
        this.importer = b.importer;
        this.parent = b.parent;
        this.createdAt = b.createdAt;
        this.lastSeen = b.lastSeen;
    }

    @Generated
    public SystemComponent() {
        this.reactionStatistics = SystemComponent.$default$reactionStatistics();
    }

    @Generated
    public SystemComponent(UUID id, @NonNull String name, String description, Team ownedBy, List<ReactionStatistics> reactionStatistics, Importer importer, System parent, ZonedDateTime createdAt, ZonedDateTime lastSeen) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.id = id;
        this.name = name;
        this.description = description;
        this.ownedBy = ownedBy;
        this.reactionStatistics = reactionStatistics;
        this.importer = importer;
        this.parent = parent;
        this.createdAt = createdAt;
        this.lastSeen = lastSeen;
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @NonNull
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Team getOwnedBy() {
        return this.ownedBy;
    }

    @Generated
    public List<ReactionStatistics> getReactionStatistics() {
        return this.reactionStatistics;
    }

    @Override
    @Generated
    public Importer getImporter() {
        return this.importer;
    }

    @Generated
    public System getParent() {
        return this.parent;
    }

    @Generated
    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public ZonedDateTime getLastSeen() {
        return this.lastSeen;
    }

    @Generated
    public void setOwnedBy(Team ownedBy) {
        this.ownedBy = ownedBy;
    }

    @Generated
    public void setParent(System parent) {
        this.parent = parent;
    }

    @Generated
    public static abstract class SystemComponentBuilder<C extends SystemComponent, B extends SystemComponentBuilder<C, B>> {
        @Generated
        private UUID id;
        @Generated
        private String name;
        @Generated
        private String description;
        @Generated
        private Team ownedBy;
        @Generated
        private boolean reactionStatistics$set;
        @Generated
        private List<ReactionStatistics> reactionStatistics$value;
        @Generated
        private Importer importer;
        @Generated
        private System parent;
        @Generated
        private ZonedDateTime createdAt;
        @Generated
        private ZonedDateTime lastSeen;

        @Generated
        public B id(UUID id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this.self();
        }

        @Generated
        public B description(String description) {
            this.description = description;
            return this.self();
        }

        @Generated
        public B ownedBy(Team ownedBy) {
            this.ownedBy = ownedBy;
            return this.self();
        }

        @Generated
        public B reactionStatistics(List<ReactionStatistics> reactionStatistics) {
            this.reactionStatistics$value = reactionStatistics;
            this.reactionStatistics$set = true;
            return this.self();
        }

        @Generated
        public B importer(Importer importer) {
            this.importer = importer;
            return this.self();
        }

        @Generated
        public B parent(System parent) {
            this.parent = parent;
            return this.self();
        }

        @Generated
        public B createdAt(ZonedDateTime createdAt) {
            this.createdAt = createdAt;
            return this.self();
        }

        @Generated
        public B lastSeen(ZonedDateTime lastSeen) {
            this.lastSeen = lastSeen;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "SystemComponent.SystemComponentBuilder(id=" + String.valueOf(this.id) + ", name=" + this.name + ", description=" + this.description + ", ownedBy=" + String.valueOf(this.ownedBy) + ", reactionStatistics$value=" + String.valueOf(this.reactionStatistics$value) + ", importer=" + String.valueOf((Object)this.importer) + ", parent=" + String.valueOf(this.parent) + ", createdAt=" + String.valueOf(this.createdAt) + ", lastSeen=" + String.valueOf(this.lastSeen) + ")";
        }
    }
}

