/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.metamodel.relation;

import ch.admin.bit.jeap.archrepo.metamodel.Importer;
import ch.admin.bit.jeap.archrepo.metamodel.Relation;
import ch.admin.bit.jeap.archrepo.metamodel.System;
import ch.admin.bit.jeap.archrepo.metamodel.relation.RelationStatus;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.DiscriminatorColumn;
import jakarta.persistence.DiscriminatorType;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.validation.constraints.NotNull;
import java.util.Collections;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import lombok.Generated;

@Entity(name="relation")
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="type", discriminatorType=DiscriminatorType.STRING)
public abstract class AbstractRelation
implements Relation {
    @Id
    @NotNull
    private UUID id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="system_id")
    private System definingSystem;
    private String providerName;
    private String consumerName;
    @Enumerated(value=EnumType.STRING)
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="relation_importers")
    private SortedSet<Importer> importers;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private RelationStatus status;

    protected AbstractRelation(System definingSystem, String providerName, String consumerName, Importer importer) {
        this.id = UUID.randomUUID();
        this.definingSystem = definingSystem;
        this.providerName = providerName;
        this.consumerName = consumerName;
        this.importers = new TreeSet<Importer>();
        this.addImporter(importer);
        this.status = RelationStatus.ACTIVE;
    }

    @Override
    public void addImporter(Importer importer) {
        if (importer != null) {
            this.importers.add(importer);
        }
    }

    @Override
    public Set<Importer> getImporters() {
        return Collections.unmodifiableSet(this.importers);
    }

    public void markDeleted() {
        this.status = RelationStatus.DELETED;
    }

    @Generated
    private static SortedSet<Importer> $default$importers() {
        return new TreeSet<Importer>();
    }

    @Generated
    protected AbstractRelation(AbstractRelationBuilder<?, ?> b) {
        this.id = b.id;
        this.definingSystem = b.definingSystem;
        this.providerName = b.providerName;
        this.consumerName = b.consumerName;
        this.importers = b.importers$set ? b.importers$value : AbstractRelation.$default$importers();
        this.status = b.status;
    }

    @Generated
    public AbstractRelation() {
        this.importers = AbstractRelation.$default$importers();
    }

    @Override
    @Generated
    public System getDefiningSystem() {
        return this.definingSystem;
    }

    @Override
    @Generated
    public String getProviderName() {
        return this.providerName;
    }

    @Override
    @Generated
    public String getConsumerName() {
        return this.consumerName;
    }

    @Override
    @Generated
    public RelationStatus getStatus() {
        return this.status;
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Override
    @Generated
    public void setDefiningSystem(System definingSystem) {
        this.definingSystem = definingSystem;
    }

    @Generated
    public static abstract class AbstractRelationBuilder<C extends AbstractRelation, B extends AbstractRelationBuilder<C, B>> {
        @Generated
        private UUID id;
        @Generated
        private System definingSystem;
        @Generated
        private String providerName;
        @Generated
        private String consumerName;
        @Generated
        private boolean importers$set;
        @Generated
        private SortedSet<Importer> importers$value;
        @Generated
        private RelationStatus status;

        @Generated
        public B id(UUID id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B definingSystem(System definingSystem) {
            this.definingSystem = definingSystem;
            return this.self();
        }

        @Generated
        public B providerName(String providerName) {
            this.providerName = providerName;
            return this.self();
        }

        @Generated
        public B consumerName(String consumerName) {
            this.consumerName = consumerName;
            return this.self();
        }

        @Generated
        public B importers(SortedSet<Importer> importers) {
            this.importers$value = importers;
            this.importers$set = true;
            return this.self();
        }

        @Generated
        public B status(RelationStatus status) {
            this.status = status;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "AbstractRelation.AbstractRelationBuilder(id=" + String.valueOf(this.id) + ", definingSystem=" + String.valueOf(this.definingSystem) + ", providerName=" + this.providerName + ", consumerName=" + this.consumerName + ", importers$value=" + String.valueOf(this.importers$value) + ", status=" + String.valueOf((Object)this.status) + ")";
        }
    }
}

