/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.metamodel;

import ch.admin.bit.jeap.archrepo.metamodel.Importable;
import ch.admin.bit.jeap.archrepo.metamodel.Importer;
import ch.admin.bit.jeap.archrepo.metamodel.MultipleImportable;
import ch.admin.bit.jeap.archrepo.metamodel.MutableDomainEntity;
import ch.admin.bit.jeap.archrepo.metamodel.Relation;
import ch.admin.bit.jeap.archrepo.metamodel.RemovedElements;
import ch.admin.bit.jeap.archrepo.metamodel.Team;
import ch.admin.bit.jeap.archrepo.metamodel.database.SystemComponentDatabaseSchema;
import ch.admin.bit.jeap.archrepo.metamodel.domainevents.CommandRemoved;
import ch.admin.bit.jeap.archrepo.metamodel.domainevents.EventRemoved;
import ch.admin.bit.jeap.archrepo.metamodel.domainevents.SystemComponentRemoved;
import ch.admin.bit.jeap.archrepo.metamodel.message.Command;
import ch.admin.bit.jeap.archrepo.metamodel.message.Event;
import ch.admin.bit.jeap.archrepo.metamodel.message.MessageType;
import ch.admin.bit.jeap.archrepo.metamodel.relation.AbstractRelation;
import ch.admin.bit.jeap.archrepo.metamodel.relation.CommandRelation;
import ch.admin.bit.jeap.archrepo.metamodel.relation.EventRelation;
import ch.admin.bit.jeap.archrepo.metamodel.relation.RelationStatus;
import ch.admin.bit.jeap.archrepo.metamodel.relation.RestApiRelation;
import ch.admin.bit.jeap.archrepo.metamodel.restapi.OpenApiSpec;
import ch.admin.bit.jeap.archrepo.metamodel.restapi.RestApi;
import ch.admin.bit.jeap.archrepo.metamodel.system.SystemComponent;
import jakarta.persistence.CascadeType;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
public class System
extends MutableDomainEntity {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(System.class);
    @Id
    @NotNull
    private UUID id;
    @NotNull
    private String name;
    private String description;
    private String confluenceLink;
    @ManyToOne(fetch=FetchType.EAGER)
    private Team defaultOwner;
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="system_aliases")
    private List<String> aliases = new ArrayList<String>();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="parent")
    private List<SystemComponent> systemComponents = new ArrayList<SystemComponent>();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="parent")
    private List<Event> events = new ArrayList<Event>();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="parent")
    private List<Command> commands = new ArrayList<Command>();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="definingSystem")
    private List<RestApi> restApis = new ArrayList<RestApi>();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="definingSystem")
    private List<AbstractRelation> relations = new ArrayList<AbstractRelation>();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="definingSystem")
    private List<OpenApiSpec> openApiSpecs = new ArrayList<OpenApiSpec>();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="system")
    private List<SystemComponentDatabaseSchema> databaseSchemas = new ArrayList<SystemComponentDatabaseSchema>();

    private System(String name, String description, String confluenceLink, Team defaultOwner, List<String> aliases, List<SystemComponent> systemComponents, List<Event> events, List<Command> commands, List<RestApi> restApis, List<AbstractRelation> relations) {
        this.id = UUID.randomUUID();
        this.name = name;
        this.description = description;
        this.confluenceLink = confluenceLink;
        this.defaultOwner = defaultOwner;
        this.aliases = aliases;
        this.systemComponents = new ArrayList<SystemComponent>();
        systemComponents.forEach(this::addSystemComponent);
        this.events = new ArrayList<Event>();
        events.forEach(this::addEvent);
        this.commands = new ArrayList<Command>();
        commands.forEach(this::addCommand);
        this.restApis = new ArrayList<RestApi>();
        restApis.forEach(this::addRestApi);
        this.relations = new ArrayList<AbstractRelation>();
        relations.forEach(this::addRelation);
    }

    public static SystemBuilder builder() {
        return new SystemBuilder();
    }

    public List<String> getAliases() {
        return Collections.unmodifiableList(this.aliases);
    }

    public List<Relation> getRelations() {
        return Collections.unmodifiableList(this.relations);
    }

    public List<Relation> getActiveRelations() {
        return this.relations.stream().filter(r -> RelationStatus.ACTIVE.equals((Object)r.getStatus())).collect(Collectors.toUnmodifiableList());
    }

    public List<Event> getEvents() {
        return Collections.unmodifiableList(this.events);
    }

    public List<Command> getCommands() {
        return Collections.unmodifiableList(this.commands);
    }

    public List<RestApi> getRestApis() {
        return Collections.unmodifiableList(this.restApis);
    }

    public List<OpenApiSpec> getOpenApiSpecs() {
        return Collections.unmodifiableList(this.openApiSpecs);
    }

    public List<SystemComponentDatabaseSchema> getDatabaseSchemas() {
        return Collections.unmodifiableList(this.databaseSchemas);
    }

    public void addSystemComponent(SystemComponent systemComponent) {
        if (this.systemComponents.stream().anyMatch(rc -> rc.getName().equalsIgnoreCase(systemComponent.getName()))) {
            throw new IllegalArgumentException("Cannot add duplicate system component " + systemComponent.getName());
        }
        systemComponent.setParent(this);
        this.systemComponents.add(systemComponent);
        this.sortSystemComponents();
    }

    public void sortSystemComponents() {
        this.systemComponents.sort(Comparator.comparing(SystemComponent::getName));
    }

    public void addEvent(Event event) {
        if (this.events.stream().anyMatch(e -> e.getMessageTypeName().equalsIgnoreCase(event.getMessageTypeName()))) {
            throw new IllegalArgumentException("Cannot add duplicate event " + event.getMessageTypeName());
        }
        event.setParent(this);
        this.events.add(event);
        this.events.sort(Comparator.comparing(MessageType::getMessageTypeName));
    }

    public void addCommand(Command command) {
        if (this.commands.stream().anyMatch(e -> e.getMessageTypeName().equalsIgnoreCase(command.getMessageTypeName()))) {
            throw new IllegalArgumentException("Cannot add duplicate command " + command.getMessageTypeName());
        }
        command.setParent(this);
        this.commands.add(command);
        this.commands.sort(Comparator.comparing(MessageType::getMessageTypeName));
    }

    public void addRelation(AbstractRelation relation) {
        if (this.relations.contains(relation)) {
            throw new IllegalArgumentException("Cannot add duplicate relation " + String.valueOf(relation));
        }
        relation.setDefiningSystem(this);
        this.relations.add(relation);
        this.relations.sort(Comparator.comparing(Relation::getType).thenComparing(Relation::getLabel));
    }

    public void addOpenApiSpec(OpenApiSpec openApiSpec) {
        if (this.openApiSpecs.contains(openApiSpec)) {
            throw new IllegalArgumentException("Cannot add duplicate openApiSpec " + String.valueOf(openApiSpec));
        }
        openApiSpec.setDefiningSystem(this);
        this.openApiSpecs.add(openApiSpec);
    }

    public void addDatabaseSchema(SystemComponentDatabaseSchema databaseSchema) {
        if (this != databaseSchema.getSystem()) {
            throw new IllegalArgumentException("Cannot add database schema to different system " + this.getName() + ": " + String.valueOf(databaseSchema));
        }
        if (this.databaseSchemas.contains(databaseSchema)) {
            throw new IllegalArgumentException("Database schema already present: " + String.valueOf(databaseSchema));
        }
        this.databaseSchemas.add(databaseSchema);
    }

    public void addRestApi(RestApi restApi) {
        if (this.restApis.contains(restApi)) {
            throw new IllegalArgumentException("Cannot add duplicate REST API for provider " + String.valueOf(restApi.getProvider()));
        }
        this.restApis.add(restApi);
    }

    public List<SystemComponent> getSystemComponents() {
        return Collections.unmodifiableList(this.systemComponents);
    }

    public Optional<SystemComponent> findSystemComponent(String name) {
        return this.systemComponents.stream().filter(systemComponent -> name.equalsIgnoreCase(systemComponent.getName())).findFirst();
    }

    RemovedElements removeAllByImporter(Importer importer) {
        this.relations.removeAll(MultipleImportable.filterByImportedOnlyByImporter(this.relations, importer));
        this.restApis.removeAll(MultipleImportable.filterByImportedOnlyByImporter(this.restApis, importer));
        HashSet<SystemComponentRemoved> systemComponentRemovedList = new HashSet<SystemComponentRemoved>();
        HashSet<EventRemoved> eventRemovedList = new HashSet<EventRemoved>();
        HashSet<CommandRemoved> commandRemovedList = new HashSet<CommandRemoved>();
        Importable.filterByImporter(this.systemComponents, importer).forEach(sc -> systemComponentRemovedList.add(this.removeSystemComponent((SystemComponent)sc)));
        Importable.filterByImporter(this.events, importer).forEach(e -> eventRemovedList.add(this.removeEvent((Event)e)));
        Importable.filterByImporter(this.commands, importer).forEach(c -> commandRemovedList.add(this.removeCommand((Command)c)));
        return new RemovedElements(systemComponentRemovedList, eventRemovedList, commandRemovedList);
    }

    SystemComponentRemoved removeSystemComponent(SystemComponent systemComponent) {
        this.systemComponents.remove(systemComponent);
        return SystemComponentRemoved.of(systemComponent);
    }

    public EventRemoved removeEvent(Event event) {
        this.events.remove(event);
        return EventRemoved.of(event);
    }

    public CommandRemoved removeCommand(Command command) {
        this.commands.remove(command);
        return CommandRemoved.of(command);
    }

    public void removeRestApiRelation(RestApiRelation restApiRelation) {
        this.relations.remove(restApiRelation);
    }

    public void removeRestApi(RestApi restApi) {
        this.restApis.remove(restApi);
    }

    void onSystemComponentRemoved(SystemComponentRemoved event) {
        String removedSystemComponentName = event.getSystemComponentName();
        this.relations.removeIf(rel -> removedSystemComponentName.equals(rel.getProviderName()) || removedSystemComponentName.equals(rel.getConsumerName()));
        this.restApis.removeIf(restApi -> restApi.getProvider().getName().equals(removedSystemComponentName));
        this.openApiSpecs.removeIf(openApiSpec -> openApiSpec.getProvider().getName().equals(removedSystemComponentName));
    }

    void onEventRemoved(EventRemoved event) {
        String eventName = event.getEventName();
        this.relations.removeIf(rel -> {
            EventRelation er;
            return rel instanceof EventRelation && eventName.equals((er = (EventRelation)rel).getEventName());
        });
    }

    void onCommandRemoved(CommandRemoved event) {
        String commandName = event.getCommandName();
        this.relations.removeIf(rel -> {
            CommandRelation cr;
            return rel instanceof CommandRelation && commandName.equals((cr = (CommandRelation)rel).getCommandName());
        });
    }

    public Optional<MessageType> findMessageType(String messageTypeName) {
        return Stream.concat(this.events.stream(), this.commands.stream()).filter(messageType -> messageType.getMessageTypeName().equalsIgnoreCase(messageTypeName)).findFirst();
    }

    @Generated
    public System() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof System)) {
            return false;
        }
        System other = (System)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$confluenceLink = this.getConfluenceLink();
        String other$confluenceLink = other.getConfluenceLink();
        if (this$confluenceLink == null ? other$confluenceLink != null : !this$confluenceLink.equals(other$confluenceLink)) {
            return false;
        }
        Team this$defaultOwner = this.getDefaultOwner();
        Team other$defaultOwner = other.getDefaultOwner();
        if (this$defaultOwner == null ? other$defaultOwner != null : !this$defaultOwner.equals(other$defaultOwner)) {
            return false;
        }
        List<String> this$aliases = this.getAliases();
        List<String> other$aliases = other.getAliases();
        if (this$aliases == null ? other$aliases != null : !((Object)this$aliases).equals(other$aliases)) {
            return false;
        }
        List<SystemComponent> this$systemComponents = this.getSystemComponents();
        List<SystemComponent> other$systemComponents = other.getSystemComponents();
        if (this$systemComponents == null ? other$systemComponents != null : !((Object)this$systemComponents).equals(other$systemComponents)) {
            return false;
        }
        List<Event> this$events = this.getEvents();
        List<Event> other$events = other.getEvents();
        if (this$events == null ? other$events != null : !((Object)this$events).equals(other$events)) {
            return false;
        }
        List<Command> this$commands = this.getCommands();
        List<Command> other$commands = other.getCommands();
        if (this$commands == null ? other$commands != null : !((Object)this$commands).equals(other$commands)) {
            return false;
        }
        List<RestApi> this$restApis = this.getRestApis();
        List<RestApi> other$restApis = other.getRestApis();
        if (this$restApis == null ? other$restApis != null : !((Object)this$restApis).equals(other$restApis)) {
            return false;
        }
        List<Relation> this$relations = this.getRelations();
        List<Relation> other$relations = other.getRelations();
        if (this$relations == null ? other$relations != null : !((Object)this$relations).equals(other$relations)) {
            return false;
        }
        List<OpenApiSpec> this$openApiSpecs = this.getOpenApiSpecs();
        List<OpenApiSpec> other$openApiSpecs = other.getOpenApiSpecs();
        if (this$openApiSpecs == null ? other$openApiSpecs != null : !((Object)this$openApiSpecs).equals(other$openApiSpecs)) {
            return false;
        }
        List<SystemComponentDatabaseSchema> this$databaseSchemas = this.getDatabaseSchemas();
        List<SystemComponentDatabaseSchema> other$databaseSchemas = other.getDatabaseSchemas();
        return !(this$databaseSchemas == null ? other$databaseSchemas != null : !((Object)this$databaseSchemas).equals(other$databaseSchemas));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof System;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $confluenceLink = this.getConfluenceLink();
        result = result * 59 + ($confluenceLink == null ? 43 : $confluenceLink.hashCode());
        Team $defaultOwner = this.getDefaultOwner();
        result = result * 59 + ($defaultOwner == null ? 43 : $defaultOwner.hashCode());
        List<String> $aliases = this.getAliases();
        result = result * 59 + ($aliases == null ? 43 : ((Object)$aliases).hashCode());
        List<SystemComponent> $systemComponents = this.getSystemComponents();
        result = result * 59 + ($systemComponents == null ? 43 : ((Object)$systemComponents).hashCode());
        List<Event> $events = this.getEvents();
        result = result * 59 + ($events == null ? 43 : ((Object)$events).hashCode());
        List<Command> $commands = this.getCommands();
        result = result * 59 + ($commands == null ? 43 : ((Object)$commands).hashCode());
        List<RestApi> $restApis = this.getRestApis();
        result = result * 59 + ($restApis == null ? 43 : ((Object)$restApis).hashCode());
        List<Relation> $relations = this.getRelations();
        result = result * 59 + ($relations == null ? 43 : ((Object)$relations).hashCode());
        List<OpenApiSpec> $openApiSpecs = this.getOpenApiSpecs();
        result = result * 59 + ($openApiSpecs == null ? 43 : ((Object)$openApiSpecs).hashCode());
        List<SystemComponentDatabaseSchema> $databaseSchemas = this.getDatabaseSchemas();
        result = result * 59 + ($databaseSchemas == null ? 43 : ((Object)$databaseSchemas).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "System(id=" + String.valueOf(this.getId()) + ", name=" + this.getName() + ", description=" + this.getDescription() + ", confluenceLink=" + this.getConfluenceLink() + ", defaultOwner=" + String.valueOf(this.getDefaultOwner()) + ", aliases=" + String.valueOf(this.getAliases()) + ", systemComponents=" + String.valueOf(this.getSystemComponents()) + ", events=" + String.valueOf(this.getEvents()) + ", commands=" + String.valueOf(this.getCommands()) + ", restApis=" + String.valueOf(this.getRestApis()) + ", relations=" + String.valueOf(this.getRelations()) + ", openApiSpecs=" + String.valueOf(this.getOpenApiSpecs()) + ", databaseSchemas=" + String.valueOf(this.getDatabaseSchemas()) + ")";
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getConfluenceLink() {
        return this.confluenceLink;
    }

    @Generated
    public Team getDefaultOwner() {
        return this.defaultOwner;
    }

    @Generated
    public void setDefaultOwner(Team defaultOwner) {
        this.defaultOwner = defaultOwner;
    }

    public static class SystemBuilder {
        private String name;
        private String description;
        private String confluenceLink;
        private Team defaultOwner;
        private List<String> aliases = new ArrayList<String>();
        private List<SystemComponent> systemComponents = new ArrayList<SystemComponent>();
        private List<Event> events = new ArrayList<Event>();
        private List<Command> commands = new ArrayList<Command>();
        private List<RestApi> restApis = new ArrayList<RestApi>();
        private List<AbstractRelation> relations = new ArrayList<AbstractRelation>();

        SystemBuilder() {
        }

        public SystemBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public SystemBuilder description(String description) {
            this.description = description;
            return this;
        }

        public SystemBuilder confluenceLink(String confluenceLink) {
            this.confluenceLink = confluenceLink;
            return this;
        }

        public SystemBuilder defaultOwner(Team defaultOwner) {
            this.defaultOwner = defaultOwner;
            return this;
        }

        public SystemBuilder aliases(List<String> aliases) {
            this.aliases = aliases;
            return this;
        }

        public SystemBuilder systemComponents(List<SystemComponent> systemComponents) {
            this.systemComponents = systemComponents;
            return this;
        }

        public SystemBuilder events(List<Event> events) {
            this.events = events;
            return this;
        }

        public SystemBuilder commands(List<Command> commands) {
            this.commands = commands;
            return this;
        }

        public SystemBuilder restApis(List<RestApi> restApis) {
            this.restApis = restApis;
            return this;
        }

        public SystemBuilder relations(List<AbstractRelation> relations) {
            this.relations = relations;
            return this;
        }

        public System build() {
            return new System(this.name, this.description, this.confluenceLink, this.defaultOwner, this.aliases, this.systemComponents, this.events, this.commands, this.restApis, this.relations);
        }
    }
}

