/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.metamodel.database;

import ch.admin.bit.jeap.archrepo.metamodel.MutableDomainEntity;
import ch.admin.bit.jeap.archrepo.metamodel.System;
import ch.admin.bit.jeap.archrepo.metamodel.system.SystemComponent;
import jakarta.persistence.Basic;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.validation.constraints.NotNull;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;

@Entity
public class SystemComponentDatabaseSchema
extends MutableDomainEntity {
    @Id
    @NotNull
    private UUID id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="system_id")
    private System system;
    @NotNull
    @ManyToOne
    @JoinColumn(name="system_component_id")
    private SystemComponent systemComponent;
    @NotNull
    @Basic(fetch=FetchType.LAZY)
    private byte[] schema;
    @NotNull
    private String schemaVersion;

    public SystemComponentDatabaseSchema(@NonNull SystemComponent systemComponent, byte[] schema, @NonNull String schemaVersion) {
        if (systemComponent == null) {
            throw new NullPointerException("systemComponent is marked non-null but is null");
        }
        if (schemaVersion == null) {
            throw new NullPointerException("schemaVersion is marked non-null but is null");
        }
        Objects.requireNonNull(schema, "schema cannot be null");
        this.id = UUID.randomUUID();
        this.system = systemComponent.getParent();
        this.systemComponent = systemComponent;
        this.schema = schema;
        this.schemaVersion = schemaVersion;
    }

    public SystemComponentDatabaseSchema update(byte[] schema, String version) {
        Objects.requireNonNull(schema, "schema cannot be null");
        Objects.requireNonNull(version, "version cannot be null");
        this.schema = schema;
        this.schemaVersion = version;
        return this;
    }

    public String toString() {
        return "SystemComponentDatabaseSchema{id=" + String.valueOf(this.id) + ", system=" + (this.system != null ? this.system.getName() : "null") + ", systemComponent=" + this.systemComponent.getName() + ", schemaVersion=" + this.schemaVersion + "}";
    }

    @Generated
    public static SystemComponentDatabaseSchemaBuilder builder() {
        return new SystemComponentDatabaseSchemaBuilder();
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public System getSystem() {
        return this.system;
    }

    @Generated
    public SystemComponent getSystemComponent() {
        return this.systemComponent;
    }

    @Generated
    public byte[] getSchema() {
        return this.schema;
    }

    @Generated
    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SystemComponentDatabaseSchema)) {
            return false;
        }
        SystemComponentDatabaseSchema other = (SystemComponentDatabaseSchema)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SystemComponentDatabaseSchema;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    protected SystemComponentDatabaseSchema() {
    }

    @Generated
    public void setSystem(System system) {
        this.system = system;
    }

    @Generated
    public static class SystemComponentDatabaseSchemaBuilder {
        @Generated
        private SystemComponent systemComponent;
        @Generated
        private byte[] schema;
        @Generated
        private String schemaVersion;

        @Generated
        SystemComponentDatabaseSchemaBuilder() {
        }

        @Generated
        public SystemComponentDatabaseSchemaBuilder systemComponent(@NonNull SystemComponent systemComponent) {
            if (systemComponent == null) {
                throw new NullPointerException("systemComponent is marked non-null but is null");
            }
            this.systemComponent = systemComponent;
            return this;
        }

        @Generated
        public SystemComponentDatabaseSchemaBuilder schema(byte[] schema) {
            this.schema = schema;
            return this;
        }

        @Generated
        public SystemComponentDatabaseSchemaBuilder schemaVersion(@NonNull String schemaVersion) {
            if (schemaVersion == null) {
                throw new NullPointerException("schemaVersion is marked non-null but is null");
            }
            this.schemaVersion = schemaVersion;
            return this;
        }

        @Generated
        public SystemComponentDatabaseSchema build() {
            return new SystemComponentDatabaseSchema(this.systemComponent, this.schema, this.schemaVersion);
        }

        @Generated
        public String toString() {
            return "SystemComponentDatabaseSchema.SystemComponentDatabaseSchemaBuilder(systemComponent=" + String.valueOf(this.systemComponent) + ", schema=" + Arrays.toString(this.schema) + ", schemaVersion=" + this.schemaVersion + ")";
        }
    }
}

