/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.metamodel.system;

import ch.admin.bit.jeap.archrepo.metamodel.Importer;
import ch.admin.bit.jeap.archrepo.metamodel.System;
import ch.admin.bit.jeap.archrepo.metamodel.system.BackendService;
import ch.admin.bit.jeap.archrepo.metamodel.system.Frontend;
import ch.admin.bit.jeap.archrepo.metamodel.system.SelfContainedSystem;
import ch.admin.bit.jeap.archrepo.metamodel.system.SystemComponent;
import java.time.ZonedDateTime;
import lombok.Generated;

public final class SystemComponentFactory {
    public static SystemComponent createSystemComponent(System system, String cfAppName, Importer importer) {
        SystemComponent systemComponent = SystemComponentFactory.createByName(cfAppName);
        systemComponent.setImporter(importer);
        systemComponent.setOwnedBy(system.getDefaultOwner());
        systemComponent.setLastSeenFromDate(ZonedDateTime.now());
        system.addSystemComponent(systemComponent);
        return systemComponent;
    }

    private static SystemComponent createByName(String cfAppName) {
        if (cfAppName.endsWith("-ui") || cfAppName.endsWith("-frontend") || cfAppName.endsWith("-webui")) {
            return new Frontend(cfAppName);
        }
        if (cfAppName.endsWith("-scs")) {
            return new SelfContainedSystem(cfAppName);
        }
        return new BackendService(cfAppName);
    }

    @Generated
    private SystemComponentFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

