/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.metamodel;

import ch.admin.bit.jeap.archrepo.metamodel.ArchitectureModel;
import ch.admin.bit.jeap.archrepo.metamodel.MultipleImportable;
import ch.admin.bit.jeap.archrepo.metamodel.relation.RestApiRelation;
import ch.admin.bit.jeap.archrepo.metamodel.restapi.RestApi;
import ch.admin.bit.jeap.archrepo.metamodel.system.SystemComponent;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ArchitectureModelHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ArchitectureModelHelper.class);

    public static Optional<SystemComponent> findComponentByNameWithSystemPrefix(ArchitectureModel model, String name, Pattern nameParts) {
        Matcher matcher = nameParts.matcher(name);
        if (matcher.matches()) {
            String systemName = matcher.group("system");
            String componentName = systemName + "-" + matcher.group("component");
            return model.findSystem(systemName).flatMap(system -> system.findSystemComponent(componentName)).or(() -> model.findSystemComponent(componentName));
        }
        return Optional.empty();
    }

    static void cleanup(ArchitectureModel model) {
        ArchitectureModelHelper.removeOutdatedImportedRestRelations(model);
        ArchitectureModelHelper.removeNotReferencedRestApis(model);
    }

    private static void removeOutdatedImportedRestRelations(ArchitectureModel model) {
        ZonedDateTime deleteBeforeDate = ZonedDateTime.now().minusMonths(3L);
        model.getAllRelationsByType(RestApiRelation.class).stream().filter(ArchitectureModelHelper::isImported).filter(ArchitectureModelHelper.lastSeenBefore(deleteBeforeDate)).forEach(restApiRelation -> restApiRelation.getDefiningSystem().removeRestApiRelation((RestApiRelation)restApiRelation));
    }

    private static void removeNotReferencedRestApis(ArchitectureModel model) {
        Set allRestApiIds = model.getAllRelationsByType(RestApiRelation.class).stream().map(relation -> relation.getRestApi().getId()).collect(Collectors.toSet());
        model.getAllRestApis().stream().filter(restApi -> !allRestApiIds.contains(restApi.getId())).forEach(restApi -> restApi.getDefiningSystem().removeRestApi((RestApi)restApi));
    }

    private static Predicate<RestApiRelation> lastSeenBefore(ZonedDateTime deleteBeforeDate) {
        return restApiRelation -> restApiRelation.getLastSeen() == null || restApiRelation.getLastSeen().isBefore(deleteBeforeDate);
    }

    private static boolean isImported(MultipleImportable importable) {
        return !importable.getImporters().isEmpty();
    }

    @Generated
    private ArchitectureModelHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

