/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.metamodel.message;

import ch.admin.bit.jeap.archrepo.metamodel.Importable;
import ch.admin.bit.jeap.archrepo.metamodel.Importer;
import ch.admin.bit.jeap.archrepo.metamodel.System;
import ch.admin.bit.jeap.archrepo.metamodel.message.MessageVersion;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.DiscriminatorColumn;
import jakarta.persistence.DiscriminatorType;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;

@Entity
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="type", discriminatorType=DiscriminatorType.STRING)
public abstract class MessageType
implements Importable {
    @Id
    @NotNull
    private UUID id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="system_id")
    System parent;
    @Enumerated(value=EnumType.STRING)
    private Importer importer;
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="message_type_versions")
    @NonNull
    private List<MessageVersion> messageVersions;
    private String topic;
    @NonNull
    private String scope;
    @NonNull
    private String messageTypeName;
    @NonNull
    private String descriptorUrl;
    private String description;
    private String documentationUrl;

    public void setDocumentationUrl(String documentationUrl) {
        if (documentationUrl == null || documentationUrl.isEmpty()) {
            return;
        }
        this.documentationUrl = documentationUrl;
    }

    public abstract Set<String> getComponentNamesWithContract();

    @Generated
    protected MessageType(MessageTypeBuilder<?, ?> b) {
        this.id = b.id;
        this.parent = b.parent;
        this.importer = b.importer;
        this.messageVersions = b.messageVersions;
        if (this.messageVersions == null) {
            throw new NullPointerException("messageVersions is marked non-null but is null");
        }
        this.topic = b.topic;
        this.scope = b.scope;
        if (this.scope == null) {
            throw new NullPointerException("scope is marked non-null but is null");
        }
        this.messageTypeName = b.messageTypeName;
        if (this.messageTypeName == null) {
            throw new NullPointerException("messageTypeName is marked non-null but is null");
        }
        this.descriptorUrl = b.descriptorUrl;
        if (this.descriptorUrl == null) {
            throw new NullPointerException("descriptorUrl is marked non-null but is null");
        }
        this.description = b.description;
        this.documentationUrl = b.documentationUrl;
    }

    @Generated
    public MessageType(UUID id, System parent, Importer importer, @NonNull List<MessageVersion> messageVersions, String topic, @NonNull String scope, @NonNull String messageTypeName, @NonNull String descriptorUrl, String description, String documentationUrl) {
        if (messageVersions == null) {
            throw new NullPointerException("messageVersions is marked non-null but is null");
        }
        if (scope == null) {
            throw new NullPointerException("scope is marked non-null but is null");
        }
        if (messageTypeName == null) {
            throw new NullPointerException("messageTypeName is marked non-null but is null");
        }
        if (descriptorUrl == null) {
            throw new NullPointerException("descriptorUrl is marked non-null but is null");
        }
        this.id = id;
        this.parent = parent;
        this.importer = importer;
        this.messageVersions = messageVersions;
        this.topic = topic;
        this.scope = scope;
        this.messageTypeName = messageTypeName;
        this.descriptorUrl = descriptorUrl;
        this.description = description;
        this.documentationUrl = documentationUrl;
    }

    @Generated
    public MessageType() {
    }

    @Generated
    public System getParent() {
        return this.parent;
    }

    @Override
    @Generated
    public Importer getImporter() {
        return this.importer;
    }

    @NonNull
    @Generated
    public List<MessageVersion> getMessageVersions() {
        return this.messageVersions;
    }

    @Generated
    public String getTopic() {
        return this.topic;
    }

    @NonNull
    @Generated
    public String getScope() {
        return this.scope;
    }

    @NonNull
    @Generated
    public String getMessageTypeName() {
        return this.messageTypeName;
    }

    @NonNull
    @Generated
    public String getDescriptorUrl() {
        return this.descriptorUrl;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getDocumentationUrl() {
        return this.documentationUrl;
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public void setParent(System parent) {
        this.parent = parent;
    }

    @Override
    @Generated
    public void setImporter(Importer importer) {
        this.importer = importer;
    }

    @Generated
    public static abstract class MessageTypeBuilder<C extends MessageType, B extends MessageTypeBuilder<C, B>> {
        @Generated
        private UUID id;
        @Generated
        private System parent;
        @Generated
        private Importer importer;
        @Generated
        private List<MessageVersion> messageVersions;
        @Generated
        private String topic;
        @Generated
        private String scope;
        @Generated
        private String messageTypeName;
        @Generated
        private String descriptorUrl;
        @Generated
        private String description;
        @Generated
        private String documentationUrl;

        @Generated
        protected B $fillValuesFrom(C instance) {
            MessageTypeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(MessageType instance, MessageTypeBuilder<?, ?> b) {
            b.id(instance.id);
            b.parent(instance.parent);
            b.importer(instance.importer);
            b.messageVersions(instance.messageVersions);
            b.topic(instance.topic);
            b.scope(instance.scope);
            b.messageTypeName(instance.messageTypeName);
            b.descriptorUrl(instance.descriptorUrl);
            b.description(instance.description);
            b.documentationUrl(instance.documentationUrl);
        }

        @Generated
        public B id(UUID id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B parent(System parent) {
            this.parent = parent;
            return this.self();
        }

        @Generated
        public B importer(Importer importer) {
            this.importer = importer;
            return this.self();
        }

        @Generated
        public B messageVersions(@NonNull List<MessageVersion> messageVersions) {
            if (messageVersions == null) {
                throw new NullPointerException("messageVersions is marked non-null but is null");
            }
            this.messageVersions = messageVersions;
            return this.self();
        }

        @Generated
        public B topic(String topic) {
            this.topic = topic;
            return this.self();
        }

        @Generated
        public B scope(@NonNull String scope) {
            if (scope == null) {
                throw new NullPointerException("scope is marked non-null but is null");
            }
            this.scope = scope;
            return this.self();
        }

        @Generated
        public B messageTypeName(@NonNull String messageTypeName) {
            if (messageTypeName == null) {
                throw new NullPointerException("messageTypeName is marked non-null but is null");
            }
            this.messageTypeName = messageTypeName;
            return this.self();
        }

        @Generated
        public B descriptorUrl(@NonNull String descriptorUrl) {
            if (descriptorUrl == null) {
                throw new NullPointerException("descriptorUrl is marked non-null but is null");
            }
            this.descriptorUrl = descriptorUrl;
            return this.self();
        }

        @Generated
        public B description(String description) {
            this.description = description;
            return this.self();
        }

        @Generated
        public B documentationUrl(String documentationUrl) {
            this.documentationUrl = documentationUrl;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "MessageType.MessageTypeBuilder(id=" + String.valueOf(this.id) + ", parent=" + String.valueOf(this.parent) + ", importer=" + String.valueOf((Object)this.importer) + ", messageVersions=" + String.valueOf(this.messageVersions) + ", topic=" + this.topic + ", scope=" + this.scope + ", messageTypeName=" + this.messageTypeName + ", descriptorUrl=" + this.descriptorUrl + ", description=" + this.description + ", documentationUrl=" + this.documentationUrl + ")";
        }
    }
}

