/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.metamodel.restapi;

import ch.admin.bit.jeap.archrepo.metamodel.MutableDomainEntity;
import ch.admin.bit.jeap.archrepo.metamodel.System;
import ch.admin.bit.jeap.archrepo.metamodel.system.SystemComponent;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.validation.constraints.NotNull;
import java.util.Arrays;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;

@Entity
public class OpenApiSpec
extends MutableDomainEntity {
    @Id
    @NotNull
    private UUID id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="system_id")
    private System definingSystem;
    @NotNull
    @ManyToOne(fetch=FetchType.EAGER)
    private SystemComponent provider;
    private String version;
    private String serverUrl;
    private byte[] content;

    public OpenApiSpec(@NonNull SystemComponent provider, String version, byte[] content, String serverUrl) {
        if (provider == null) {
            throw new NullPointerException("provider is marked non-null but is null");
        }
        this.id = UUID.randomUUID();
        this.definingSystem = provider.getParent();
        this.provider = provider;
        this.version = version;
        this.content = content;
        this.serverUrl = serverUrl;
    }

    public void update(byte[] content, String version, String serverUrl) {
        this.content = content;
        this.version = version;
        this.serverUrl = serverUrl;
    }

    @Generated
    public static OpenApiSpecBuilder builder() {
        return new OpenApiSpecBuilder();
    }

    @Generated
    public OpenApiSpec() {
    }

    @Generated
    public String toString() {
        return "OpenApiSpec(id=" + String.valueOf(this.getId()) + ", version=" + this.getVersion() + ", serverUrl=" + this.getServerUrl() + ")";
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public System getDefiningSystem() {
        return this.definingSystem;
    }

    @Generated
    public SystemComponent getProvider() {
        return this.provider;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getServerUrl() {
        return this.serverUrl;
    }

    @Generated
    public byte[] getContent() {
        return this.content;
    }

    @Generated
    public void setDefiningSystem(System definingSystem) {
        this.definingSystem = definingSystem;
    }

    @Generated
    public static class OpenApiSpecBuilder {
        @Generated
        private SystemComponent provider;
        @Generated
        private String version;
        @Generated
        private byte[] content;
        @Generated
        private String serverUrl;

        @Generated
        OpenApiSpecBuilder() {
        }

        @Generated
        public OpenApiSpecBuilder provider(@NonNull SystemComponent provider) {
            if (provider == null) {
                throw new NullPointerException("provider is marked non-null but is null");
            }
            this.provider = provider;
            return this;
        }

        @Generated
        public OpenApiSpecBuilder version(String version) {
            this.version = version;
            return this;
        }

        @Generated
        public OpenApiSpecBuilder content(byte[] content) {
            this.content = content;
            return this;
        }

        @Generated
        public OpenApiSpecBuilder serverUrl(String serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        @Generated
        public OpenApiSpec build() {
            return new OpenApiSpec(this.provider, this.version, this.content, this.serverUrl);
        }

        @Generated
        public String toString() {
            return "OpenApiSpec.OpenApiSpecBuilder(provider=" + String.valueOf(this.provider) + ", version=" + this.version + ", content=" + Arrays.toString(this.content) + ", serverUrl=" + this.serverUrl + ")";
        }
    }
}

