/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.metamodel.message;

import ch.admin.bit.jeap.archrepo.metamodel.MutableDomainEntity;
import com.fasterxml.uuid.Generators;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Lob;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import java.util.Arrays;
import java.util.UUID;
import lombok.Generated;

@Entity
@Table(name="message_graph")
public class MessageGraph
extends MutableDomainEntity {
    @Id
    @NotNull
    private UUID id;
    @NotNull
    @Column(name="message_type_name")
    private String messageTypeName;
    @NotNull
    @Column(name="variant")
    private String variant;
    @Lob
    @Column(name="graph_data")
    private byte[] graphData;
    private String fingerprint;

    protected MessageGraph() {
    }

    public MessageGraph(String messageTypeName, String variant, byte[] graphData, String fingerprint) {
        this.id = Generators.timeBasedEpochGenerator().generate();
        this.messageTypeName = messageTypeName;
        this.variant = variant;
        this.graphData = graphData;
        this.fingerprint = fingerprint;
    }

    @Generated
    public static MessageGraphBuilder builder() {
        return new MessageGraphBuilder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageGraph)) {
            return false;
        }
        MessageGraph other = (MessageGraph)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$messageTypeName = this.getMessageTypeName();
        String other$messageTypeName = other.getMessageTypeName();
        if (this$messageTypeName == null ? other$messageTypeName != null : !this$messageTypeName.equals(other$messageTypeName)) {
            return false;
        }
        String this$variant = this.getVariant();
        String other$variant = other.getVariant();
        if (this$variant == null ? other$variant != null : !this$variant.equals(other$variant)) {
            return false;
        }
        if (!Arrays.equals(this.getGraphData(), other.getGraphData())) {
            return false;
        }
        String this$fingerprint = this.getFingerprint();
        String other$fingerprint = other.getFingerprint();
        return !(this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MessageGraph;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $messageTypeName = this.getMessageTypeName();
        result = result * 59 + ($messageTypeName == null ? 43 : $messageTypeName.hashCode());
        String $variant = this.getVariant();
        result = result * 59 + ($variant == null ? 43 : $variant.hashCode());
        result = result * 59 + Arrays.hashCode(this.getGraphData());
        String $fingerprint = this.getFingerprint();
        result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MessageGraph(id=" + String.valueOf(this.getId()) + ", messageTypeName=" + this.getMessageTypeName() + ", variant=" + this.getVariant() + ", graphData=" + Arrays.toString(this.getGraphData()) + ", fingerprint=" + this.getFingerprint() + ")";
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public String getMessageTypeName() {
        return this.messageTypeName;
    }

    @Generated
    public String getVariant() {
        return this.variant;
    }

    @Generated
    public byte[] getGraphData() {
        return this.graphData;
    }

    @Generated
    public String getFingerprint() {
        return this.fingerprint;
    }

    @Generated
    public static class MessageGraphBuilder {
        @Generated
        private String messageTypeName;
        @Generated
        private String variant;
        @Generated
        private byte[] graphData;
        @Generated
        private String fingerprint;

        @Generated
        MessageGraphBuilder() {
        }

        @Generated
        public MessageGraphBuilder messageTypeName(String messageTypeName) {
            this.messageTypeName = messageTypeName;
            return this;
        }

        @Generated
        public MessageGraphBuilder variant(String variant) {
            this.variant = variant;
            return this;
        }

        @Generated
        public MessageGraphBuilder graphData(byte[] graphData) {
            this.graphData = graphData;
            return this;
        }

        @Generated
        public MessageGraphBuilder fingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        @Generated
        public MessageGraph build() {
            return new MessageGraph(this.messageTypeName, this.variant, this.graphData, this.fingerprint);
        }

        @Generated
        public String toString() {
            return "MessageGraph.MessageGraphBuilder(messageTypeName=" + this.messageTypeName + ", variant=" + this.variant + ", graphData=" + Arrays.toString(this.graphData) + ", fingerprint=" + this.fingerprint + ")";
        }
    }
}

