/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.metamodel.system;

import ch.admin.bit.jeap.archrepo.metamodel.MutableDomainEntity;
import com.fasterxml.uuid.Generators;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Lob;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import java.util.Arrays;
import java.util.UUID;
import lombok.Generated;

@Entity
@Table(name="component_graph")
public class ComponentGraph
extends MutableDomainEntity {
    @Id
    @NotNull
    private UUID id;
    @NotNull
    @Column(name="system_name")
    private String systemName;
    @NotNull
    @Column(name="component_name")
    private String componentName;
    @Lob
    @Column(name="graph_data")
    private byte[] graphData;
    private String fingerprint;

    protected ComponentGraph() {
    }

    public ComponentGraph(String systemName, String componentName, byte[] graphData, String fingerprint) {
        this.id = Generators.timeBasedEpochGenerator().generate();
        this.systemName = systemName;
        this.componentName = componentName;
        this.graphData = graphData;
        this.fingerprint = fingerprint;
    }

    @Generated
    public static ComponentGraphBuilder builder() {
        return new ComponentGraphBuilder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComponentGraph)) {
            return false;
        }
        ComponentGraph other = (ComponentGraph)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$systemName = this.getSystemName();
        String other$systemName = other.getSystemName();
        if (this$systemName == null ? other$systemName != null : !this$systemName.equals(other$systemName)) {
            return false;
        }
        String this$componentName = this.getComponentName();
        String other$componentName = other.getComponentName();
        if (this$componentName == null ? other$componentName != null : !this$componentName.equals(other$componentName)) {
            return false;
        }
        if (!Arrays.equals(this.getGraphData(), other.getGraphData())) {
            return false;
        }
        String this$fingerprint = this.getFingerprint();
        String other$fingerprint = other.getFingerprint();
        return !(this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ComponentGraph;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $systemName = this.getSystemName();
        result = result * 59 + ($systemName == null ? 43 : $systemName.hashCode());
        String $componentName = this.getComponentName();
        result = result * 59 + ($componentName == null ? 43 : $componentName.hashCode());
        result = result * 59 + Arrays.hashCode(this.getGraphData());
        String $fingerprint = this.getFingerprint();
        result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ComponentGraph(id=" + String.valueOf(this.getId()) + ", systemName=" + this.getSystemName() + ", componentName=" + this.getComponentName() + ", graphData=" + Arrays.toString(this.getGraphData()) + ", fingerprint=" + this.getFingerprint() + ")";
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public String getSystemName() {
        return this.systemName;
    }

    @Generated
    public String getComponentName() {
        return this.componentName;
    }

    @Generated
    public byte[] getGraphData() {
        return this.graphData;
    }

    @Generated
    public String getFingerprint() {
        return this.fingerprint;
    }

    @Generated
    public static class ComponentGraphBuilder {
        @Generated
        private String systemName;
        @Generated
        private String componentName;
        @Generated
        private byte[] graphData;
        @Generated
        private String fingerprint;

        @Generated
        ComponentGraphBuilder() {
        }

        @Generated
        public ComponentGraphBuilder systemName(String systemName) {
            this.systemName = systemName;
            return this;
        }

        @Generated
        public ComponentGraphBuilder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        @Generated
        public ComponentGraphBuilder graphData(byte[] graphData) {
            this.graphData = graphData;
            return this;
        }

        @Generated
        public ComponentGraphBuilder fingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        @Generated
        public ComponentGraph build() {
            return new ComponentGraph(this.systemName, this.componentName, this.graphData, this.fingerprint);
        }

        @Generated
        public String toString() {
            return "ComponentGraph.ComponentGraphBuilder(systemName=" + this.systemName + ", componentName=" + this.componentName + ", graphData=" + Arrays.toString(this.graphData) + ", fingerprint=" + this.fingerprint + ")";
        }
    }
}

