/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.metamodel.message;

import ch.admin.bit.jeap.archrepo.metamodel.message.MessageType;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.validation.constraints.NotNull;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import lombok.Generated;

@Entity
public class MessageContract {
    @Id
    @NotNull
    private UUID id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="message_sender_id")
    private MessageType messageSender;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="message_receiver_id")
    private MessageType messageReceiver;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="message_publisher_id")
    private MessageType messagePublisher;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="message_consumer_id")
    private MessageType messageConsumer;
    private String versions;
    private String componentName;
    private String topic;

    public MessageContract(List<String> version, String componentName, String topic) {
        this.id = UUID.randomUUID();
        this.versions = String.join((CharSequence)",", version);
        this.componentName = componentName;
        this.topic = topic;
    }

    public List<String> versionList() {
        return Arrays.stream(this.versions.split(",")).toList();
    }

    @Generated
    public static MessageContractBuilder builder() {
        return new MessageContractBuilder();
    }

    @Generated
    public MessageContract() {
    }

    @Generated
    public MessageType getMessageSender() {
        return this.messageSender;
    }

    @Generated
    public MessageType getMessageReceiver() {
        return this.messageReceiver;
    }

    @Generated
    public MessageType getMessagePublisher() {
        return this.messagePublisher;
    }

    @Generated
    public MessageType getMessageConsumer() {
        return this.messageConsumer;
    }

    @Generated
    public String getVersions() {
        return this.versions;
    }

    @Generated
    public String getComponentName() {
        return this.componentName;
    }

    @Generated
    public String getTopic() {
        return this.topic;
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public void setMessageSender(MessageType messageSender) {
        this.messageSender = messageSender;
    }

    @Generated
    public void setMessageReceiver(MessageType messageReceiver) {
        this.messageReceiver = messageReceiver;
    }

    @Generated
    public void setMessagePublisher(MessageType messagePublisher) {
        this.messagePublisher = messagePublisher;
    }

    @Generated
    public void setMessageConsumer(MessageType messageConsumer) {
        this.messageConsumer = messageConsumer;
    }

    @Generated
    public static class MessageContractBuilder {
        @Generated
        private List<String> version;
        @Generated
        private String componentName;
        @Generated
        private String topic;

        @Generated
        MessageContractBuilder() {
        }

        @Generated
        public MessageContractBuilder version(List<String> version) {
            this.version = version;
            return this;
        }

        @Generated
        public MessageContractBuilder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        @Generated
        public MessageContractBuilder topic(String topic) {
            this.topic = topic;
            return this;
        }

        @Generated
        public MessageContract build() {
            return new MessageContract(this.version, this.componentName, this.topic);
        }

        @Generated
        public String toString() {
            return "MessageContract.MessageContractBuilder(version=" + String.valueOf(this.version) + ", componentName=" + this.componentName + ", topic=" + this.topic + ")";
        }
    }
}

